/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.unit;

import com.pnf.plugin.pdf.AddressUtils;
import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.document.TreePdfDocument;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.pnf.plugin.pdf.unit.AbstractStreamUnit;
import com.pnf.plugin.pdf.unit.IPdfUnit;
import com.pnfsoftware.jeb.core.output.AbstractTransientUnitRepresentation;
import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterUtil;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.List;

@Ser
public class PdfObjStmUnit
extends AbstractStreamUnit
implements IPdfUnit {
    @SerTransient
    private List<PdfIndirectObj> objects;
    @SerTransient
    private AddressUtils addressManager;

    public PdfObjStmUnit(IUnit parent, PdfStream stream, String identifier, PdfStatistics statistics) {
        super(parent, stream, identifier, statistics);
        if (stream.hasExtendedStream()) {
            for (PdfIndirectObj streamO : stream.getExtendedByList()) {
                PdfStream substream = (PdfStream)streamO.getAttribute();
                PdfObjStmUnit streamUnit = new PdfObjStmUnit((IUnit)this, substream, identifier, statistics);
                this.addChild((IUnit)streamUnit);
            }
        }
    }

    public boolean process() {
        this.setProcessed(true);
        return true;
    }

    @Override
    public IUnitFormatter getFormatter() {
        IUnitFormatter formatter = super.getFormatter();
        if (UnitFormatterUtil.getPresentationByName((IUnitFormatter)formatter, (String)"ObjStm Tree") == null) {
            formatter.insertPresentation(0, (IUnitDocumentPresentation)new AbstractTransientUnitRepresentation("ObjStm Tree", true){

                public IGenericDocument createDocument() {
                    TreePdfDocument document = new TreePdfDocument(PdfObjStmUnit.this.getObjectList(), PdfObjStmUnit.this);
                    return document;
                }
            }, false);
        }
        return formatter;
    }

    public List<PdfIndirectObj> getObjectList() {
        if (this.objects == null) {
            this.objects = this.stream.getObjStmList();
        }
        return this.objects;
    }

    @Override
    public AddressUtils getAddressUtils() {
        if (this.addressManager == null) {
            this.addressManager = new AddressUtils(this.objects);
        }
        return this.addressManager;
    }
}

