/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.parser;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class PdfSpecialCharacters {
    public static final byte[] EMPTY_ARRAY = new byte[0];
    public static final byte[] OBJ_START_SEPARATOR = new byte[]{111, 98, 106};
    public static final byte[] OBJ_END_SEPARATOR = new byte[]{101, 110, 100, 111, 98, 106};
    public static final byte[] STREAM_START_SEPARATOR = new byte[]{115, 116, 114, 101, 97, 109};
    public static final byte[] STREAM_END_SEPARATOR = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    public static final byte[] TRAILER_START_SEPARATOR = "trailer".getBytes();
    public static final byte[] XREF_START_SEPARATOR = "startxref".getBytes();
    public static final byte[] XREF_SEPARATOR = "xref".getBytes();
    public static final byte[] PDF_HEADER = "%PDF".getBytes();
    public static final byte[] EOF = "%%EOF".getBytes();
    private static final ILogger logger = GlobalLog.getLogger(PdfSpecialCharacters.class);

    public static boolean isSeparator(byte[] data, int cursor) {
        if (cursor >= data.length) {
            return true;
        }
        return PdfSpecialCharacters.isSeparator(data[cursor]);
    }

    public static boolean isSeparator(byte b) {
        return b == 0 || b == 9 || b == 10 || b == 12 || b == 13 || b == 32;
    }

    public static int jumpSeparators(byte[] data, int cursor) {
        while (PdfSpecialCharacters.isSeparator(data, cursor) && cursor < data.length) {
            ++cursor;
        }
        return cursor;
    }

    public static int testEndLine(byte[] data, int cursor) {
        if (cursor >= data.length) {
            return 0;
        }
        if (data[cursor] == 10) {
            return 1;
        }
        if (data[cursor] == 13) {
            if (cursor + 1 >= data.length) {
                return 1;
            }
            if (data[cursor + 1] == 10) {
                return 2;
            }
            return 1;
        }
        return -1;
    }

    public static int testPreviousEndLine(byte[] data, int cursor) {
        if (cursor < 0) {
            return 0;
        }
        if (data[cursor] == 10) {
            if (cursor == 0) {
                return 1;
            }
            if (data[cursor - 1] == 13) {
                return 2;
            }
            return 1;
        }
        if (data[cursor] == 13) {
            return 1;
        }
        return -1;
    }

    public static boolean isChar(byte[] data, int cursor, char expected) {
        if (cursor >= data.length) {
            return false;
        }
        return (char)data[cursor] == expected;
    }

    public static boolean isEndComment(byte[] data, int cursor) {
        if (cursor >= data.length) {
            return true;
        }
        return PdfSpecialCharacters.isEndComment(data[cursor]);
    }

    public static boolean isEndComment(byte b) {
        return PdfSpecialCharacters.isEndLine(b) || b == 0 || b == 12;
    }

    public static boolean isEndLine(byte b) {
        return b == 10 || b == 13;
    }

    public static boolean isDelimitorOrSeparator(byte[] data, int cursor) {
        if (cursor >= data.length) {
            return true;
        }
        return PdfSpecialCharacters.isDelimitor(data[cursor]) || PdfSpecialCharacters.isSeparator(data[cursor]);
    }

    public static boolean isDelimitor(byte b) {
        return b == 40 || b == 41 || b == 60 || b == 62 || b == 91 || b == 93 || b == 123 || b == 125 || b == 47 || b == 37;
    }

    public static boolean isComment(byte b) {
        return b == 37;
    }

    public static boolean isStartObj(byte[] data, int i) {
        return PdfSpecialCharacters.isObj(data, i, OBJ_START_SEPARATOR, true);
    }

    public static boolean isEndObj(byte[] data, int i) {
        return PdfSpecialCharacters.isObj(data, i, OBJ_END_SEPARATOR, true);
    }

    public static boolean isStartStream(byte[] data, int i) {
        return PdfSpecialCharacters.isObj(data, i, STREAM_START_SEPARATOR, true);
    }

    public static boolean isEndStream(byte[] data, int i) {
        return PdfSpecialCharacters.isObj(data, i, STREAM_END_SEPARATOR, false);
    }

    public static boolean isStartTrailer(byte[] data, int i) {
        return PdfSpecialCharacters.isObj(data, i, TRAILER_START_SEPARATOR, true);
    }

    public static boolean isStartXref(byte[] data, int i) {
        return PdfSpecialCharacters.isObj(data, i, XREF_START_SEPARATOR, true);
    }

    public static boolean isXref(byte[] data, int i) {
        return PdfSpecialCharacters.isObj(data, i, XREF_SEPARATOR, true);
    }

    public static boolean isEOF(byte[] data, int i) {
        return PdfSpecialCharacters.isObj(data, i, EOF, true);
    }

    private static boolean isObj(byte[] data, int i, byte[] objSeparator, boolean previousCharShallBeSeparator) {
        if (i + objSeparator.length > data.length) {
            return false;
        }
        for (int j = 0; j < objSeparator.length; ++j) {
            if (data[i + j] == objSeparator[j]) continue;
            return false;
        }
        if (previousCharShallBeSeparator && i > 0 && !PdfSpecialCharacters.isDelimitorOrSeparator(data, i - 1)) {
            return false;
        }
        if (i + objSeparator.length <= data.length || PdfSpecialCharacters.isDelimitorOrSeparator(data, i + objSeparator.length)) {
            return true;
        }
        logger.error("%s is not at index %x", new Object[]{new String(objSeparator), i});
        return false;
    }
}

