/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.parser;

import com.pnf.plugin.pdf.PdfFileUnit;
import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfArray;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfDictionaryAttribute;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfIndirectOjbStm;
import com.pnf.plugin.pdf.obj.PdfIndirectReference;
import com.pnf.plugin.pdf.obj.PdfNumber;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.pnf.plugin.pdf.obj.PdfString;
import com.pnf.plugin.pdf.obj.PdfTrailer;
import com.pnf.plugin.pdf.parser.PdfAttributeValue;
import com.pnf.plugin.pdf.parser.PdfComment;
import com.pnf.plugin.pdf.parser.PdfFile;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnf.plugin.pdf.parser.StartObjFoundException;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class PdfParser {
    private static final ILogger logger = GlobalLog.getLogger(PdfParser.class);
    private String version = "";
    private Set<PdfStream> streams = new TreeSet<PdfStream>();
    private List<PdfString> strings = new ArrayList<PdfString>();
    private final PdfFileUnit unit;
    private int trailerCount = 0;
    private List<Object> simpleView = new ArrayList<Object>();

    public PdfParser(PdfFileUnit unit) {
        this.unit = unit;
    }

    public void parse(InputStream data) throws IOException {
        this.parseBytes(data);
        logger.debug("PDF Ojbect parsing terminated. Parsing streams...", new Object[0]);
        PdfStatistics statistics = this.unit.getStatistics();
        statistics.setVersion(this.version);
        statistics.setNbIndirectObjects(this.unit.getObjects().size());
        this.processObjStm();
        this.processDecryptionAndDecoding();
        statistics.setNbStreams(this.streams.size());
        statistics.setNbStreamedObjects(this.unit.getObjects().size() - statistics.getNbIndirectObjects());
        this.processFuntional();
        logger.debug("PDF Streams parsed successfully.", new Object[0]);
        logger.debug("Found %d indirect objects", new Object[]{this.unit.getObjects().size()});
    }

    private void parseBytes(InputStream input) throws IOException {
        int cursor = 0;
        byte[] data = IO.readInputStream((InputStream)input);
        if (data.length > 8 && PdfSpecialCharacters.isComment(data[0]) && data[1] == 80 && data[2] == 68 && data[3] == 70 && data[4] == 45) {
            StringBuilder v = new StringBuilder();
            for (cursor = 5; cursor < data.length && !PdfSpecialCharacters.isEndComment(data, cursor); ++cursor) {
                v.append((char)data[cursor]);
            }
            this.version = v.toString();
        }
        PdfFile file = new PdfFile(this.unit);
        ArrayList<PdfAttributeValue> nonProcessedAttributes = new ArrayList<PdfAttributeValue>();
        int xrefStart = -1;
        while (cursor < data.length) {
            if (!PdfSpecialCharacters.isSeparator(data[cursor])) {
                if (PdfSpecialCharacters.isEOF(data, cursor)) {
                    cursor += PdfSpecialCharacters.EOF.length;
                    this.postProcessDictionaries(file);
                    file = new PdfFile(this.unit);
                    xrefStart = -1;
                    this.simpleView.add(new String(PdfSpecialCharacters.EOF));
                } else if (PdfSpecialCharacters.isComment(data[cursor])) {
                    cursor = PdfComment.skipCommentsIfSome(data, cursor - 1);
                } else if (PdfSpecialCharacters.isStartObj(data, cursor)) {
                    try {
                        PdfIndirectObj o = new PdfIndirectObj(file, this.unit, cursor);
                        cursor = o.parse(data, cursor, nonProcessedAttributes);
                        file.putObject(o.getId(), o);
                        this.unit.getObjects().put(o.getId(), file);
                        this.simpleView.add(o);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error while parsing obj at address %x", new Object[]{cursor});
                    }
                } else if (PdfSpecialCharacters.isXref(data, cursor)) {
                    xrefStart = cursor;
                    while (cursor + 1 < data.length && this.isXrefChar(data[cursor + 1])) {
                        ++cursor;
                    }
                } else if (PdfSpecialCharacters.isStartXref(data, cursor)) {
                    PdfAttributeValue value = new PdfAttributeValue(null, cursor += PdfSpecialCharacters.XREF_START_SEPARATOR.length);
                    cursor = value.parseNexToken(data, cursor);
                    try {
                        int startxrefPos;
                        IPdfAttribute startxref = value.getPdfAttribute();
                        this.simpleView.add(new String(PdfSpecialCharacters.XREF_START_SEPARATOR) + " " + startxref.toString());
                        if (startxref.getType() == IPdfAttribute.Type.Number && (startxrefPos = ((PdfNumber)startxref).intValue()) != 0) {
                            file.setStartXref(this.unit.getTrailers().get(startxrefPos));
                        }
                    }
                    catch (StartObjFoundException e) {
                        logger.catching((Throwable)e);
                    }
                } else if (PdfSpecialCharacters.isStartTrailer(data, cursor)) {
                    try {
                        int startIndex = xrefStart == -1 ? cursor : xrefStart;
                        PdfTrailer o = new PdfTrailer(file, this.unit, startIndex, cursor, this.trailerCount);
                        cursor = o.parse(data, cursor);
                        file.putObject(o.getId(), o);
                        this.unit.getObjects().put(o.getId(), file);
                        ++this.trailerCount;
                        file.setTrailer(o);
                        this.unit.getTrailers().put(startIndex, o);
                        if (PdfSpecialCharacters.isStartXref(data, cursor - PdfSpecialCharacters.XREF_START_SEPARATOR.length)) {
                            cursor = cursor - PdfSpecialCharacters.XREF_START_SEPARATOR.length - 1;
                        }
                        this.simpleView.add(o);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("Error while parsing obj at address %x", new Object[]{cursor});
                    }
                } else {
                    PdfAttributeValue attribute = new PdfAttributeValue(null, cursor);
                    cursor = attribute.parse(data, cursor);
                    nonProcessedAttributes.add(attribute);
                }
            }
            ++cursor;
        }
        if (file.getObjectNumber() != 0) {
            this.postProcessDictionaries(file);
        }
    }

    private boolean isXrefChar(byte b) {
        return PdfSpecialCharacters.isSeparator(b) || Character.isDigit((char)b) || b == 110 || b == 102;
    }

    private void postProcessDictionaries(PdfFile file) {
        List<PdfIndirectObj> objectList = file.getObjectList();
        PdfDictionary dictionary = null;
        for (PdfIndirectObj o : objectList) {
            try {
                dictionary = null;
                switch (o.getAttribute().getType()) {
                    case Stream: {
                        dictionary = ((PdfStream)o.getAttribute()).getDictionary();
                        break;
                    }
                    case Dictionary: {
                        dictionary = (PdfDictionary)o.getAttribute();
                        break;
                    }
                }
                if (dictionary == null || !"/XRef".equals(dictionary.getDictionaryType())) continue;
                PdfTrailer t = new PdfTrailer(file, dictionary, this.unit, this.trailerCount);
                file.putObject(t.getId(), t);
                ++this.trailerCount;
                file.setTrailer(t);
                this.unit.getTrailers().put(t.getStartIndex(), t);
            }
            catch (Exception e) {
                logger.catching((Throwable)e);
            }
        }
    }

    private void processDecryptionAndDecoding() {
        for (Map.Entry<PdfObjId, PdfFile> objectEntrySet : this.unit.getObjects().entrySet()) {
            PdfFile file = objectEntrySet.getValue();
            PdfIndirectObj o = file.getObject(objectEntrySet.getKey());
            try {
                switch (o.getAttribute().getType()) {
                    case Stream: {
                        PdfStream stream = (PdfStream)o.getAttribute();
                        stream.checkSize();
                        stream.decodeStream();
                        if (stream.isObjStmExtends()) break;
                        this.streams.add(stream);
                        break;
                    }
                }
                if (o.getType() != IPdfAttribute.Type.IndirectObject || file.getStringDecrypt() == null || o.getId().equals(file.getEncryptDictionary().getId())) continue;
                file.getStringDecrypt().browseElement(o.getAttribute(), null);
            }
            catch (Exception e) {
                logger.catching((Throwable)e);
            }
        }
    }

    private void processObjStm() {
        TreeMap<PdfObjId, PdfFile> createdObjects = new TreeMap<PdfObjId, PdfFile>();
        block5: for (Map.Entry<PdfObjId, PdfFile> objectEntrySet : this.unit.getObjects().entrySet()) {
            PdfIndirectObj o = objectEntrySet.getValue().getObject(objectEntrySet.getKey());
            try {
                switch (o.getAttribute().getType()) {
                    case Stream: {
                        PdfStream stream = (PdfStream)o.getAttribute();
                        PdfStream extendsAttribute = (PdfStream)stream.getAttribute("/Extends");
                        if (extendsAttribute != null) {
                            extendsAttribute.addExtendedBy(o);
                        }
                        if (!stream.isObjStm()) break;
                        stream.decodeStream();
                        if (stream.getDecodedData().length <= 0) break;
                        byte[] data = ((PdfStream)o.getAttribute()).getDecodedData();
                        int n = Integer.valueOf(stream.getAttribute("/N").toString());
                        int firstOffset = Integer.valueOf(stream.getAttribute("/First").toString());
                        int idCursor = 0;
                        for (int i = 0; i < n; ++i) {
                            PdfAttributeValue pdfValue = new PdfAttributeValue(stream, 0);
                            idCursor = pdfValue.parseNexToken(data, idCursor) + 1;
                            IPdfAttribute objNumber = PdfIndirectReference.retrieveDirectObject(pdfValue.getPdfAttribute());
                            pdfValue = new PdfAttributeValue(stream, 0);
                            idCursor = pdfValue.parseNexToken(data, idCursor) + 1;
                            IPdfAttribute startOffset = PdfIndirectReference.retrieveDirectObject(pdfValue.getPdfAttribute());
                            int startIndex = firstOffset + Integer.valueOf(startOffset.toString());
                            PdfFile file = objectEntrySet.getValue();
                            PdfIndirectOjbStm newobj = new PdfIndirectOjbStm(file, this.unit, startIndex);
                            newobj.parse(data, startIndex, objNumber.toString());
                            file.putObject(newobj.getId(), newobj);
                            createdObjects.put(newobj.getId(), file);
                            stream.addObjStmChild(newobj);
                        }
                        continue block5;
                    }
                }
            }
            catch (Exception e) {
                logger.catching((Throwable)e);
                logger.error("Unable to parse Stream %s, an error occurred during parsing ObjStm: %s", new Object[]{o.getId(), e.getMessage()});
                if (o.getAttribute() == null) continue;
                this.unit.getStatistics().addUnitNotification(o.getAttribute(), PdfStatistics.SuspiciousType.MalformedStream, String.format("Unable to parse Stream/ObjStm stream", new Object[0]), e);
            }
        }
        this.unit.getObjects().putAll(createdObjects);
    }

    private void processFuntional() {
        for (Map.Entry<PdfObjId, PdfFile> objectEntrySet : this.unit.getObjects().entrySet()) {
            PdfIndirectObj o = objectEntrySet.getValue().getObject(objectEntrySet.getKey());
            this.processFunctionalElement(o.getAttribute());
        }
    }

    private void processFunctionalElement(IPdfAttribute attribute) {
        try {
            switch (attribute.getType()) {
                case Stream: {
                    break;
                }
                case Dictionary: {
                    this.processFunctionalDictionary((PdfDictionary)attribute);
                    break;
                }
                case Array: {
                    PdfArray array = (PdfArray)attribute;
                    for (IPdfAttribute attribute2 : array.getAttributes()) {
                        this.processFunctionalElement(attribute2);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
        }
    }

    private void processFunctionalDictionary(PdfDictionary dict) throws IOException {
        IPdfAttribute xfaRaw;
        IPdfAttribute acroform;
        IPdfAttribute js;
        IPdfAttribute actionType = dict.getAttribute("/S");
        if (actionType != null && "/JavaScript".equals(actionType.toString()) && (js = dict.getAttribute("/JS")) != null) {
            if (js.getType() == IPdfAttribute.Type.Stream) {
                ((PdfStream)js).setType(PdfStream.StreamType.Javascript);
            } else if (js.getType() == IPdfAttribute.Type.String) {
                this.strings.add((PdfString)js);
                PdfStream jsStream = new PdfStream(dict, (PdfString)js);
                jsStream.setType(PdfStream.StreamType.Javascript);
                this.streams.add(jsStream);
            } else {
                logger.error("Can not manage /JS type for dictionary %s", new Object[]{dict.getId()});
            }
        }
        if ("/Page".equals(dict.getDictionaryType())) {
            IPdfAttribute contents = dict.getAttribute("/Contents");
            if (contents != null) {
                if (contents.getType() == IPdfAttribute.Type.Stream) {
                    ((PdfStream)contents).setType(PdfStream.StreamType.Contents);
                } else if (contents.getType() == IPdfAttribute.Type.Array) {
                    List<IPdfAttribute> arrayAttributes = ((PdfArray)contents).getAttributes();
                    for (IPdfAttribute iPdfAttribute : arrayAttributes) {
                        IPdfAttribute content = PdfDictionary.retrieveDirectObject(iPdfAttribute);
                        if (content == null || content.getType() != IPdfAttribute.Type.Stream) continue;
                        ((PdfStream)content).setType(PdfStream.StreamType.Contents);
                    }
                }
            }
        } else if ("/Catalog".equals(dict.getDictionaryType()) && (acroform = dict.getAttribute("/AcroForm")) != null && acroform.getType() == IPdfAttribute.Type.Dictionary && (xfaRaw = ((PdfDictionary)acroform).getAttribute("/XFA")) != null) {
            if (xfaRaw.getType() == IPdfAttribute.Type.Stream) {
                ((PdfStream)xfaRaw).setType(PdfStream.StreamType.XFA);
            } else if (xfaRaw.getType() == IPdfAttribute.Type.Array) {
                ArrayList<PdfStream> xfaFragments = new ArrayList<PdfStream>();
                for (IPdfAttribute fragment : ((PdfArray)xfaRaw).getAttributes()) {
                    if (fragment.getType() == IPdfAttribute.Type.IndirectReference) {
                        fragment = PdfIndirectReference.retrieveDirectObject(fragment);
                    }
                    if (fragment.getType() == IPdfAttribute.Type.String || fragment.getType() != IPdfAttribute.Type.Stream) continue;
                    xfaFragments.add((PdfStream)fragment);
                    ((PdfStream)fragment).setType(PdfStream.StreamType.XFA_Fragment);
                }
                if (xfaFragments.size() == 1) {
                    ((PdfStream)xfaFragments.get(0)).setType(PdfStream.StreamType.XFA);
                } else {
                    PdfStream pdfStream = new PdfStream((PdfDictionary)acroform, xfaFragments);
                    pdfStream.setType(PdfStream.StreamType.XFA);
                    this.streams.add(pdfStream);
                }
            }
        }
        for (PdfDictionaryAttribute attribute : dict.getAttributes()) {
            this.processFunctionalElement(attribute.getValue());
        }
    }

    public Set<PdfStream> getStreams() {
        return this.streams;
    }

    public byte[] getSimpleView() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (Object o : this.simpleView) {
            bos.write(o.toString().getBytes());
            bos.write(10);
        }
        return bos.toByteArray();
    }
}

