/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.parser;

import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;

public class PdfComment {
    private static final ILogger logger = GlobalLog.getLogger(PdfComment.class);

    public static int skipCommentsIfSome(byte[] data, int cursor) {
        int startLine = cursor;
        if (PdfSpecialCharacters.isComment(data[cursor + 1])) {
            while (cursor < data.length) {
                if (PdfSpecialCharacters.isEndComment(data, cursor + 1)) {
                    return cursor;
                }
                ++cursor;
            }
        }
        logger.info("Found comment: %s", new Object[]{new String(data, startLine, cursor - startLine)});
        return cursor;
    }

    public static boolean skipComments(ByteBuffer data) {
        while (data.hasRemaining()) {
            if (!PdfSpecialCharacters.isEndComment(data.get())) continue;
            return false;
        }
        return true;
    }
}

