/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.parser;

import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfBoolean;
import com.pnf.plugin.pdf.obj.PdfIndirectReference;
import com.pnf.plugin.pdf.obj.PdfName;
import com.pnf.plugin.pdf.obj.PdfNull;
import com.pnf.plugin.pdf.obj.PdfNumber;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnf.plugin.pdf.obj.PdfUnknown;
import com.pnf.plugin.pdf.parser.IPdfParsable;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnf.plugin.pdf.parser.StartObjFoundException;

public class PdfAttributeValue
implements IPdfParsable {
    private String value;
    private PdfIndirectReference id = null;
    private AbstractPdfParsableAttribute parent;
    protected int startIndex;

    public PdfAttributeValue(AbstractPdfParsableAttribute parent, int startIndex) {
        this.parent = parent;
        this.startIndex = startIndex;
    }

    @Override
    public int parse(byte[] data, int cursor) {
        int referenceCursor;
        this.startIndex = cursor;
        while (!this.isEndToken(data, cursor + 1) && cursor < data.length) {
            ++cursor;
        }
        this.value = new String(data, this.startIndex, cursor - this.startIndex + 1);
        if (this.value.matches("\\d+") && PdfSpecialCharacters.isSeparator(data, referenceCursor = cursor + 1)) {
            return this.testIndirectReference(data, referenceCursor, cursor);
        }
        return cursor;
    }

    private int testIndirectReference(byte[] data, int referenceCursor, int cursor) {
        if ((referenceCursor = PdfSpecialCharacters.jumpSeparators(data, referenceCursor)) >= data.length) {
            return cursor;
        }
        StringBuilder generationNumber = new StringBuilder();
        while (Character.isDigit((char)data[referenceCursor]) && referenceCursor < data.length) {
            generationNumber.append((char)data[referenceCursor]);
            ++referenceCursor;
        }
        if (!PdfSpecialCharacters.isSeparator(data, referenceCursor) || generationNumber.length() == 0) {
            return cursor;
        }
        if ((referenceCursor = PdfSpecialCharacters.jumpSeparators(data, referenceCursor)) >= data.length) {
            return cursor;
        }
        if (PdfSpecialCharacters.isChar(data, referenceCursor, 'R')) {
            this.id = new PdfIndirectReference(new PdfObjId(Integer.valueOf(this.value), Integer.valueOf(generationNumber.toString()), this.startIndex), this.parent, this.startIndex);
            return referenceCursor;
        }
        return cursor;
    }

    public int parseNexToken(byte[] data, int cursor) {
        while (PdfSpecialCharacters.isSeparator(data, cursor) && cursor < data.length) {
            ++cursor;
        }
        if (cursor >= data.length) {
            return cursor;
        }
        return this.parse(data, cursor);
    }

    public String toString() {
        try {
            return this.getPdfAttribute().toString();
        }
        catch (StartObjFoundException e) {
            return e.getMessage();
        }
    }

    public static boolean isStartToken(byte[] data, int cursor) {
        return !PdfSpecialCharacters.isDelimitor(data[cursor]);
    }

    public boolean isEndToken(byte[] data, int cursor) {
        return PdfSpecialCharacters.isDelimitorOrSeparator(data, cursor);
    }

    @Override
    public IPdfAttribute getPdfAttribute() throws StartObjFoundException {
        if (this.id != null) {
            return this.id;
        }
        if (this.value == null || this.value.length() == 0) {
            return new PdfNull(this.parent, this.startIndex);
        }
        if (PdfName.isName(this.value)) {
            return new PdfName(this.value, this.parent, this.startIndex);
        }
        if (PdfNumber.isNumeric(this.value)) {
            return new PdfNumber(this.value, this.parent, this.startIndex);
        }
        if (PdfBoolean.isBoolean(this.value)) {
            return new PdfBoolean(this.value, this.parent, this.startIndex);
        }
        if (PdfNull.isNull(this.value)) {
            return new PdfNull(this.parent, this.startIndex);
        }
        if (this.value.equals("obj")) {
            throw new StartObjFoundException();
        }
        return new PdfUnknown(this.value, this.parent, this.startIndex);
    }
}

