/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.obj;

import com.pnf.plugin.pdf.PdfFileUnit;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfNumber;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnf.plugin.pdf.parser.PdfFile;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
public class PdfTrailer
extends PdfIndirectObj {
    @SerId(value=1)
    private PdfTrailer prev;

    public PdfTrailer(PdfFile file, PdfFileUnit unit, int startIndex, int cursor, int trailerCount) {
        super(file, unit, startIndex);
        this.id = new PdfTrailerId(trailerCount, cursor);
    }

    public PdfTrailer(PdfFile file, PdfDictionary dictionary, PdfFileUnit unit, int trailerCount) {
        super(file, unit, dictionary.startIndex);
        this.attribute = dictionary;
        this.id = new PdfTrailerId(trailerCount, dictionary.startIndex);
    }

    @Override
    public boolean isEncrypted() {
        return this.getEncrypt() != null;
    }

    public IPdfAttribute getEncrypt() {
        return this.getDictionaryAttribute("/Encrypt");
    }

    public IPdfAttribute getDictionaryAttribute(String attributeName) {
        if (this.getAttribute() == null || this.getAttribute().getType() != IPdfAttribute.Type.Dictionary) {
            return null;
        }
        PdfDictionary dictionary = (PdfDictionary)this.getAttribute();
        IPdfAttribute attributeValue = dictionary.getAttribute(attributeName);
        if (attributeValue == null) {
            IPdfAttribute prevObj;
            if (this.prev == null && (prevObj = dictionary.getAttribute("/Prev")) != null && prevObj.getType() == IPdfAttribute.Type.Number) {
                this.prev = this.unit.getTrailers().get(((PdfNumber)prevObj).intValue());
            }
            if (this.prev != null) {
                return this.prev.getDictionaryAttribute(attributeName);
            }
        }
        return attributeValue;
    }

    public IPdfAttribute getID() {
        return this.getDictionaryAttribute("/ID");
    }

    @Override
    public int parse(byte[] data, int cursor) {
        return super.parse(data, cursor, this.id);
    }

    @Override
    public IPdfAttribute.Type getType() {
        return IPdfAttribute.Type.Trailer;
    }

    @Override
    protected byte[] getStartToken() {
        return PdfSpecialCharacters.TRAILER_START_SEPARATOR;
    }

    @Override
    protected byte[] getEndToken() {
        return PdfSpecialCharacters.XREF_START_SEPARATOR;
    }

    @Override
    public boolean isEndToken(byte[] data, int cursor) {
        return PdfSpecialCharacters.isStartXref(data, cursor);
    }

    @Ser
    public static class PdfTrailerId
    extends PdfObjId {
        public static final int TRAILER_ID = -1;

        public PdfTrailerId(int generationNumber, int startAddress) {
            super(-1, generationNumber, startAddress);
        }

        @Override
        public String toString() {
            return String.format("xref", new Object[0]);
        }
    }
}

