/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.obj;

import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfNumber;
import com.pnf.plugin.pdf.parser.PdfAttributeValue;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnf.plugin.pdf.parser.StartObjFoundException;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;

@Ser
public class PdfObjId
implements Comparable<PdfObjId> {
    private static final ILogger logger = GlobalLog.getLogger(PdfDictionary.class);
    @SerId(value=1)
    private int objectNumber;
    @SerId(value=2)
    private int generationNumber;
    @SerId(value=3)
    private int startAddress;

    public PdfObjId(int objectNumber, int generationNumber, int startAddress) {
        this.objectNumber = objectNumber;
        this.generationNumber = generationNumber;
        this.startAddress = startAddress;
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    @Override
    public int compareTo(PdfObjId o) {
        int compare = Integer.compare(this.objectNumber, o.objectNumber);
        if (compare != 0) {
            return compare;
        }
        return Integer.compare(this.generationNumber, o.generationNumber);
    }

    public static PdfObjId getObjId(List<PdfAttributeValue> previousTokens) throws StartObjFoundException {
        if (previousTokens != null && previousTokens.size() >= 2) {
            IPdfAttribute objN = previousTokens.get(previousTokens.size() - 2).getPdfAttribute();
            IPdfAttribute genN = previousTokens.get(previousTokens.size() - 1).getPdfAttribute();
            if (objN.getType() == IPdfAttribute.Type.Number && genN.getType() == IPdfAttribute.Type.Number) {
                return new PdfObjId(Integer.valueOf(objN.toString()), Integer.valueOf(genN.toString()), ((PdfNumber)objN).startIndex);
            }
        }
        return null;
    }

    public static PdfObjId getObjId(byte[] data, int cursor) {
        int startAddress;
        int previousSeparator = 0;
        ArrayList<Integer> objIdentifier = new ArrayList<Integer>();
        StringBuilder stb = new StringBuilder();
        for (startAddress = cursor - 1; startAddress >= 0; --startAddress) {
            if (PdfSpecialCharacters.isSeparator(data[startAddress])) {
                if (PdfSpecialCharacters.isSeparator(data[startAddress + 1])) continue;
                ++previousSeparator;
                if (stb.length() > 0) {
                    objIdentifier.add(Integer.valueOf(stb.toString()));
                }
                stb = new StringBuilder();
                if (previousSeparator != 3) continue;
                break;
            }
            if (Character.isDigit(data[startAddress])) {
                stb.insert(0, (char)data[startAddress]);
                continue;
            }
            if (previousSeparator == 2 && PdfSpecialCharacters.isDelimitor(data[startAddress])) {
                if (stb.length() <= 0) break;
                objIdentifier.add(Integer.valueOf(stb.toString()));
                break;
            }
            logger.error("Unsupported sequence in obj id '%s' at address: %x", new Object[]{Character.valueOf((char)data[startAddress]), cursor});
            break;
        }
        if (startAddress != 0) {
            ++startAddress;
        }
        switch (objIdentifier.size()) {
            case 0: {
                logger.error("No Id found at address %x", new Object[]{cursor});
                return new PdfObjId(0, 0, cursor);
            }
            case 1: {
                logger.error("Id found only 1 int, assuming it is object number %d", new Object[]{objIdentifier.get(0)});
                return new PdfObjId((Integer)objIdentifier.get(0), 0, cursor);
            }
            case 2: {
                return new PdfObjId((Integer)objIdentifier.get(1), (Integer)objIdentifier.get(0), startAddress);
            }
        }
        logger.error("Incorrect Id found at address %x", new Object[]{cursor});
        return new PdfObjId(0, 0, cursor);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PdfObjId) {
            PdfObjId o = (PdfObjId)obj;
            return this.objectNumber == o.objectNumber && this.generationNumber == o.generationNumber;
        }
        return false;
    }

    public int hashCode() {
        return this.objectNumber;
    }

    public String toString() {
        if (this.objectNumber == 0 && this.generationNumber == 0) {
            return "undefined";
        }
        return String.format("%d %d", this.objectNumber, this.generationNumber);
    }
}

