/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.obj;

import com.pnf.plugin.pdf.PdfFileUnit;
import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfNull;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnf.plugin.pdf.parser.InputOffset;
import com.pnf.plugin.pdf.parser.PdfAttributeValue;
import com.pnf.plugin.pdf.parser.PdfComment;
import com.pnf.plugin.pdf.parser.PdfFile;
import com.pnf.plugin.pdf.parser.PdfObjectParser;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnf.plugin.pdf.parser.StartObjFoundException;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.sun.pdfview.decrypt.PDFDecrypter;
import java.util.List;
import java.util.Map;

@Ser
public class PdfIndirectObj
extends AbstractPdfParsableAttribute
implements Comparable<PdfIndirectObj> {
    private static final ILogger logger = GlobalLog.getLogger(PdfIndirectObj.class);
    @SerId(value=1)
    protected PdfObjId id;
    @SerId(value=2)
    protected IPdfAttribute attribute = null;
    @SerId(value=3)
    protected PdfFileUnit unit;
    @SerId(value=4)
    private PdfFile file;

    public PdfIndirectObj(PdfFile file, PdfFileUnit unit, int startIndex) {
        super(null, startIndex);
        this.file = file;
        this.unit = unit;
    }

    @Override
    public int parse(byte[] data, int cursor) {
        return this.parse(data, cursor, PdfObjId.getObjId(data, cursor));
    }

    public int parse(byte[] data, int cursor, List<PdfAttributeValue> previousTokens) throws StartObjFoundException {
        PdfObjId objId = PdfObjId.getObjId(previousTokens);
        if (objId == null) {
            objId = PdfObjId.getObjId(data, cursor);
        }
        return this.parse(data, cursor, objId);
    }

    public int parse(byte[] data, int cursor, PdfObjId objId) {
        this.id = objId;
        if (this.id != null) {
            this.startIndex = this.id.getStartAddress();
        }
        logger.trace("Processing obj %s", new Object[]{this.id});
        cursor += this.getStartToken().length;
        while (cursor < data.length) {
            block11: {
                if (!PdfSpecialCharacters.isSeparator(data[cursor])) {
                    if (PdfSpecialCharacters.isComment(data[cursor])) {
                        cursor = PdfComment.skipCommentsIfSome(data, cursor - 1);
                    } else {
                        if (this.isEndToken(data, cursor)) {
                            if (this.attribute == null) {
                                this.attribute = new PdfNull(this, cursor);
                            }
                            this.setEndIndex(cursor);
                            return cursor += this.getEndToken().length;
                        }
                        if (this.attribute == null) {
                            PdfObjectParser parser = new PdfObjectParser(this);
                            try {
                                cursor = parser.parse(data, cursor);
                                this.attribute = parser.getPdfAttribute();
                                break block11;
                            }
                            catch (StartObjFoundException e) {
                                this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.Malformed, String.format("Unexpected new obj definition in Indirect Object at address %x", cursor));
                                cursor -= 4;
                                break;
                            }
                        }
                        if (this.getEndToken() == PdfSpecialCharacters.OBJ_END_SEPARATOR) {
                            logger.info("endobj is missing for Indirect Object %s", new Object[]{this.getId()});
                        }
                        return cursor - 1;
                    }
                }
            }
            ++cursor;
        }
        this.setEndIndex(cursor);
        return cursor;
    }

    protected byte[] getStartToken() {
        return PdfSpecialCharacters.OBJ_START_SEPARATOR;
    }

    protected byte[] getEndToken() {
        return PdfSpecialCharacters.OBJ_END_SEPARATOR;
    }

    public boolean isEndToken(byte[] data, int cursor) {
        return PdfSpecialCharacters.isEndObj(data, cursor);
    }

    @Override
    public IPdfAttribute.Type getType() {
        return IPdfAttribute.Type.IndirectObject;
    }

    @Override
    public PdfObjId getId() {
        return this.id;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        if (this.file.isEncrypted()) {
            stb.append("*");
        }
        stb.append(String.format("@(%d,%d) %s ", this.startIndex, this.endIndex, this.id.toString()));
        if (this.getType() == IPdfAttribute.Type.IndirectObject) {
            stb.append("obj ");
        }
        if (this.attribute != null && this.attribute.getType() == IPdfAttribute.Type.String) {
            stb.append("(").append(this.attribute).append(")");
        } else {
            stb.append(this.attribute);
        }
        return stb.toString();
    }

    @Override
    public int compareTo(PdfIndirectObj o) {
        return this.id.compareTo(o.id);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PdfIndirectObj) {
            return this.id.equals(((PdfIndirectObj)obj).id);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public IPdfAttribute getAttribute() {
        return this.attribute;
    }

    public Map<PdfObjId, PdfIndirectObj> getObjects() {
        return this.file.getObjects();
    }

    @Override
    public InputOffset toInputOffset() {
        return InputOffset.getInstance(this, this.startIndex);
    }

    @Override
    public PdfStatistics getPdfStatictics() {
        return this.unit.getStatistics();
    }

    public PDFDecrypter getDecrypter() {
        return this.file.getDecrypter();
    }

    public boolean isEncrypted() {
        return this.file.isEncrypted();
    }

    public PdfIndirectObj getDirectObject(PdfObjId indirectId) {
        PdfFile refFile = this.unit.getObjects().get(indirectId);
        if (refFile == null) {
            return null;
        }
        return this.unit.getObjects().get(indirectId).getObject(indirectId);
    }
}

