/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.obj;

import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfDictionaryAttribute;
import com.pnf.plugin.pdf.obj.PdfIndirectReference;
import com.pnf.plugin.pdf.obj.PdfName;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.pnf.plugin.pdf.parser.PdfComment;
import com.pnf.plugin.pdf.parser.PdfObjectParser;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnf.plugin.pdf.parser.StartObjFoundException;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Ser
public class PdfDictionary
extends AbstractPdfParsableAttribute {
    @SerId(value=1)
    private List<PdfDictionaryAttribute> attributes = new ArrayList<PdfDictionaryAttribute>();
    @SerId(value=2)
    private PdfStream stream = null;
    @SerTransient
    private String type;
    @SerTransient
    private String subtype;

    public PdfDictionary(AbstractPdfParsableAttribute parent, int startIndex) {
        super(parent, startIndex);
    }

    public static boolean isStartToken(byte[] data, int cursor) {
        return data[cursor] == 60 && data[cursor + 1] == 60;
    }

    public boolean isEndToken(byte[] data, int cursor) {
        return data[cursor] == 62 && data[cursor + 1] == 62;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int parse(byte[] data, int cursor) throws StartObjFoundException {
        ++cursor;
        ++cursor;
        PdfDictionaryAttribute currentAttribute = null;
        while (cursor < data.length) {
            if (!PdfSpecialCharacters.isSeparator(data[cursor])) {
                if (PdfSpecialCharacters.isComment(data[cursor])) {
                    cursor = PdfComment.skipCommentsIfSome(data, cursor - 1);
                } else {
                    if (this.isEndToken(data, cursor)) {
                        ++cursor;
                        while (PdfSpecialCharacters.isSeparator(data, cursor + 1) && cursor + 1 < data.length) {
                            ++cursor;
                        }
                        if (!PdfSpecialCharacters.isStartStream(data, cursor + 1)) return cursor;
                        this.stream = new PdfStream(this, cursor);
                        cursor = this.stream.parse(data, cursor);
                        return cursor += PdfSpecialCharacters.STREAM_END_SEPARATOR.length;
                    }
                    if (currentAttribute == null) {
                        if (data[cursor] != 47) {
                            this.getPdfStatictics().addUnitNotification(this, PdfStatistics.SuspiciousType.Malformed, String.format("Incorrect Dictionary entries at address %X", cursor));
                            return cursor;
                        }
                        int startLine = cursor;
                        while (!PdfSpecialCharacters.isDelimitorOrSeparator(data, cursor + 1)) {
                            ++cursor;
                        }
                        PdfName key = new PdfName(new String(data, startLine, cursor - startLine + 1), this, startLine);
                        currentAttribute = new PdfDictionaryAttribute(this, key, startLine);
                    } else {
                        PdfObjectParser parser = new PdfObjectParser(this);
                        cursor = parser.parse(data, cursor);
                        IPdfAttribute attribute = parser.getPdfAttribute();
                        if (attribute != null) {
                            currentAttribute.setValue(attribute);
                            this.attributes.add(currentAttribute);
                            currentAttribute = null;
                        }
                    }
                }
            }
            ++cursor;
        }
        return cursor;
    }

    public List<PdfDictionaryAttribute> getAttributes() {
        return this.attributes;
    }

    public List<String> getAttributeKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.attributes != null) {
            for (PdfDictionaryAttribute att : this.attributes) {
                keys.add(att.getKey().toString().substring(1));
            }
        }
        return keys;
    }

    private IPdfAttribute getDirectAttribute(String name) {
        for (PdfDictionaryAttribute dicAttr : this.getAttributes()) {
            if (!dicAttr.getKey().toString().equals(name)) continue;
            return dicAttr.getValue();
        }
        return null;
    }

    public boolean hasAttribute(String name) {
        IPdfAttribute attribute = this.getDirectAttribute(name);
        return attribute != null && attribute.getType() != IPdfAttribute.Type.Null;
    }

    public IPdfAttribute getAttribute(String name) {
        return PdfDictionary.retrieveDirectObject(this.getDirectAttribute(name));
    }

    public static IPdfAttribute retrieveDirectObject(IPdfAttribute attribute) {
        if (attribute != null && attribute.getType() == IPdfAttribute.Type.IndirectReference) {
            return PdfIndirectReference.retrieveDirectObject(attribute);
        }
        return attribute;
    }

    public String getDictionaryType() {
        if (this.type == null) {
            this.type = Objects.toString(this.getAttribute("/Type"), null);
        }
        return this.type;
    }

    public String getDictionarySubtype() {
        if (this.subtype == null) {
            this.subtype = Objects.toString(this.getAttribute("/Subtype"), null);
        }
        return this.subtype;
    }

    public String getDictionaryFullType() {
        if (this.getDictionaryType() != null) {
            if (this.getDictionarySubtype() != null) {
                return this.getDictionaryType() + this.getDictionarySubtype();
            }
            return this.getDictionaryType();
        }
        return null;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder("<<");
        for (PdfDictionaryAttribute attribute : this.attributes) {
            stb.append("  ");
            stb.append(attribute.getKey()).append(" ");
            if (attribute.getValue().getType() == IPdfAttribute.Type.String) {
                stb.append("(").append(attribute.getValue()).append(")");
            } else {
                stb.append(attribute.getValue());
            }
            stb.append("  ");
        }
        stb.append(">>");
        return stb.toString();
    }

    @Override
    public IPdfAttribute.Type getType() {
        return IPdfAttribute.Type.Dictionary;
    }

    @Override
    public IPdfAttribute getPdfAttribute() {
        if (this.stream != null) {
            return this.stream;
        }
        return this;
    }
}

