/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.obj;

import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.parser.PdfObjectParser;
import com.pnf.plugin.pdf.parser.PdfSpecialCharacters;
import com.pnf.plugin.pdf.parser.StartObjFoundException;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;

@Ser
public class PdfArray
extends AbstractPdfParsableAttribute {
    @SerId(value=1)
    private List<IPdfAttribute> attributes = new ArrayList<IPdfAttribute>();

    public PdfArray(AbstractPdfParsableAttribute parent, int startIndex) {
        super(parent, startIndex);
    }

    @Override
    public int parse(byte[] data, int cursor) throws StartObjFoundException {
        ++cursor;
        while (cursor < data.length) {
            if (!PdfSpecialCharacters.isSeparator(data[cursor])) {
                if (this.isEndToken(data, cursor)) break;
                PdfObjectParser parser = new PdfObjectParser(this);
                cursor = parser.parse(data, cursor);
                IPdfAttribute attribute = parser.getPdfAttribute();
                if (attribute != null) {
                    this.attributes.add(attribute);
                }
            }
            ++cursor;
        }
        return cursor;
    }

    public static boolean isStartToken(byte[] data, int cursor) {
        return data[cursor] == 91;
    }

    public boolean isEndToken(byte[] data, int cursor) {
        return data[cursor] == 93;
    }

    public List<IPdfAttribute> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder("[");
        for (IPdfAttribute attribute : this.attributes) {
            if (attribute.getType() == IPdfAttribute.Type.String) {
                stb.append(" (").append(attribute).append(") ");
                continue;
            }
            stb.append(" ").append(attribute).append(" ");
        }
        stb.append("]");
        return stb.toString();
    }

    @Override
    public IPdfAttribute.Type getType() {
        return IPdfAttribute.Type.Array;
    }
}

