/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.filter;

import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.filter.ASCII85Decode;
import com.pnf.plugin.pdf.filter.ASCIIHexDecode;
import com.pnf.plugin.pdf.filter.CCITTFaxDecode;
import com.pnf.plugin.pdf.filter.Crypt;
import com.pnf.plugin.pdf.filter.DCTDecode;
import com.pnf.plugin.pdf.filter.FlateDecode;
import com.pnf.plugin.pdf.filter.IFilter;
import com.pnf.plugin.pdf.filter.JBIG2Decode;
import com.pnf.plugin.pdf.filter.JPXDecode;
import com.pnf.plugin.pdf.filter.LZWDecode;
import com.pnf.plugin.pdf.filter.NullFilter;
import com.pnf.plugin.pdf.filter.RunLengthDecode;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfName;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.sun.pdfview.decrypt.PDFDecrypter;

public class FilterFactory {
    public static IFilter getFilterInstance(PdfStream stream, PdfName attribute, IPdfAttribute decodeParms, PdfStatistics statistics, PDFDecrypter decrypter) {
        if (decodeParms != null && decodeParms.getType() == IPdfAttribute.Type.Null) {
            decodeParms = null;
        } else if (decodeParms != null && decodeParms.getType() != IPdfAttribute.Type.Dictionary) {
            statistics.addUnitNotification(stream, PdfStatistics.SuspiciousType.Malformed, String.format("Unable to parse [Stream %s]/DecodeParms: expected dictionary or null", stream.getId()));
            decodeParms = null;
        }
        PdfDictionary parms = (PdfDictionary)decodeParms;
        String filterName = attribute.toString();
        statistics.addFiltersUsed(filterName);
        if (filterName.equalsIgnoreCase("/FlateDecode") || filterName.equalsIgnoreCase("/Fl")) {
            return new FlateDecode(parms);
        }
        if (filterName.equalsIgnoreCase("/CCITTFaxDecode") || filterName.equalsIgnoreCase("/CCF")) {
            return new CCITTFaxDecode(parms);
        }
        if (filterName.equalsIgnoreCase("/ASCIIHexDecode") || filterName.equalsIgnoreCase("/AHx")) {
            return new ASCIIHexDecode();
        }
        if (filterName.equalsIgnoreCase("/ASCII85Decode") || filterName.equalsIgnoreCase("/A85")) {
            return new ASCII85Decode();
        }
        if (filterName.equalsIgnoreCase("/DCTDecode") || filterName.equalsIgnoreCase("/DCT")) {
            return new DCTDecode(parms);
        }
        if (filterName.equalsIgnoreCase("/LZWDecode") || filterName.equalsIgnoreCase("/LZW")) {
            return new LZWDecode(parms);
        }
        if (filterName.equalsIgnoreCase("/JBIG2Decode")) {
            return new JBIG2Decode(parms);
        }
        if (filterName.equalsIgnoreCase("/RunLengthDecode") || filterName.equalsIgnoreCase("/RL")) {
            return new RunLengthDecode();
        }
        if (filterName.equalsIgnoreCase("/JPXDecode")) {
            return new JPXDecode(parms);
        }
        if (filterName.equalsIgnoreCase("/Crypt")) {
            return new Crypt(parms, decrypter);
        }
        statistics.addUnitNotification(stream, PdfStatistics.SuspiciousType.StreamUnfiltered, String.format("Unable to parse [Stream %s]%s: not supported filter", stream.getId(), attribute));
        return new NullFilter();
    }
}

