/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.filter;

import com.pnf.plugin.pdf.filter.ByteBufferUtils;
import com.pnf.plugin.pdf.filter.IFilter;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.parser.PdfFilterException;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class Decoder {
    private static final ILogger logger = GlobalLog.getLogger(Decoder.class);
    private PdfDictionary dictionary;
    private PdfFilterException decodingError;
    private int errorFilterIndex;

    public Decoder(PdfDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public byte[] parse(int filterIndex, IFilter filter, byte[] encodedData, byte[] data, int fromByte, Integer lengthFromDictionary) throws Exception {
        block4: {
            try {
                byte[] result = this.parse(filterIndex, filter, encodedData);
                if (this.decodingError == null) {
                    return result;
                }
                if (lengthFromDictionary == null || lengthFromDictionary == encodedData.length || fromByte + lengthFromDictionary > data.length) {
                    return this.decodingError.getBaos().toByteArray();
                }
            }
            catch (Exception e) {
                if (lengthFromDictionary != null && lengthFromDictionary != encodedData.length && fromByte + lengthFromDictionary <= data.length) break block4;
                throw e;
            }
        }
        return this.parse(filterIndex, filter, ByteBufferUtils.getByteArray(data, fromByte, lengthFromDictionary).toByteArray());
    }

    public byte[] parse(int filterIndex, IFilter filter, byte[] data) throws Exception {
        try {
            return filter.decodeBytes(data, 0, data.length, this.dictionary);
        }
        catch (PdfFilterException e) {
            this.setDecodingError(e, filterIndex);
            return e.getBaos().toByteArray();
        }
        catch (Error | Exception e) {
            logger.error("An error occurred during stream parsing. Make sure you added all dependencies to project.", new Object[0]);
            logger.catching(e);
            return new byte[0];
        }
    }

    public PdfFilterException getDecodingError() {
        return this.decodingError;
    }

    public int getFilterIndex() {
        return this.errorFilterIndex;
    }

    private void setDecodingError(PdfFilterException decodingError, int filterIndex) {
        if (this.decodingError == null) {
            this.decodingError = decodingError;
            this.errorFilterIndex = filterIndex;
        }
    }
}

