/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.document;

import com.pnf.plugin.pdf.document.PdfNode;
import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfDictionaryAttribute;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfIndirectReference;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.units.IUnitNotification;
import java.util.List;
import java.util.Map;

public class PdfObjectNode
extends PdfNode
implements IActionableItem {
    private long itemId;
    private int flags;

    public PdfObjectNode(IPdfAttribute attribute, Map<IPdfAttribute, List<IUnitNotification>> anomalies, boolean master) {
        super(attribute, anomalies);
        this.itemId = PdfObjectNode.getItemId(attribute);
        this.flags = master ? 1 : 0;
    }

    public PdfObjectNode(IPdfAttribute attribute, PdfObjId id, Map<IPdfAttribute, List<IUnitNotification>> anomalies, boolean master) {
        this(attribute, anomalies, master);
        this.additionalLabels[0] = this.additionalLabels[0] != null ? id.toString() + " " + this.additionalLabels[0] : id.toString();
    }

    public PdfObjectNode(PdfDictionaryAttribute dictionaryAttribute, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        super(dictionaryAttribute, anomalies);
        this.itemId = PdfObjectNode.getItemId(dictionaryAttribute.getValue());
        this.flags = 0;
    }

    private static long getItemId(IPdfAttribute attribute) {
        AbstractPdfParsableAttribute parent = attribute.getParent();
        if (parent.getType() == IPdfAttribute.Type.IndirectObject || parent.getType() == IPdfAttribute.Type.IndirectObjectStream || parent.getType() == IPdfAttribute.Type.Trailer) {
            return ((PdfIndirectObj)parent).getId().getObjectNumber();
        }
        if (attribute.getType() == IPdfAttribute.Type.IndirectReference) {
            return ((PdfIndirectReference)attribute).getId().getObjectNumber();
        }
        return 0L;
    }

    public int getItemFlags() {
        return this.flags;
    }

    public long getItemId() {
        return this.itemId;
    }
}

