/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf.document;

import com.pnf.plugin.pdf.PdfFormatter;
import com.pnf.plugin.pdf.document.PdfObjectNode;
import com.pnf.plugin.pdf.obj.AbstractPdfParsableAttribute;
import com.pnf.plugin.pdf.obj.IPdfAttribute;
import com.pnf.plugin.pdf.obj.PdfArray;
import com.pnf.plugin.pdf.obj.PdfDictionary;
import com.pnf.plugin.pdf.obj.PdfDictionaryAttribute;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.IVisualNode;
import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.core.units.NotificationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PdfNode
implements IVisualNode {
    public static final List<String> COLUMNS = Arrays.asList("Node/Type", "Key/Id", "Value");
    private String label;
    private ItemClassIdentifiers classId;
    protected String[] additionalLabels = new String[COLUMNS.size() - 1];
    private List<INode> children = new ArrayList<INode>();

    public PdfNode(String label, ItemClassIdentifiers classId) {
        this.label = label;
        this.classId = classId;
    }

    public PdfNode(IPdfAttribute attribute, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        this(PdfNode.getAttributeLabel(attribute), PdfNode.getClassId(attribute, anomalies));
        this.processElement(attribute, anomalies);
    }

    public PdfNode(PdfDictionaryAttribute dictionaryAttribute, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        this(PdfNode.getAttributeLabel(dictionaryAttribute.getValue()), PdfNode.getClassId(dictionaryAttribute, anomalies));
        this.processElement(dictionaryAttribute.getValue(), anomalies);
        this.additionalLabels[0] = dictionaryAttribute.getKey().toString();
    }

    private PdfNode buildNode(IPdfAttribute attribute, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        if (attribute.getType() == IPdfAttribute.Type.IndirectReference) {
            return new PdfObjectNode(attribute, anomalies, false);
        }
        return new PdfNode(attribute, anomalies);
    }

    private PdfNode buildNode(PdfDictionaryAttribute dictionaryAttribute, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        if (dictionaryAttribute.getValue().getType() == IPdfAttribute.Type.IndirectReference) {
            return new PdfObjectNode(dictionaryAttribute, anomalies);
        }
        return new PdfNode(dictionaryAttribute, anomalies);
    }

    private static String getAttributeLabel(IPdfAttribute attribute) {
        return attribute.getType().toString();
    }

    private void processElement(IPdfAttribute attribute, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        List<IUnitNotification> notifications = PdfNode.getChildNotifications(anomalies, attribute);
        switch (attribute.getType()) {
            case Array: {
                this.addArrayChildren(((PdfArray)attribute).getAttributes(), anomalies);
                this.additionalLabels[1] = "";
                break;
            }
            case Boolean: 
            case Name: 
            case Null: 
            case Number: 
            case String: 
            case Unknown: 
            case IndirectReference: {
                this.additionalLabels[1] = PdfFormatter.displayValue(attribute, notifications);
                break;
            }
            case Stream: {
                this.additionalLabels[1] = PdfFormatter.displayValue(attribute, notifications);
                this.addDictionaryChildren(((PdfStream)attribute).getDictionary().getAttributes(), anomalies);
                break;
            }
            case Dictionary: {
                this.additionalLabels[1] = PdfFormatter.displayValue(attribute, notifications);
                this.addDictionaryChildren(((PdfDictionary)attribute).getAttributes(), anomalies);
                break;
            }
            default: {
                this.additionalLabels[1] = "";
            }
        }
    }

    private void addArrayChildren(List<IPdfAttribute> attributes, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        int i = 0;
        for (IPdfAttribute attribute : attributes) {
            PdfNode childNode = this.buildNode(attribute, anomalies);
            this.addChild(childNode);
            childNode.additionalLabels[0] = childNode.additionalLabels[0] == null ? String.format("[%d]", i) : String.format("[%d] ", i) + childNode.additionalLabels[0];
            ++i;
        }
    }

    private void addDictionaryChildren(List<PdfDictionaryAttribute> attributes, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        for (PdfDictionaryAttribute attribute : attributes) {
            PdfNode childNode = this.buildNode(attribute, anomalies);
            this.addChild(childNode);
        }
    }

    private static List<IUnitNotification> getChildNotifications(Map<IPdfAttribute, List<IUnitNotification>> anomalies, IPdfAttribute attribute) {
        if (anomalies == null) {
            return null;
        }
        ArrayList<IUnitNotification> notifications = new ArrayList<IUnitNotification>();
        block0: for (Map.Entry<IPdfAttribute, List<IUnitNotification>> n : anomalies.entrySet()) {
            if (n.getKey().equals(attribute)) {
                notifications.addAll((Collection<IUnitNotification>)n.getValue());
                continue;
            }
            for (AbstractPdfParsableAttribute parent = n.getKey().getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.equals(attribute)) continue;
                notifications.addAll((Collection<IUnitNotification>)n.getValue());
                continue block0;
            }
        }
        return notifications;
    }

    private static ItemClassIdentifiers getClassId(IPdfAttribute attribute, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        List<IUnitNotification> notifications = PdfNode.getChildNotifications(anomalies, attribute);
        return PdfNode.getClassId(attribute, notifications);
    }

    private static NotificationType getNotificationType(int maxLevel) {
        for (NotificationType n : NotificationType.values()) {
            if (n.getLevel() != maxLevel) continue;
            return n;
        }
        return null;
    }

    private static ItemClassIdentifiers getClassId(IPdfAttribute attribute, List<IUnitNotification> notifications) {
        if (notifications != null && !notifications.isEmpty()) {
            int maxLevel = 0;
            for (IUnitNotification n : notifications) {
                maxLevel = Math.max(maxLevel, n.getType().getLevel());
            }
            switch (PdfNode.getNotificationType(maxLevel)) {
                case UNSUPPORTED_FEATURE: {
                    return ItemClassIdentifiers.INFO_WARNING;
                }
                case DEPRECATED_FEATURE: {
                    return ItemClassIdentifiers.INFO_DEPRECATED;
                }
                case CORRUPTION: {
                    return ItemClassIdentifiers.INFO_CORRUPT;
                }
                case AREA_OF_INTEREST: {
                    return ItemClassIdentifiers.INFO_WARNING;
                }
                case POTENTIALLY_HARMFUL: {
                    return ItemClassIdentifiers.INFO_DANGEROUS;
                }
            }
            return ItemClassIdentifiers.INFO_MALFORMED;
        }
        if (attribute.getType() == IPdfAttribute.Type.IndirectReference) {
            return ItemClassIdentifiers.ADDRESS;
        }
        return null;
    }

    private static ItemClassIdentifiers getClassId(PdfDictionaryAttribute dictionaryAttribute, Map<IPdfAttribute, List<IUnitNotification>> anomalies) {
        ArrayList<IUnitNotification> notifications = new ArrayList<IUnitNotification>();
        List<IUnitNotification> valueNotifications = PdfNode.getChildNotifications(anomalies, dictionaryAttribute.getValue());
        List<IUnitNotification> keyNotifications = PdfNode.getChildNotifications(anomalies, dictionaryAttribute.getKey());
        if (valueNotifications != null) {
            notifications.addAll(valueNotifications);
        }
        if (keyNotifications != null) {
            notifications.addAll(keyNotifications);
        }
        return PdfNode.getClassId(dictionaryAttribute.getValue(), notifications);
    }

    public String getLabel() {
        return this.label;
    }

    public ItemClassIdentifiers getClassId() {
        return this.classId;
    }

    public String[] getAdditionalLabels() {
        return this.additionalLabels;
    }

    private void addChild(PdfNode childNode) {
        this.children.add((INode)childNode);
    }

    public List<INode> getChildren() {
        return this.children;
    }

    public int getInitialExpansion() {
        return 0;
    }
}

