/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf;

import com.pnf.plugin.pdf.PdfFileUnit;
import com.pnf.plugin.pdf.parser.PdfHeaderParser;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;

public class PdfPlugin
extends AbstractUnitIdentifier {
    public static final String TYPE = "pdf";

    public PdfPlugin() {
        super(TYPE, 0.0);
    }

    public PluginInformation getPluginInformation() {
        return new PluginInformation("PDF parser", "Adobe PDF file parsing", "PNF Software", Version.create((int)1, (int)0, (int)8));
    }

    public void initialize(IPropertyDefinitionManager parentPdm) {
        super.initialize(parentPdm);
    }

    public boolean canIdentify(IInput input, IUnitCreator parent) {
        if (PdfPlugin.checkBytes((IInput)input, (int)0, (byte[])new byte[]{37, 80, 68, 70})) {
            return true;
        }
        return new PdfHeaderParser(input).isPdf();
    }

    public IUnit prepare(String name, IInput data, IUnitProcessor unitProcessor, IUnitCreator parent) {
        return new PdfFileUnit(name, data, unitProcessor, parent, this.pdm);
    }
}

