/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.plugin.pdf;

import com.pnf.plugin.pdf.AddressUtils;
import com.pnf.plugin.pdf.CrossReferences;
import com.pnf.plugin.pdf.PdfStatistics;
import com.pnf.plugin.pdf.XFAParser;
import com.pnf.plugin.pdf.address.IAddress;
import com.pnf.plugin.pdf.document.TreePdfDocument;
import com.pnf.plugin.pdf.obj.PdfIndirectObj;
import com.pnf.plugin.pdf.obj.PdfObjId;
import com.pnf.plugin.pdf.obj.PdfStream;
import com.pnf.plugin.pdf.obj.PdfTrailer;
import com.pnf.plugin.pdf.parser.PdfFile;
import com.pnf.plugin.pdf.parser.PdfParser;
import com.pnf.plugin.pdf.unit.AbstractStreamUnit;
import com.pnf.plugin.pdf.unit.BinaryStreamUnit;
import com.pnf.plugin.pdf.unit.IPdfUnit;
import com.pnf.plugin.pdf.unit.PdfObjStmUnit;
import com.pnf.plugin.pdf.unit.StreamUnitProvider;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.actions.ActionXrefsData;
import com.pnfsoftware.jeb.core.actions.IActionData;
import com.pnfsoftware.jeb.core.events.ClientNotification;
import com.pnfsoftware.jeb.core.events.ClientNotificationLevel;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.input.BytesInput;
import com.pnfsoftware.jeb.core.input.FileInputRegionInformation;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.input.IInputLocation;
import com.pnfsoftware.jeb.core.output.AbstractTransientUnitRepresentation;
import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.UnitFormatterUtil;
import com.pnfsoftware.jeb.core.output.text.impl.AsciiDocument;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.AbstractInteractiveBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import com.pnfsoftware.jeb.util.serialization.annotations.SerTransient;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;

@Ser
public class PdfFileUnit
extends AbstractInteractiveBinaryUnit
implements IPdfUnit {
    private static final ILogger logger = GlobalLog.getLogger(PdfFileUnit.class);
    @SerId(value=1)
    private String identifier;
    @SerId(value=2)
    private Map<PdfObjId, PdfFile> objects = new TreeMap<PdfObjId, PdfFile>();
    @SerId(value=3)
    private Map<Integer, PdfTrailer> trailers = new TreeMap<Integer, PdfTrailer>();
    @SerId(value=4)
    private byte[] simpleView;
    @SerId(value=5)
    private PdfStatistics statistics;
    @SerTransient
    private List<PdfIndirectObj> objectList;
    @SerTransient
    private AddressUtils addressManager;
    @SerTransient
    private CrossReferences crossReferences;

    public PdfFileUnit(String name, IInput data, IUnitProcessor unitProcessor, IUnitCreator parent, IPropertyDefinitionManager pdm) {
        super(null, data, "pdf", name, unitProcessor, parent, pdm);
        this.identifier = name + UUID.randomUUID().toString();
    }

    public boolean process() {
        PdfParser parser = new PdfParser(this);
        try (InputStream is = this.getInput().getStream();){
            parser.parse(is);
            this.simpleView = parser.getSimpleView();
        }
        catch (IOException e) {
            logger.catching((Throwable)e);
        }
        for (PdfStream stream : parser.getStreams()) {
            try {
                AbstractStreamUnit streamUnit = null;
                if (stream.isObjStm()) {
                    streamUnit = new PdfObjStmUnit((IUnit)this, stream, this.identifier, this.getStatistics());
                } else if (stream.getStreamType().endsWith("XML")) {
                    streamUnit = this.getUnitProcessor().process(stream.getName(), (IInput)new BytesInput(stream.getDecodedData()), (IUnitCreator)this, stream.getWantedType(), true);
                    streamUnit = StreamUnitProvider.wrap((IUnit)streamUnit, stream, null);
                } else if (stream.isImage()) {
                    if (stream.isJpeg()) {
                        List<byte[]> encodedDataList = stream.getEncodedDataList();
                        streamUnit = this.getUnitProcessor().process(stream.getName(), (IInput)new BytesInput(encodedDataList.get(encodedDataList.size() - 1)), (IUnitCreator)this);
                        streamUnit = StreamUnitProvider.wrap((IUnit)streamUnit, stream, stream.getStreamType());
                    } else {
                        streamUnit = new BinaryStreamUnit(this, stream, this.identifier, false);
                    }
                } else {
                    streamUnit = this.buildDefaultStreamUnit(stream);
                    if (stream.getStreamType().equals("XFA")) {
                        try {
                            XFAParser xfaParser = new XFAParser();
                            xfaParser.parse(stream.getDecodedData());
                            this.addXFAChildren(stream, (IUnit)streamUnit, xfaParser.getJavaScripts(), PdfStream.StreamType.Javascript, "javascript");
                            this.addXFAChildren(stream, (IUnit)streamUnit, xfaParser.getScripts(), PdfStream.StreamType.Script, null);
                        }
                        catch (Exception e) {
                            logger.catching((Throwable)e);
                            logger.error("Error while processing XFA %s", new Object[]{stream.getId()});
                        }
                    }
                }
                if (streamUnit == null) {
                    logger.error("Can not create specific unit for stream %s", new Object[]{stream.getId()});
                    streamUnit = new BinaryStreamUnit(this, stream, this.identifier, true);
                }
                this.addChild((IUnit)streamUnit);
            }
            catch (Exception e) {
                logger.catching((Throwable)e);
                logger.error("Can not create unit for stream %s", new Object[]{stream.getId()});
            }
        }
        if (this.getStatistics().isUserPasswordRequired()) {
            this.notifyListeners(new JebEvent(J.Notification, (Object)new ClientNotification("Pdf requires password from user: streams and strings can not be decoded", ClientNotificationLevel.WARNING)));
        }
        logger.debug("Cross References successfully built.", new Object[0]);
        this.setProcessed(true);
        return true;
    }

    private void addXFAChildren(PdfStream stream, IUnit parentUnit, List<byte[]> xfaScripts, PdfStream.StreamType streamType, String wantedType) {
        if (!xfaScripts.isEmpty()) {
            for (byte[] script : xfaScripts) {
                this.getStatistics().addUnitNotification(stream, PdfStatistics.SuspiciousType.PotentialHarmfulFile, "XFA contains " + streamType);
                IUnit jsUnit = this.buildDefaultStreamUnit(parentUnit, stream, streamType, script, wantedType);
                parentUnit.addChild(jsUnit);
            }
        }
    }

    private IUnit buildDefaultStreamUnit(IUnit creator, PdfStream stream, PdfStream.StreamType streamType, byte[] data, String wantedType) {
        StringBuilder name = new StringBuilder(stream.getName()).append(" (").append((Object)streamType).append(")");
        IUnit streamUnit = this.getUnitProcessor().process(name.toString(), (IInput)new BytesInput(data), (IUnitCreator)creator, wantedType, true);
        if (streamUnit == null) {
            PdfStream virtualStream = new PdfStream(stream.getDictionary(), data);
            virtualStream.setType(streamType);
            return new BinaryStreamUnit(creator, this.getStatistics(), virtualStream, stream.getName(), true);
        }
        return streamUnit;
    }

    private IUnit buildDefaultStreamUnit(PdfStream stream) {
        Object streamUnit = this.getUnitProcessor().process(stream.getName(), (IInput)new BytesInput(stream.getDecodedData()), (IUnitCreator)this, stream.getWantedType(), true);
        streamUnit = streamUnit == null ? new BinaryStreamUnit(this, stream, this.identifier, true) : StreamUnitProvider.wrap(streamUnit, stream, null);
        return streamUnit;
    }

    public List<PdfIndirectObj> getObjectList() {
        if (this.objectList == null) {
            this.objectList = new ArrayList<PdfIndirectObj>(this.toMap().values());
            Collections.sort(this.objectList);
        }
        return this.objectList;
    }

    public Map<PdfObjId, PdfFile> getObjects() {
        return this.objects;
    }

    public Map<Integer, PdfTrailer> getTrailers() {
        return this.trailers;
    }

    private Map<PdfObjId, PdfIndirectObj> toMap() {
        TreeMap<PdfObjId, PdfIndirectObj> objectsMap = new TreeMap<PdfObjId, PdfIndirectObj>();
        for (Map.Entry<PdfObjId, PdfFile> objectEntrySet : this.objects.entrySet()) {
            objectsMap.put(objectEntrySet.getKey(), objectEntrySet.getValue().getObject(objectEntrySet.getKey()));
        }
        return objectsMap;
    }

    @Override
    public AddressUtils getAddressUtils() {
        if (this.addressManager == null) {
            this.addressManager = new AddressUtils(this.getObjectList());
        }
        return this.addressManager;
    }

    private CrossReferences getCrossReferences() {
        if (this.crossReferences == null) {
            this.crossReferences = new CrossReferences(this.getObjectList());
        }
        return this.crossReferences;
    }

    @Override
    public PdfStatistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = new PdfStatistics(this);
        }
        return this.statistics;
    }

    protected List<PdfIndirectObj> getAreaOfInterestObjectList() {
        ArrayList<PdfIndirectObj> areaOfInterest = new ArrayList<PdfIndirectObj>(this.getStatistics().anomalyKeys());
        Collections.sort(areaOfInterest);
        return areaOfInterest;
    }

    public IUnitFormatter getFormatter() {
        IUnitFormatter formatter = super.getFormatter();
        if (UnitFormatterUtil.getPresentationByName((IUnitFormatter)formatter, (String)"Indirect Objects") == null) {
            formatter.addPresentation((IUnitDocumentPresentation)new AbstractTransientUnitRepresentation("Indirect Objects", true){

                public IGenericDocument createDocument() {
                    TreePdfDocument document = new TreePdfDocument(PdfFileUnit.this.getObjectList(), PdfFileUnit.this);
                    return document;
                }
            }, false);
        }
        if (UnitFormatterUtil.getPresentationByName((IUnitFormatter)formatter, (String)"Simple view") == null) {
            final byte[] simple = this.simpleView;
            formatter.addPresentation((IUnitDocumentPresentation)new AbstractTransientUnitRepresentation("Simple view", false){

                public IGenericDocument createDocument() {
                    return new AsciiDocument((IInput)new BytesInput(simple));
                }
            }, false);
        }
        return formatter;
    }

    public List<Integer> getAddressActions(String arg0) {
        logger.info("getAddressActions %s", new Object[]{arg0});
        return null;
    }

    public String getAddressOfItem(long itemId) {
        logger.info("getAddressOfItem %d", new Object[]{itemId});
        return null;
    }

    public List<Integer> getGlobalActions() {
        logger.info("getGlobalActions", new Object[0]);
        return null;
    }

    public List<Integer> getItemActions(long id) {
        logger.info("getItemActions %d", new Object[]{id});
        return Arrays.asList(4);
    }

    public long getItemAtAddress(String address) {
        return this.getAddressUtils().getByAddress(address).getRange()[0];
    }

    public String getAddressLabel(String address) {
        return this.getAddressUtils().getByAddress(address).getLabel();
    }

    public Map<String, String> getAddressLabels() {
        return null;
    }

    public String getInlineComment(String address) {
        return this.getAddressUtils().getByAddress(address).getComment();
    }

    public IInputLocation addressToLocation(String address) {
        if (address.endsWith("h")) {
            return new FileInputRegionInformation(Long.valueOf(address.substring(0, address.length() - 1), 16).longValue());
        }
        if (address.startsWith("@")) {
            return null;
        }
        IAddress addressImpl = this.getAddressUtils().getByAddress(address);
        return new FileInputRegionInformation(addressImpl.getRange()[0]);
    }

    public String locationToAddress(IInputLocation location) {
        if (location instanceof FileInputRegionInformation) {
            long offset = ((FileInputRegionInformation)location).getOffset();
            return this.getAddressUtils().getByOffset(offset).getLabel();
        }
        return null;
    }

    public boolean canExecuteAction(ActionContext actionContext) {
        return actionContext.getActionId() == 4 && actionContext.getItemId() != 0L;
    }

    public boolean prepareExecution(ActionContext actionContext, IActionData actionData) {
        if (actionContext.getActionId() == 4) {
            ActionXrefsData data = (ActionXrefsData)actionData;
            List<String> addresses = this.getCrossReferences().getCrossReference(actionContext.getItemId());
            data.setAddresses(addresses);
            return true;
        }
        return false;
    }

    public boolean executeAction(ActionContext actionContext, IActionData actionData) {
        if (actionContext.getActionId() == 4) {
            // empty if block
        }
        return false;
    }

    public String getDescription() {
        Set<String> filters;
        PdfStatistics statistics = this.getStatistics();
        StringBuilder stb = new StringBuilder(super.getDescription());
        if (!Strings.isBlank((CharSequence)statistics.getVersion())) {
            stb.append("- Version: ").append(statistics.getVersion()).append("\n");
        }
        stb.append("- Number of indirect objects: ").append(statistics.getNbIndirectObjects());
        stb.append("\n- Number of stream objects: ").append(statistics.getNbStreamedObjects());
        stb.append("\n- Number of streams: ").append(statistics.getNbStreams());
        if (statistics.isEncrypted()) {
            stb.append("\n- Pdf trailer defines Encryption: streams and strings can not be decoded");
        }
        if (!(filters = statistics.getFiltersUsed()).isEmpty()) {
            stb.append("\n- Filters used: ").append(Strings.join((String)", ", filters));
        }
        stb.append("\n").append(statistics.toStringTokens());
        stb.append(this.getStatistics().toStringCorruptions());
        return stb.toString();
    }

    public PdfStatistics getNotificationManager() {
        return this.getStatistics();
    }
}

