/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.regex;

import com.pnfsoftware.jeb.rcpclient.util.regex.IPattern;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SimplePattern
implements IPattern {
    private Pattern pattern;
    private boolean reverse;

    public SimplePattern(String filterString) {
        this.setPattern(filterString);
    }

    void setPattern(Pattern p) {
        this.pattern = p;
    }

    @Override
    public void setPattern(String filterString) {
        if (filterString.startsWith("~")) {
            this.reverse = true;
            filterString = filterString.substring(1);
        } else if (filterString.startsWith("\\~")) {
            filterString = filterString.substring(1);
        }
        boolean literal = false;
        if (filterString.startsWith("\"")) {
            if (!filterString.endsWith("\"")) {
                throw new PatternSyntaxException("Missing closing double-quote", "", -1);
            }
            literal = true;
            filterString = filterString.substring(1, filterString.length() - 1);
        }
        int flags = 0x62 | (literal ? 16 : 0);
        this.pattern = Pattern.compile(filterString, flags);
    }

    @Override
    public boolean match(String value) {
        if (value == null) {
            return false;
        }
        return this.pattern.matcher(value).find() ^ this.reverse;
    }

    @Override
    public boolean match(Object[] list) {
        int key = 0;
        for (Object o : list) {
            String str;
            if (o == null || (str = o.toString()) == null || str.length() == 0) continue;
            if (this.pattern.matcher(str).find()) {
                return !this.reverse;
            }
            if (key > 40) break;
            ++key;
        }
        return this.reverse;
    }
}

