/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.regex;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.rcpclient.util.regex.IPattern;
import com.pnfsoftware.jeb.rcpclient.util.regex.SimplePattern;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternFilter
implements IPattern {
    private String[] colHeaders;
    private SimplePattern mainPattern;
    private Map<Integer, Pattern> colPatternMap = new HashMap<Integer, Pattern>();

    public PatternFilter(String pattern, String[] colHeaders) {
        this.colHeaders = colHeaders;
        this.setPattern(pattern);
    }

    @Override
    public void setPattern(String filterString) {
        if (this.colHeaders != null) {
            this.colPatternMap = new HashMap<Integer, Pattern>();
            for (int i = 0; i < this.colHeaders.length; ++i) {
                if (this.colHeaders[i] == null) continue;
                Object colFilterString = null;
                int idx = -1;
                String colHeader = this.colHeaders[i].toLowerCase();
                String startType = colHeader + ":\"";
                boolean literal = true;
                do {
                    if (idx != -1) {
                        int pos;
                        int end = -1;
                        while ((end = ((String)filterString).indexOf("\"", pos = end == -1 ? idx + colHeader.length() + 2 : end + 1)) != -1 && ((String)filterString).charAt(end - 1) == '\\') {
                        }
                        if (end == -1) {
                            throw new PatternSyntaxException("Missing closing double-quote", "", -1);
                        }
                        String tmpfilter = ((String)filterString).substring(idx + colHeader.length() + 2, end);
                        filterString = ((String)filterString).substring(0, idx).trim() + " " + ((String)filterString).substring(end + 1).trim();
                        if (colFilterString == null) {
                            colFilterString = tmpfilter;
                        } else {
                            literal = false;
                            colFilterString = (String)colFilterString + "|" + tmpfilter;
                        }
                    }
                    if (((String)filterString).startsWith(startType)) {
                        idx = 0;
                        continue;
                    }
                    idx = ((String)filterString).indexOf(" " + startType);
                    if (idx == -1) continue;
                    ++idx;
                } while (idx != -1);
                if (colFilterString == null) continue;
                Pattern pattern = null;
                if (!((String)colFilterString).isEmpty()) {
                    int flags = 0x62 | (literal ? 16 : 0);
                    pattern = Pattern.compile((String)colFilterString, flags);
                }
                this.colPatternMap.put(i, pattern);
            }
        }
        this.mainPattern = ((String)(filterString = ((String)filterString).trim())).isEmpty() ? null : new SimplePattern((String)filterString);
    }

    @Override
    public boolean match(String element) {
        if (Licensing.isDebugBuild()) {
            throw new IllegalStateException("Not Implemented");
        }
        return false;
    }

    @Override
    public boolean match(Object[] list) {
        if (!this.colPatternMap.isEmpty()) {
            HashSet<Integer> filteredIndices = new HashSet<Integer>();
            for (Map.Entry<Integer, Pattern> entry : this.colPatternMap.entrySet()) {
                int colidx = entry.getKey();
                if (colidx < 0 || colidx >= list.length) {
                    return false;
                }
                String colstr = Strings.safe(list[colidx]);
                filteredIndices.add(colidx);
                colstr = colstr.replace("\"", "\\\"");
                Pattern pattern = entry.getValue();
                if (!(pattern == null ? !colstr.isEmpty() : !pattern.matcher(colstr).find())) continue;
                return false;
            }
            Object[] filteredList = new Object[list.length - filteredIndices.size()];
            int filteredIndex = 0;
            for (int i = 0; i < list.length; ++i) {
                if (filteredIndices.contains(i)) continue;
                filteredList[filteredIndex] = list[i];
                ++filteredIndex;
            }
            list = filteredList;
        }
        return this.mainPattern == null ? true : this.mainPattern.match(list);
    }
}

