/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku;

import com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku.SudokuGrid;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SudokuUtils {
    public static List<SudokuGrid> parseFile(File file) throws IOException {
        String buffer = Strings.decodeUTF8(IO.readFile(file));
        return SudokuUtils.parseData(buffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<SudokuGrid> parseData(String buffer) throws IOException {
        ArrayList<SudokuGrid> grids = new ArrayList<SudokuGrid>();
        String[] lines = Strings.splitLines(buffer);
        int i = 0;
        while (true) {
            int i0 = -1;
            int i1 = -1;
            while (i < lines.length) {
                String line = lines[i];
                if (line.trim().equals(">")) {
                    if (i0 >= 0) throw new RuntimeException();
                    i0 = i + 1;
                } else if (line.trim().equals("<")) {
                    if (i1 >= 0 || i0 < 0) throw new RuntimeException();
                    i1 = i;
                    break;
                }
                ++i;
            }
            if (i0 < 0 || i1 < 0) return grids;
            ++i;
            String str = Strings.join("\n", Arrays.asList(lines).subList(i0, i1));
            grids.add(SudokuGrid.parse(str));
        }
    }
}

