/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Arrays;

public class SudokuGrid {
    private boolean locked;
    private int boxlen;
    private int gridlen;
    private int numbase;
    private int numstart;
    private int[][] grid;
    static final int VERSION = 1;
    private static final String sep = "_";

    private SudokuGrid() {
    }

    public SudokuGrid(int boxlen, int numbase, int numstart) {
        Assert.a(boxlen == 3 || boxlen == 4);
        this.boxlen = boxlen;
        Assert.a(numbase == 10 || numbase == 16);
        this.numbase = numbase;
        Assert.a(numstart >= 0);
        this.numstart = numstart;
        this.gridlen = boxlen * boxlen;
        for (int[] elts : this.grid = new int[this.gridlen][this.gridlen]) {
            for (int col = 0; col < this.gridlen; ++col) {
                elts[col] = -1;
            }
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.boxlen;
        result = 31 * result + Arrays.deepHashCode((Object[])this.grid);
        result = 31 * result + this.gridlen;
        result = 31 * result + (this.locked ? 1231 : 1237);
        result = 31 * result + this.numbase;
        result = 31 * result + this.numstart;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SudokuGrid other = (SudokuGrid)obj;
        if (this.boxlen != other.boxlen) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.grid, (Object[])other.grid)) {
            return false;
        }
        if (this.gridlen != other.gridlen) {
            return false;
        }
        if (this.locked != other.locked) {
            return false;
        }
        if (this.numbase != other.numbase) {
            return false;
        }
        return this.numstart == other.numstart;
    }

    public SudokuGrid clone() {
        SudokuGrid g = new SudokuGrid(this.boxlen, this.numbase, this.numstart);
        g.grid = this.cloneGrid();
        return g;
    }

    private int[][] cloneGrid() {
        int[][] grid1 = new int[this.grid.length][];
        int i = 0;
        for (int[] elts : this.grid) {
            grid1[i++] = Arrays.copyOf(elts, elts.length);
        }
        return grid1;
    }

    public void lock() {
        this.locked = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int getCellCount() {
        return this.gridlen * this.gridlen;
    }

    public int getGridLength() {
        return this.gridlen;
    }

    public int getBoxLength() {
        return this.boxlen;
    }

    int getInternalValue(int row, int col) {
        return this.grid[row][col];
    }

    void setInternalValue(int row, int col, int val) {
        if (this.locked) {
            throw new IllegalStateException("This grid is read-only");
        }
        this.grid[row][col] = val;
    }

    public String getValue(int row, int col) {
        return this.internalToVisual(this.getInternalValue(row, col));
    }

    public void setValue(int row, int col, String str) {
        this.setInternalValue(row, col, this.visualToInternal(str));
    }

    public int verify() {
        boolean incomplete = false;
        for (int idx = 0; idx < this.gridlen; ++idx) {
            int code = this.checkRow(idx);
            if (code == -1) {
                return -1;
            }
            if (code == 0) {
                incomplete = true;
            }
            if ((code = this.checkColumn(idx)) == -1) {
                return -1;
            }
            if (code == 0) {
                incomplete = true;
            }
            if ((code = this.checkBox(idx)) == -1) {
                return -1;
            }
            if (code != 0) continue;
            incomplete = true;
        }
        return incomplete ? 0 : 1;
    }

    private int checkRow(int row) {
        int[] elts;
        boolean incomplete = false;
        boolean[] seen = new boolean[this.gridlen];
        for (int elt : elts = this.grid[row]) {
            if (elt < 0 || elt >= this.gridlen) {
                incomplete = true;
                continue;
            }
            if (seen[elt]) {
                return -1;
            }
            seen[elt] = true;
        }
        return incomplete ? 0 : 1;
    }

    private int checkColumn(int col) {
        boolean incomplete = false;
        boolean[] seen = new boolean[this.gridlen];
        for (int[] elts : this.grid) {
            int elt = elts[col];
            if (elt < 0 || elt >= this.gridlen) {
                incomplete = true;
                continue;
            }
            if (seen[elt]) {
                return -1;
            }
            seen[elt] = true;
        }
        return incomplete ? 0 : 1;
    }

    private int checkBox(int idx) {
        boolean incomplete = false;
        boolean[] seen = new boolean[this.gridlen];
        int x = idx / this.boxlen;
        int y = idx % this.boxlen;
        for (int row = x * this.boxlen; row < (x + 1) * this.boxlen; ++row) {
            int[] elts = this.grid[row];
            for (int col = y * this.boxlen; col < (y + 1) * this.boxlen; ++col) {
                int elt = elts[col];
                if (elt < 0 || elt >= this.gridlen) {
                    incomplete = true;
                    continue;
                }
                if (seen[elt]) {
                    return -1;
                }
                seen[elt] = true;
            }
        }
        return incomplete ? 0 : 1;
    }

    boolean isDetermined(int val) {
        return (val & 0xFF) != 255;
    }

    String internalToVisual(int val) {
        return Integer.toString(val + this.numstart, this.numbase).toUpperCase();
    }

    int visualToInternal(String str) {
        return Integer.parseInt(str, this.numbase) - this.numstart;
    }

    public static SudokuGrid parse(String str) {
        int numstart;
        int numbase;
        int boxlen;
        int gridlen = 0;
        boolean shiftm1 = false;
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : Strings.splitLines(str)) {
            if ((line = Strings.trim(line)).isEmpty()) continue;
            if (line.startsWith("#")) {
                String comment = line.substring(1);
                if (!comment.equals("m1")) continue;
                shiftm1 = true;
                continue;
            }
            line = line.replace(" ", "").replace("\t", "");
            lines.add(line);
            int len = line.length();
            if (gridlen == 0) {
                if (len != 9 && len != 16) {
                    throw new RuntimeException();
                }
                gridlen = len;
                continue;
            }
            if (len == gridlen) continue;
            throw new RuntimeException();
        }
        if (lines.size() != gridlen) {
            throw new RuntimeException();
        }
        if (gridlen == 9) {
            boxlen = 3;
            numbase = 10;
            numstart = 1;
        } else if (gridlen == 16) {
            boxlen = 4;
            numbase = 16;
            numstart = 0;
        } else {
            throw new RuntimeException();
        }
        SudokuGrid g = new SudokuGrid(boxlen, numbase, numstart);
        for (int row = 0; row < gridlen; ++row) {
            String line = (String)lines.get(row);
            for (int col = 0; col < gridlen; ++col) {
                int elt;
                int ch = Character.toUpperCase(line.charAt(col));
                if (shiftm1) {
                    if (ch >= 49 && ch <= 57 || ch >= 66 && ch <= 71) {
                        ch = (char)(ch - '\u0001');
                    } else if (ch == 65) {
                        ch = 57;
                    }
                }
                g.grid[row][col] = elt = ch == 45 ? -1 : Integer.parseInt("" + (char)ch, numbase) - numstart;
            }
        }
        g.lock();
        return g;
    }

    private String genDivider() {
        Object div = "-" + Strings.generate("--", this.boxlen) + "+";
        div = Strings.generate((CharSequence)div, this.boxlen);
        return "+" + (String)div + "\n";
    }

    public String toString() {
        String div = this.genDivider();
        StringBuilder sb = new StringBuilder();
        sb.append(div);
        int row = 0;
        for (int[] elts : this.grid) {
            sb.append("| ");
            int col = 0;
            for (int elt : elts) {
                if (this.isDetermined(elt)) {
                    sb.append(this.internalToVisual(elt));
                } else {
                    sb.append('-');
                }
                sb.append(' ');
                if (++col % this.boxlen != 0) continue;
                sb.append("| ");
            }
            sb.append('\n');
            if (++row % this.boxlen != 0) continue;
            sb.append(div);
        }
        return sb.toString();
    }

    public String save() {
        StringBuilder sb = new StringBuilder();
        sb.append(1).append(sep);
        sb.append(this.locked ? 1 : 0).append(sep);
        sb.append(this.boxlen).append(sep);
        sb.append(this.gridlen).append(sep);
        sb.append(this.numbase).append(sep);
        sb.append(this.numstart).append(sep);
        int[][] nArray = this.grid;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] elts;
            for (int elt : elts = nArray[i]) {
                sb.append(elt).append(sep);
            }
        }
        return sb.toString();
    }

    public static SudokuGrid restore(String str) {
        int version;
        String[] bits = (str = str.replace("\n", "").replace("\r", "")).split(sep);
        if (bits.length < 6) {
            throw new RuntimeException();
        }
        int[] a = new int[bits.length];
        int i = 0;
        for (String bit : bits) {
            a[i++] = Integer.parseInt(bit.trim());
        }
        i = 0;
        if ((version = a[i++]) != 1) {
            throw new RuntimeException();
        }
        boolean locked = a[i++] != 0;
        int boxlen = a[i++];
        int gridlen = a[i++];
        int numbase = a[i++];
        int numstart = a[i++];
        SudokuGrid r = new SudokuGrid();
        r.locked = locked;
        r.boxlen = boxlen;
        r.gridlen = gridlen;
        r.numbase = numbase;
        r.numstart = numstart;
        for (int[] elts : r.grid = new int[gridlen][gridlen]) {
            for (int col = 0; col < gridlen; ++col) {
                elts[col] = a[i++];
            }
        }
        return r;
    }
}

