/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku;

import com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku.SudokuGrid;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SudokuGame {
    private SudokuGrid g0;
    private SudokuGrid g;
    private List<IGameListener> listeners = new ArrayList<IGameListener>();

    public SudokuGame() {
    }

    public SudokuGame(SudokuGrid grid) {
        this.load(grid);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.g == null ? 0 : this.g.hashCode());
        result = 31 * result + (this.g0 == null ? 0 : this.g0.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SudokuGame other = (SudokuGame)obj;
        if (this.g == null ? other.g != null : !this.g.equals(other.g)) {
            return false;
        }
        return !(this.g0 == null ? other.g0 != null : !this.g0.equals(other.g0));
    }

    public SudokuGrid getStartingGrid() {
        return this.g0;
    }

    public void reset() {
        this.load(this.g0);
    }

    public void load(SudokuGrid startingGrid) {
        if (startingGrid == null) {
            this.g0 = null;
            this.g = null;
        } else {
            this.g0 = startingGrid;
            this.g = startingGrid.clone();
        }
        this.notifyListeners();
    }

    public void addListener(IGameListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IGameListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        if (this.listeners.isEmpty()) {
            return;
        }
        int status = this.verify();
        for (IGameListener listener : this.listeners) {
            listener.changed(status);
        }
    }

    public int getCellCount() {
        return this.g.getCellCount();
    }

    public int getGridLength() {
        return this.g.getGridLength();
    }

    public int getBoxLength() {
        return this.g.getBoxLength();
    }

    public boolean isCompleted() {
        return this.g.verify() == 1;
    }

    public int verify() {
        return this.g.verify();
    }

    private int getRawValue(int row, int col) {
        int val = this.g.getInternalValue(row, col);
        if ((val &= 0xFF) == 255) {
            return -1;
        }
        return val & 0xFF;
    }

    public boolean isFixedValue(int row, int col) {
        int val = this.g0.getInternalValue(row, col);
        return (val & 0xFF) != 255;
    }

    public String getUserValue(int row, int col) {
        int val = this.getRawValue(row, col);
        if (val == -1) {
            return null;
        }
        return this.g.internalToVisual(val);
    }

    public boolean setUserValue(int row, int col, String str) {
        try {
            int len = this.g.getGridLength();
            if (row >= 0 && row < len && col >= 0 && col < len && !this.isFixedValue(row, col)) {
                if (str == null) {
                    this.setInternalValue(row, col, -1);
                    return true;
                }
                int val = this.g.visualToInternal(str);
                if (val >= 0 && val <= len) {
                    this.setInternalValue(row, col, val);
                    return true;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }

    public boolean clearUserValue(int row, int col) {
        return this.setUserValue(row, col, null);
    }

    private void setInternalValue(int row, int col, int value) {
        if (value == this.g.getInternalValue(row, col)) {
            return;
        }
        this.g.setInternalValue(row, col, value);
        this.notifyListeners();
    }

    public List<String> getCandidateUserValues(int row, int col) {
        List<Integer> list = this.getCandidateInternalValues(row, col);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> r = new ArrayList<String>();
        list.forEach(val -> r.add(this.g.internalToVisual((int)val)));
        return r;
    }

    private List<Integer> getCandidateInternalValues(int row, int col) {
        int val = this.g.getInternalValue(row, col);
        if ((val & 0xFF) != 255) {
            return Collections.emptyList();
        }
        if (val == -1) {
            return Collections.emptyList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        val >>>= 8;
        int i = 0;
        while (val != 0) {
            if ((val & 1) == 1) {
                list.add(i);
            }
            ++i;
            val >>>= 1;
        }
        return list;
    }

    public boolean addCandidateUserValue(int row, int col, String str) {
        try {
            int len = this.g.getGridLength();
            if (row >= 0 && row < len && col >= 0 && col < len && !this.isFixedValue(row, col)) {
                if (str == null) {
                    this.setInternalValue(row, col, -1);
                    return true;
                }
                int val = this.g.visualToInternal(str);
                if (val >= 0 && val <= len) {
                    this.addCandidateInternalValue(row, col, val);
                    return true;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }

    private void addCandidateInternalValue(int row, int col, int val) {
        int x = this.g.getInternalValue(row, col);
        if (x == -1 || (x & 0xFF) != 255) {
            x = 255;
        }
        this.g.setInternalValue(row, col, x |= 1 << val << 8);
        this.notifyListeners();
    }

    public String save() {
        Object[] a = new Object[]{Integer.toString(1), this.g0.save(), this.g.save()};
        return Strings.encodeArray(a);
    }

    public static SudokuGame restore(String str) {
        String[] a = Strings.decodeArray(str);
        if (a.length != 3) {
            throw new RuntimeException();
        }
        if (Integer.parseInt(a[0]) != 1) {
            throw new RuntimeException();
        }
        SudokuGame r = new SudokuGame();
        r.g0 = SudokuGrid.restore(a[1]);
        r.g = SudokuGrid.restore(a[2]);
        return r;
    }

    public String toString() {
        return this.g.toString();
    }

    public static interface IGameListener {
        public void changed(int var1);
    }
}

