/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku;

import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku.SudokuCanvas;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku.SudokuGame;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku.SudokuGrid;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku.SudokuUtils;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class SudokuDialog
extends JebDialog {
    public static final String pnameDisabled = ".ui.minigames.sudoku.Disabled";
    public static final String pnameMaxLevel = ".ui.minigames.sudoku.MaxLevel";
    public static final String pnameSavedState = ".ui.minigames.sudoku.SavedState";
    private static final String gameName = "Sudoku";
    private RcpClientContext context;
    private List<SudokuGrid> grids;
    private SudokuCanvas v;
    private SudokuGame game;
    private int igrid;
    private int igridMax;
    private boolean doNotShowRemoveButton;
    private boolean removeButton;
    private int code;

    public SudokuDialog(Shell parent, RcpClientContext context) {
        super(parent, gameName, true, false);
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        this.context = context;
    }

    @Override
    public Integer open() {
        super.open();
        return 0;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        this.v = new SudokuCanvas(parent, 2048);
        this.v.setLayoutData(UIUtil.createGridDataFill(true, true));
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("games.txt");){
            String buffer = Strings.decodeUTF8(IO.readInputStream(in));
            this.grids = SudokuUtils.parseData(buffer);
            if (this.grids.isEmpty()) {
                return;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
        if (this.context != null) {
            this.igrid = this.igridMax = this.context.getPropertyManager().getInteger(pnameMaxLevel);
            if (this.igrid < 0 || this.igrid >= this.grids.size()) {
                this.igrid = this.grids.size() - 1;
            }
        }
        this.game = this.load();
        this.game.addListener(new SudokuGame.IGameListener(){

            @Override
            public void changed(int status) {
                if (status == 1) {
                    if (SudokuDialog.this.igrid < SudokuDialog.this.grids.size()) {
                        ++SudokuDialog.this.igrid;
                        if (SudokuDialog.this.igrid > SudokuDialog.this.igridMax) {
                            SudokuDialog.this.igridMax = SudokuDialog.this.igrid;
                        }
                        if (SudokuDialog.this.igrid == SudokuDialog.this.grids.size()) {
                            SudokuDialog.this.code = "sudoku".hashCode() & 0xFFFF;
                        }
                    }
                    if (SudokuDialog.this.context != null) {
                        SudokuDialog.this.context.getPropertyManager().setInteger(SudokuDialog.pnameMaxLevel, SudokuDialog.this.igridMax);
                    }
                }
            }
        });
        this.v.setInput(this.game);
        this.v.setMessageOnGameCompleted("COMPLETED!\nPress Space for next.");
        this.v.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 32 && SudokuDialog.this.game.isCompleted()) {
                    if (SudokuDialog.this.igrid < SudokuDialog.this.grids.size()) {
                        SudokuDialog.this.load();
                    } else {
                        if (SudokuDialog.this.code != 0) {
                            String msg = "You've completed all levels!\n";
                            UI.info(SudokuDialog.this.getShell(), "Congratulations!", msg);
                        }
                        SudokuDialog.this.game.reset();
                    }
                }
            }
        });
        if (!this.doNotShowRemoveButton) {
            UIUtil.createCheckbox(parent, "Remove this button from my toolbar please!", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SudokuDialog.this.removeButton = ((Button)e.widget).getSelection();
                    if (SudokuDialog.this.context != null) {
                        SudokuDialog.this.context.getPropertyManager().setBoolean(SudokuDialog.pnameDisabled, SudokuDialog.this.removeButton);
                    }
                }
            });
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SudokuDialog.this.optSaveState();
            }
        });
        this.createButtons(parent, new int[]{32, 0x10000000}, 32);
    }

    @Override
    protected boolean allowKeyboardEnterExecution(Event e) {
        return false;
    }

    private SudokuGame load() {
        SudokuGame game = new SudokuGame();
        if (this.igrid < 0 || this.igrid >= this.grids.size()) {
            return game;
        }
        game.load(this.grids.get(this.igrid));
        if (this.context != null) {
            String str = this.context.getPropertyManager().getString(pnameSavedState);
            try {
                SudokuGame restoredGame = SudokuGame.restore(str);
                if (restoredGame.getStartingGrid().equals(game.getStartingGrid())) {
                    game = restoredGame;
                }
            }
            catch (Exception exception) {}
        }
        this.shell.setText(Strings.ff("Sudoku - Level %d/%d", this.igrid + 1, this.grids.size()));
        return game;
    }

    private void optSaveState() {
        if (this.context != null) {
            this.context.getPropertyManager().setString(pnameSavedState, this.game.save());
        }
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 32) {
            this.shell.close();
        } else if (buttonId == 0x10000000) {
            String msg = "Game of Sudoku (and its programmer friendly variant, Hexaku!).\n\nUse the mouse or arrow keys to select a cell.\nUse the 0-9,A-F keys to set a cell value.\nUse Shift+<value> to add a candidate value in a cell.\nUse the backspace key to clear a cell value or its candidates.\nUse the space bar to reset the current grid.\n\nYour progress is auto-saved when you close the game. Have fun!\n";
            UI.info(this.shell, "Help", msg);
        }
    }

    public void setDoNotShowRemoveButton(boolean doNotShow) {
        this.doNotShowRemoveButton = doNotShow;
    }

    public boolean isRemoveButton() {
        return this.removeButton;
    }
}

