/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku;

import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sudoku.SudokuGame;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class SudokuCanvas
extends Canvas
implements SudokuGame.IGameListener {
    private static final ILogger logger = GlobalLog.getLogger(SudokuCanvas.class);
    private Rectangle clientArea;
    private int sp;
    private SudokuGame game;
    private Point selectedCell;
    private int status;
    private String msgGameCompleted;

    public SudokuCanvas(Composite parent, int flags) {
        super(parent, flags | 0x20000000);
        this.setLayout(null);
        this.clientArea = this.getClientArea();
        UI.initialize();
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SudokuCanvas.this.clientArea = SudokuCanvas.this.getClientArea();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int y;
                int i;
                if (SudokuCanvas.this.game == null || SudokuCanvas.this.clientArea.width < 64 || SudokuCanvas.this.clientArea.height < 64) {
                    return;
                }
                int gridlen = SudokuCanvas.this.game.getGridLength();
                int boxlen = SudokuCanvas.this.game.getBoxLength();
                int spy = (SudokuCanvas.this.clientArea.height - 3) / gridlen;
                int spx = (SudokuCanvas.this.clientArea.width - 3) / gridlen;
                SudokuCanvas.this.sp = Math.min(spy, spx);
                if (SudokuCanvas.this.sp < 10) {
                    return;
                }
                GC gc = e.gc;
                try {
                    gc.setAntialias(1);
                }
                catch (SWTException sWTException) {}
                Color bgcol = gc.getBackground();
                gc.setBackground(e.display.getSystemColor(2));
                for (i = 0; i <= gridlen; ++i) {
                    gc.fillRectangle(0, i * SudokuCanvas.this.sp, gridlen * SudokuCanvas.this.sp, 1);
                }
                for (i = 0; i <= gridlen; i += boxlen) {
                    gc.fillRectangle(0, i * SudokuCanvas.this.sp, gridlen * SudokuCanvas.this.sp, 3);
                }
                for (i = 0; i <= gridlen; ++i) {
                    gc.fillRectangle(i * SudokuCanvas.this.sp, 0, 1, gridlen * SudokuCanvas.this.sp);
                }
                for (i = 0; i <= gridlen; i += boxlen) {
                    gc.fillRectangle(i * SudokuCanvas.this.sp, 0, 3, gridlen * SudokuCanvas.this.sp);
                }
                gc.fillRectangle(gridlen * SudokuCanvas.this.sp, gridlen * SudokuCanvas.this.sp, 3, 3);
                gc.setBackground(bgcol);
                UIAssetManager aman = UIAssetManager.getInstance();
                Font font = aman.getFont(gc.getFont(), (Integer)16, (Integer)1);
                gc.setFont(font);
                for (int row = 0; row < gridlen; ++row) {
                    int y2 = row * SudokuCanvas.this.sp;
                    for (int col = 0; col < gridlen; ++col) {
                        int x = col * SudokuCanvas.this.sp;
                        String str = SudokuCanvas.this.game.getUserValue(row, col);
                        if (str == null) continue;
                        Color fontcol = SudokuCanvas.this.game.isFixedValue(row, col) ? e.display.getSystemColor(16) : e.display.getSystemColor(SudokuCanvas.this.status == -1 ? 3 : 2);
                        gc.setForeground(fontcol);
                        Point pt = gc.stringExtent(str);
                        int xdelta = (SudokuCanvas.this.sp - pt.x) / 2;
                        int ydelta = (SudokuCanvas.this.sp - pt.y) / 2;
                        gc.drawString(str, x + xdelta, y2 + ydelta, true);
                    }
                }
                font = aman.getFont(gc.getFont(), (Integer)10, (Integer)1);
                gc.setFont(font);
                Color fontcol = e.display.getSystemColor(SudokuCanvas.this.status == -1 ? 3 : 2);
                gc.setForeground(fontcol);
                for (int row = 0; row < gridlen; ++row) {
                    y = row * SudokuCanvas.this.sp + 2;
                    for (int col = 0; col < gridlen; ++col) {
                        int x = col * SudokuCanvas.this.sp + 2;
                        List<String> strlist = SudokuCanvas.this.game.getCandidateUserValues(row, col);
                        if (strlist == null) continue;
                        int xdelta = 0;
                        int ydelta = 0;
                        for (String str : strlist) {
                            Point pt = gc.stringExtent(str);
                            gc.drawString(str, x + xdelta, y + ydelta, true);
                            if ((xdelta += pt.x) < SudokuCanvas.this.sp - 2) continue;
                            xdelta = 0;
                            ydelta += pt.y;
                        }
                    }
                }
                if (SudokuCanvas.this.selectedCell != null) {
                    gc.setForeground(e.display.getSystemColor(SudokuCanvas.this.status == -1 ? 3 : 9));
                    int x = SudokuCanvas.this.selectedCell.x * SudokuCanvas.this.sp + 1;
                    y = SudokuCanvas.this.selectedCell.y * SudokuCanvas.this.sp + 1;
                    int w = SudokuCanvas.this.sp;
                    int h = SudokuCanvas.this.sp;
                    gc.setLineWidth(3);
                    gc.drawRectangle(x, y, w, h);
                }
                if (SudokuCanvas.this.status == 1) {
                    gc.setFont(aman.getFont(gc.getFont(), (Integer)20, (Integer)1));
                    gc.setForeground(e.display.getSystemColor(3));
                    gc.setBackground(e.display.getSystemColor(2));
                    String str = Strings.safe(SudokuCanvas.this.msgGameCompleted, "COMPLETED!");
                    String[] lines = Strings.splitLines(str);
                    int totalHeight = 0;
                    for (String line : lines) {
                        Point pt = gc.textExtent(line);
                        totalHeight += pt.y;
                    }
                    int y3 = (e.height - totalHeight) / 2;
                    for (String line : lines) {
                        Point pt = gc.textExtent(line);
                        int x = (e.width - pt.x) / 2;
                        gc.drawText(line, x, y3, false);
                        y3 += pt.y;
                    }
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (SudokuCanvas.this.game == null || SudokuCanvas.this.game.isCompleted()) {
                    return;
                }
                int len = SudokuCanvas.this.game.getGridLength();
                if (e.keyCode == 32) {
                    SudokuCanvas.this.game.reset();
                    SudokuCanvas.this.status = SudokuCanvas.this.game.verify();
                    SudokuCanvas.this.redraw();
                } else if (e.keyCode == 0x1000001) {
                    if (SudokuCanvas.this.selectedCell == null) {
                        SudokuCanvas.this.selectedCell = new Point(0, 0);
                    } else {
                        SudokuCanvas.this.selectedCell.y = (SudokuCanvas.this.selectedCell.y - 1 + len) % len;
                    }
                    SudokuCanvas.this.redraw();
                } else if (e.keyCode == 0x1000002) {
                    if (SudokuCanvas.this.selectedCell == null) {
                        SudokuCanvas.this.selectedCell = new Point(0, 0);
                    } else {
                        SudokuCanvas.this.selectedCell.y = (SudokuCanvas.this.selectedCell.y + 1) % len;
                    }
                    SudokuCanvas.this.redraw();
                } else if (e.keyCode == 0x1000003) {
                    if (SudokuCanvas.this.selectedCell == null) {
                        SudokuCanvas.this.selectedCell = new Point(0, 0);
                    } else {
                        SudokuCanvas.this.selectedCell.x = (SudokuCanvas.this.selectedCell.x - 1 + len) % len;
                    }
                    SudokuCanvas.this.redraw();
                } else if (e.keyCode == 0x1000004) {
                    if (SudokuCanvas.this.selectedCell == null) {
                        SudokuCanvas.this.selectedCell = new Point(0, 0);
                    } else {
                        SudokuCanvas.this.selectedCell.x = (SudokuCanvas.this.selectedCell.x + 1) % len;
                    }
                    SudokuCanvas.this.redraw();
                } else if (SudokuCanvas.this.selectedCell != null) {
                    char ch = (char)e.keyCode;
                    if (ch == '\b') {
                        SudokuCanvas.this.game.clearUserValue(SudokuCanvas.this.selectedCell.y, SudokuCanvas.this.selectedCell.x);
                    } else if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f') {
                        if ((e.stateMask & SWT.MOD2) != 0) {
                            SudokuCanvas.this.game.addCandidateUserValue(SudokuCanvas.this.selectedCell.y, SudokuCanvas.this.selectedCell.x, "" + ch);
                        } else {
                            SudokuCanvas.this.game.setUserValue(SudokuCanvas.this.selectedCell.y, SudokuCanvas.this.selectedCell.x, "" + ch);
                        }
                    }
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (SudokuCanvas.this.sp > 0) {
                    int x = e.x / SudokuCanvas.this.sp;
                    int y = e.y / SudokuCanvas.this.sp;
                    if (x >= 0 && x < SudokuCanvas.this.game.getGridLength() && y >= 0 && y < SudokuCanvas.this.game.getGridLength()) {
                        SudokuCanvas.this.selectedCell = new Point(x, y);
                        SudokuCanvas.this.redraw();
                        return;
                    }
                }
                SudokuCanvas.this.selectedCell = null;
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int u = 50;
        if (this.game != null) {
            if (wHint == -1 && hHint == -1) {
                return new Point(u * this.game.getGridLength(), u * this.game.getGridLength());
            }
            if (wHint != -1 && hHint == -1) {
                u = wHint / this.game.getGridLength();
                return new Point(wHint, u * this.game.getGridLength());
            }
            if (wHint == -1 && hHint != -1) {
                u = hHint / this.game.getGridLength();
                return new Point(u * this.game.getGridLength(), hHint);
            }
        } else if (wHint == -1 && hHint == -1) {
            return new Point(u * 9, u * 9);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public SudokuGame getInput() {
        return this.game;
    }

    public void setInput(SudokuGame g) {
        if (this.game != null) {
            this.game.removeListener(this);
            this.game = null;
            this.status = 0;
            this.selectedCell = null;
        }
        if (g != null) {
            this.game = g;
            this.status = this.game.verify();
            this.selectedCell = null;
            this.game.addListener(this);
        }
        this.redraw();
    }

    @Override
    public void changed(int status) {
        this.status = status;
        this.redraw();
    }

    public void setMessageOnGameCompleted(String text) {
        this.msgGameCompleted = text;
    }
}

