/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban;

import com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban.SokoGrid;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SokoUtils {
    public static List<SokoGrid> parseFile(File file) throws IOException {
        String buffer = Strings.decodeUTF8(IO.readFile(file));
        return SokoUtils.parseData(buffer);
    }

    public static List<SokoGrid> parseData(String buffer) throws IOException {
        ArrayList<SokoGrid> grids = new ArrayList<SokoGrid>();
        String[] lines = Strings.splitLines(buffer);
        int i = 0;
        while (true) {
            int i0 = -1;
            int i1 = -1;
            while (i < lines.length) {
                String line = lines[i];
                if (line.trim().startsWith("#")) {
                    if (i0 < 0) {
                        i0 = i;
                    }
                } else if (i0 >= 0) {
                    i1 = i;
                    break;
                }
                ++i;
            }
            if (i0 < 0 || i1 < 0) break;
            String str = Strings.join("\n", Arrays.asList(lines).subList(i0, i1));
            grids.add(SokoGrid.parse(str));
        }
        return grids;
    }
}

