/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Arrays;

public final class SokoGrid {
    protected static final int FLAG_TYPE = 3;
    protected static final int FLAG_OCCU = 12;
    public static final int EMPTY = 0;
    public static final int WALL = 1;
    public static final int DROP_POINT = 2;
    public static final int CRATE = 4;
    public static final int PERSON = 8;
    public static final int E = 0;
    public static final int W = 1;
    public static final int D = 2;
    public static final int P = 8;
    public static final int C = 4;
    private int[][] grid;
    private Pos pp;
    private int rowcount;
    private int colcount;

    public SokoGrid(int[][] startingGame) {
        if (startingGame == null || startingGame.length == 0) {
            throw new IllegalArgumentException("Null or empty grid!");
        }
        this.grid = new int[startingGame.length][];
        this.pp = null;
        this.rowcount = startingGame.length;
        this.colcount = startingGame[0].length;
        int len = -1;
        int crateCount = 0;
        int dropCount = 0;
        int row = 0;
        for (int[] elts : startingGame) {
            if (len == -1) {
                if (elts.length == 0) {
                    throw new IllegalArgumentException("The grid has a 0-element row!");
                }
                len = elts.length;
            } else if (elts.length != len) {
                throw new IllegalArgumentException("Not a grid!");
            }
            int[] rowcopy = new int[elts.length];
            int col = 0;
            for (int elt : elts) {
                int occu;
                int type = SokoGrid.getTileType(startingGame, row, col);
                if (type != 0 && type != 1) {
                    if (type == 2) {
                        ++dropCount;
                    } else {
                        throw new IllegalArgumentException("Illegal tile type!");
                    }
                }
                if ((occu = SokoGrid.getTileOccupation(startingGame, row, col)) != 0) {
                    if (occu == 4) {
                        if (type != 0 && type != 2) {
                            throw new IllegalArgumentException("Illegal tile!");
                        }
                        ++crateCount;
                    } else if (occu == 8) {
                        if (type != 0 && type != 2) {
                            throw new IllegalArgumentException("Illegal tile!");
                        }
                        if (this.pp != null) {
                            throw new IllegalArgumentException("Multiple persons found!");
                        }
                        this.pp = new Pos(row, col);
                    } else {
                        throw new IllegalArgumentException("Illegal tile occupation!");
                    }
                }
                rowcopy[col] = elt;
                ++col;
            }
            this.grid[row] = rowcopy;
            ++row;
        }
        if (this.pp == null) {
            throw new IllegalArgumentException("Missing the person!");
        }
        if (crateCount == 0) {
            throw new IllegalArgumentException("No crate found!");
        }
        if (crateCount > dropCount) {
            throw new IllegalArgumentException("More crates than drop-points!");
        }
    }

    public int getCountOfRows() {
        return this.rowcount;
    }

    public int getCountOfColumns() {
        return this.colcount;
    }

    public Pos getCurrentPosition() {
        return this.pp;
    }

    public int getTileType(Pos pos) {
        return this.grid[pos.row][pos.col] & 3;
    }

    public int getTileOccupation(Pos pos) {
        return this.grid[pos.row][pos.col] & 0xC;
    }

    private static int getTileType(int[][] grid, int row, int col) {
        return grid[row][col] & 3;
    }

    private static int getTileOccupation(int[][] grid, int row, int col) {
        return grid[row][col] & 0xC;
    }

    public int getTileType(int elt) {
        return elt & 3;
    }

    public int getTileOccupation(int elt) {
        return elt & 0xC;
    }

    public int[][] cloneGrid() {
        int[][] grid1 = new int[this.grid.length][];
        int i = 0;
        for (int[] elts : this.grid) {
            grid1[i++] = Arrays.copyOf(elts, elts.length);
        }
        return grid1;
    }

    public static SokoGrid parse(String str) {
        int colcount = 0;
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : Strings.splitLines(str)) {
            if (!(line = Strings.rtrim(line)).trim().startsWith("#")) {
                throw new RuntimeException("Illegal grid data: row does not start with # or space");
            }
            lines.add(line);
            int len = line.length();
            if (len <= colcount) continue;
            colcount = len;
        }
        int rowcount = lines.size();
        if (colcount == 0 || rowcount == 0) {
            throw new RuntimeException("Empty grid");
        }
        int[][] a = new int[rowcount][colcount];
        int row = 0;
        for (String line : lines) {
            for (int col = 0; col < line.length(); ++col) {
                char ch = line.charAt(col);
                a[row][col] = switch (ch) {
                    case ' ' -> 0;
                    case '#' -> 1;
                    case '.' -> 2;
                    case '@' -> 8;
                    case '+' -> 10;
                    case '$' -> 4;
                    case '*' -> 6;
                    default -> throw new RuntimeException("Illegal grid character: " + ch);
                };
            }
            ++row;
        }
        return new SokoGrid(a);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int[][] nArray = this.grid;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] row;
            block14: for (int elt : row = nArray[i]) {
                int type = this.getTileType(elt);
                int occu = this.getTileOccupation(elt);
                if (occu == 0) {
                    switch (type) {
                        case 0: {
                            sb.append(' ');
                            continue block14;
                        }
                        case 1: {
                            sb.append("#");
                            continue block14;
                        }
                        case 2: {
                            sb.append(".");
                            continue block14;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
                if (occu == 8) {
                    switch (type) {
                        case 0: {
                            sb.append("@");
                            continue block14;
                        }
                        case 2: {
                            sb.append("+");
                            continue block14;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
                if (occu == 4) {
                    switch (type) {
                        case 0: {
                            sb.append("$");
                            continue block14;
                        }
                        case 2: {
                            sb.append("*");
                            continue block14;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
                sb.append("?");
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static class Pos {
        int row;
        int col;

        public Pos(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.col;
            result = 31 * result + this.row;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pos other = (Pos)obj;
            if (this.col != other.col) {
                return false;
            }
            return this.row == other.row;
        }

        public String toString() {
            return "(" + this.row + ", " + this.col + ")";
        }
    }
}

