/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban;

import com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban.SokoGrid;
import java.util.ArrayList;
import java.util.List;

public final class SokoGame {
    private SokoGrid startingGrid;
    private List<IGameListener> listeners = new ArrayList<IGameListener>();
    private int[][] grid;
    private SokoGrid.Pos pp;
    private int rowcount;
    private int colcount;
    private int movecount;

    public SokoGame() {
    }

    public SokoGame(SokoGrid grid) {
        this.load(grid);
    }

    public SokoGrid getStartingGrid() {
        return this.startingGrid;
    }

    public void reset() {
        this.load(this.startingGrid);
    }

    public void load(SokoGrid startingGrid) {
        this.startingGrid = startingGrid;
        if (startingGrid == null) {
            this.grid = null;
            this.pp = null;
            this.rowcount = 0;
            this.colcount = 0;
            this.movecount = 0;
        } else {
            this.grid = startingGrid.cloneGrid();
            this.pp = startingGrid.getCurrentPosition();
            this.rowcount = startingGrid.getCountOfRows();
            this.colcount = startingGrid.getCountOfColumns();
            this.movecount = 0;
        }
        this.notifyListeners();
    }

    public int getCountOfRows() {
        return this.rowcount;
    }

    public int getCountOfColumns() {
        return this.colcount;
    }

    public void addListener(IGameListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IGameListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IGameListener listener : this.listeners) {
            listener.changed(this.isCompleted());
        }
    }

    public boolean isCompleted() {
        int[][] nArray = this.grid;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] elts;
            for (int elt : elts = nArray[i]) {
                if (this.getTileOccupation(elt) != 4 || this.getTileType(elt) == 2) continue;
                return false;
            }
        }
        return true;
    }

    public boolean moveUp() {
        return this.move(Direction.UP);
    }

    public boolean moveDown() {
        return this.move(Direction.DOWN);
    }

    public boolean moveLeft() {
        return this.move(Direction.LEFT);
    }

    public boolean moveRight() {
        return this.move(Direction.RIGHT);
    }

    public boolean move(Direction dir) {
        SokoGrid.Pos pos1 = this.calcNextPos(dir, this.pp);
        int ttype = this.getTileType(pos1);
        if (ttype == 1) {
            return false;
        }
        int toccu = this.getTileOccupation(pos1);
        if (toccu == 0) {
            this.occupyTile(pos1, 8);
            this.clearTile(this.pp);
            this.pp = pos1;
            ++this.movecount;
            this.notifyListeners();
            return true;
        }
        if (toccu == 4) {
            SokoGrid.Pos pos2 = this.calcNextPos(dir, pos1);
            if (!this.isFreeTile(pos2)) {
                return false;
            }
            this.occupyTile(pos2, 4);
            this.occupyTile(pos1, 8);
            this.clearTile(this.pp);
            this.pp = pos1;
            ++this.movecount;
            this.notifyListeners();
            return true;
        }
        return false;
    }

    public boolean isFreeTile(SokoGrid.Pos pos) {
        int ttype = this.getTileType(pos);
        if (ttype == 1) {
            return false;
        }
        return this.getTileOccupation(pos) == 0;
    }

    private void clearTile(SokoGrid.Pos pos) {
        this.occupyTile(pos, 0);
    }

    private void occupyTile(SokoGrid.Pos pos, int occu) {
        int v = this.grid[pos.row][pos.col];
        this.grid[pos.row][pos.col] = v & 3 | occu;
    }

    private SokoGrid.Pos calcNextPos(Direction dir, SokoGrid.Pos pos) {
        return this.calcNextPos(dir, pos.row, pos.col);
    }

    private SokoGrid.Pos calcNextPos(Direction dir, int row, int col) {
        switch (dir) {
            case UP: {
                if (--row != -1) break;
                row = this.rowcount - 1;
                break;
            }
            case DOWN: {
                if (++row != this.rowcount) break;
                row = 0;
                break;
            }
            case LEFT: {
                if (--col != -1) break;
                col = this.colcount - 1;
                break;
            }
            case RIGHT: {
                if (++col != this.colcount) break;
                col = 0;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return new SokoGrid.Pos(row, col);
    }

    public SokoGrid.Pos getCurrentPosition() {
        return this.pp;
    }

    public int getMoveCount() {
        return this.movecount;
    }

    public int getTileType(SokoGrid.Pos pos) {
        return this.grid[pos.row][pos.col] & 3;
    }

    public int getTileOccupation(SokoGrid.Pos pos) {
        return this.grid[pos.row][pos.col] & 0xC;
    }

    public int getTileType(int elt) {
        return elt & 3;
    }

    public int getTileOccupation(int elt) {
        return elt & 0xC;
    }

    public static interface IGameListener {
        public void changed(boolean var1);
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

