/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban;

import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban.SokoCanvas;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban.SokoGame;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban.SokoGrid;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban.SokoUtils;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class SokoDialog
extends JebDialog {
    public static final String pnameMaxLevel = ".ui.minigames.sokoban.MaxLevel";
    public static final String pnameDisabled = ".ui.minigames.sokoban.Disabled";
    private RcpClientContext context;
    private List<SokoGrid> grids;
    private SokoCanvas v;
    private SokoGame game;
    private int igrid;
    private int igridMax;
    private boolean doNotShowRemoveButton;
    private boolean removeButton;
    private int code;

    public SokoDialog(Shell parent, RcpClientContext context) {
        super(parent, "Sokoban", true, false);
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        this.context = context;
    }

    @Override
    public Integer open() {
        super.open();
        return 0;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        this.v = new SokoCanvas(parent, 2048);
        this.v.setLayoutData(UIUtil.createGridDataFill(true, true));
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("games.txt");){
            String buffer = Strings.decodeUTF8(IO.readInputStream(in));
            this.grids = SokoUtils.parseData(buffer);
            if (this.grids.isEmpty()) {
                return;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
        if (this.context != null) {
            this.igrid = this.igridMax = this.context.getPropertyManager().getInteger(pnameMaxLevel);
            if (this.igrid < 0 || this.igrid >= this.grids.size()) {
                this.igrid = this.grids.size() - 1;
            }
        }
        this.game = new SokoGame();
        this.game.addListener(new SokoGame.IGameListener(){

            @Override
            public void changed(boolean completed) {
                if (completed) {
                    if (SokoDialog.this.igrid < SokoDialog.this.grids.size()) {
                        ++SokoDialog.this.igrid;
                        if (SokoDialog.this.igrid > SokoDialog.this.igridMax) {
                            SokoDialog.this.igridMax = SokoDialog.this.igrid;
                        }
                        if (SokoDialog.this.igrid == SokoDialog.this.grids.size()) {
                            SokoDialog.this.code = "sokoban".hashCode() & 0xFFFF;
                        }
                    }
                    if (SokoDialog.this.context != null) {
                        SokoDialog.this.context.getPropertyManager().setInteger(SokoDialog.pnameMaxLevel, SokoDialog.this.igridMax);
                    }
                }
            }
        });
        this.load();
        this.v.setInput(this.game);
        this.v.setMessageOnGameCompleted("COMPLETED!\nPress Space for next.");
        this.v.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 112) {
                    if (SokoDialog.this.igrid > 0) {
                        --SokoDialog.this.igrid;
                        SokoDialog.this.load();
                    }
                } else if (e.keyCode == 110 && SokoDialog.this.igrid < SokoDialog.this.igridMax && SokoDialog.this.igrid < SokoDialog.this.grids.size() - 1) {
                    ++SokoDialog.this.igrid;
                    SokoDialog.this.load();
                }
                if (e.keyCode == 32 && SokoDialog.this.game.isCompleted()) {
                    if (SokoDialog.this.igrid < SokoDialog.this.grids.size()) {
                        SokoDialog.this.load();
                    } else {
                        if (SokoDialog.this.code != 0) {
                            String msg = "You've completed all levels!\n";
                            UI.info(SokoDialog.this.getShell(), "Congratulations!", msg);
                        }
                        SokoDialog.this.game.reset();
                    }
                }
            }
        });
        if (!this.doNotShowRemoveButton) {
            UIUtil.createCheckbox(parent, "Remove this button from my toolbar please!", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SokoDialog.this.removeButton = ((Button)e.widget).getSelection();
                    if (SokoDialog.this.context != null) {
                        SokoDialog.this.context.getPropertyManager().setBoolean(SokoDialog.pnameDisabled, SokoDialog.this.removeButton);
                    }
                }
            });
        }
        this.createButtons(parent, new int[]{32, 0x10000000}, 32);
    }

    @Override
    protected boolean allowKeyboardEnterExecution(Event e) {
        return false;
    }

    private void load() {
        if (this.igrid < 0 || this.igrid >= this.grids.size()) {
            return;
        }
        this.game.load(this.grids.get(this.igrid));
        this.shell.setText(Strings.ff("Sokoban - Level %d/%d", this.igrid + 1, this.grids.size()));
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 32) {
            this.shell.close();
        } else if (buttonId == 0x10000000) {
            String msg = "Game of Sokoban.\n\nThe goal of the game is to push crates (black boxes) on the drop points (red circles).\n\nUse the arrow keys to navigate.\nUse the space bar to reset the current level if blocked.\nUse P to load the previous level and N to load the next level, up to your current best.\n\nHave fun!\n";
            UI.info(this.shell, "Help", msg);
        }
    }

    public void setDoNotShowRemoveButton(boolean doNotShow) {
        this.doNotShowRemoveButton = doNotShow;
    }

    public boolean isRemoveButton() {
        return this.removeButton;
    }
}

