/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban;

import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban.SokoGame;
import com.pnfsoftware.jeb.rcpclient.util.minigames.sokoban.SokoGrid;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class SokoCanvas
extends Canvas
implements SokoGame.IGameListener {
    Rectangle clientArea;
    SokoGame game;
    String msgGameCompleted;
    boolean completed;

    public SokoCanvas(Composite parent, int flags) {
        super(parent, flags | 0x20000000);
        this.setLayout(null);
        this.clientArea = this.getClientArea();
        UI.initialize();
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SokoCanvas.this.clientArea = SokoCanvas.this.getClientArea();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (SokoCanvas.this.game == null || SokoCanvas.this.clientArea.width < 64 || SokoCanvas.this.clientArea.height < 64) {
                    return;
                }
                GC gc = e.gc;
                try {
                    gc.setAntialias(1);
                }
                catch (SWTException sWTException) {}
                int rowcount = SokoCanvas.this.game.getCountOfRows();
                int colcount = SokoCanvas.this.game.getCountOfColumns();
                int spy = SokoCanvas.this.clientArea.height / rowcount;
                int spx = SokoCanvas.this.clientArea.width / colcount;
                int sp = Math.min(spy, spx);
                UIAssetManager aman = UIAssetManager.getInstance();
                Image img = aman.getImage("other/brickwall_64.png");
                ImageData imgdata = img.getImageData();
                int imgH = imgdata.height;
                int imgW = imgdata.width;
                int y = 0;
                for (int row = 0; row < rowcount; ++row) {
                    int x = 0;
                    for (int col = 0; col < colcount; ++col) {
                        int os;
                        SokoGrid.Pos pos = new SokoGrid.Pos(row, col);
                        int tt = SokoCanvas.this.game.getTileType(pos);
                        int to = SokoCanvas.this.game.getTileOccupation(pos);
                        if (tt == 1) {
                            gc.drawImage(img, 0, 0, imgW, imgH, x, y, sp, sp);
                        }
                        if (tt == 2) {
                            gc.setForeground(e.display.getSystemColor(2));
                            if (to == 4) {
                                gc.setBackground(e.display.getSystemColor(6));
                            } else {
                                gc.setBackground(e.display.getSystemColor(4));
                            }
                            os = Math.min(20, sp);
                            gc.fillOval(x + sp / 2 - os / 2, y + sp / 2 - os / 2, os, os);
                        }
                        if (to == 8) {
                            os = Math.min(30, sp);
                            gc.setLineWidth(os < 30 ? 1 : 6);
                            gc.setForeground(e.display.getSystemColor(9));
                            gc.setBackground(e.display.getSystemColor(2));
                            gc.drawOval(x + sp / 2 - os / 2, y + sp / 2 - os / 2, os, os);
                        }
                        if (to == 4) {
                            gc.setForeground(e.display.getSystemColor(2));
                            gc.setBackground(e.display.getSystemColor(2));
                            int m = 10;
                            if (sp > m) {
                                gc.setLineWidth(4);
                                gc.drawRectangle(x + m, y + m, sp - 2 * m, sp - 2 * m);
                            } else {
                                gc.setLineWidth(1);
                                gc.drawRectangle(x, y, sp, sp);
                            }
                        }
                        x += sp;
                    }
                    y += sp;
                }
                if (SokoCanvas.this.completed) {
                    Point pt;
                    gc.setFont(aman.getFont(gc.getFont(), (Integer)20, (Integer)1));
                    gc.setForeground(e.display.getSystemColor(3));
                    gc.setBackground(e.display.getSystemColor(2));
                    String str = Strings.safe(SokoCanvas.this.msgGameCompleted, "COMPLETED!");
                    String[] lines = Strings.splitLines(str);
                    int totalHeight = 0;
                    for (String line : lines) {
                        pt = gc.textExtent(line);
                        totalHeight += pt.y;
                    }
                    y = (e.height - totalHeight) / 2;
                    for (String line : lines) {
                        pt = gc.textExtent(line);
                        int x = (e.width - pt.x) / 2;
                        gc.drawText(line, x, y, false);
                        y += pt.y;
                    }
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (SokoCanvas.this.game == null || SokoCanvas.this.game.isCompleted()) {
                    return;
                }
                if (e.keyCode == 32) {
                    SokoCanvas.this.game.reset();
                } else if (e.keyCode == 0x1000001) {
                    SokoCanvas.this.game.moveUp();
                } else if (e.keyCode == 0x1000002) {
                    SokoCanvas.this.game.moveDown();
                } else if (e.keyCode == 0x1000003) {
                    SokoCanvas.this.game.moveLeft();
                } else if (e.keyCode == 0x1000004) {
                    SokoCanvas.this.game.moveRight();
                }
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int u = 64;
        if (this.game != null) {
            if (wHint == -1 && hHint == -1) {
                return new Point(u * this.game.getCountOfColumns(), u * this.game.getCountOfRows());
            }
            if (wHint != -1 && hHint == -1) {
                u = wHint / this.game.getCountOfColumns();
                return new Point(wHint, u * this.game.getCountOfRows());
            }
            if (wHint == -1 && hHint != -1) {
                u = hHint / this.game.getCountOfRows();
                return new Point(u * this.game.getCountOfColumns(), hHint);
            }
        } else if (wHint == -1 && hHint == -1) {
            return new Point(u * 10, u * 10);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public SokoGame getInput() {
        return this.game;
    }

    public void setInput(SokoGame g) {
        if (this.game != null) {
            this.game.removeListener(this);
            this.game = null;
            this.completed = false;
        }
        if (g != null) {
            this.game = g;
            this.completed = this.game.isCompleted();
            this.game.addListener(this);
        }
        this.redraw();
    }

    @Override
    public void changed(boolean completed) {
        this.completed = completed;
        this.redraw();
    }

    public void setMessageOnGameCompleted(String text) {
        this.msgGameCompleted = text;
    }
}

