/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util.asm;

import com.pnfsoftware.jeb.core.units.code.asm.analyzer.ReferenceType;
import com.pnfsoftware.jeb.rcpclient.util.asm.StringTokenExtractor;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TokenExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NativeTokenExtractor {
    private static final String xref = "; xref: ";
    private static final String dynTarget = "; -> ";
    private static final String routine = "; ROUTINE: ";
    private static final String trampoline = "h: ";
    private static final StringTokenExtractor.IStringDelimiterFinder DF_Assignment_List = (s, i) -> s.charAt(i) == '=' || Strings.containsAt(s, i, " /");
    private static final StringTokenExtractor.IStringDelimiterFinder DF_xref_List = (s, i) -> Strings.containsAt(s, i - xref.length() + 1, xref) || NativeTokenExtractor.isSourceEnding(s, i);
    private static final StringTokenExtractor.IStringDelimiterFinder DF_dynamic_Target = (s, i) -> Strings.containsAt(s, i - dynTarget.length() + 1, dynTarget);
    private static final StringTokenExtractor.IStringDelimiterFinder DF_routine_desc = (s, i) -> Strings.containsAt(s, i - routine.length() + 1, routine);
    private static final StringTokenExtractor.IStringDelimiterFinder DF_routine_desc_trampoline = (s, i) -> Strings.containsAt(s, i - trampoline.length() + 1, trampoline) || i == s.length() - 1 && s.charAt(i) == ')';
    private static List<TokenExtractor> tokenList = null;

    private static boolean isSourceEnding(String s, int i) {
        if (i + 5 > s.length()) {
            return false;
        }
        if (!Strings.containsAt(s, i, " (")) {
            return false;
        }
        for (ReferenceType ref : ReferenceType.values()) {
            if (!Strings.containsAt(s, i + 2, ref.getStrCode())) continue;
            return true;
        }
        return false;
    }

    public static List<TokenExtractor> getTokenList() {
        if (tokenList == null) {
            ArrayList<TokenExtractor> list = new ArrayList<TokenExtractor>(TokenExtractor.getGenericTokenList());
            list.add(new StringTokenExtractor(DF_Assignment_List));
            list.add(new StringTokenExtractor(DF_xref_List));
            list.add(new StringTokenExtractor(DF_dynamic_Target));
            list.add(new StringTokenExtractor(DF_routine_desc));
            list.add(new StringTokenExtractor(DF_routine_desc_trampoline));
            tokenList = Collections.unmodifiableList(list);
        }
        return tokenList;
    }
}

