/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public abstract class WinProcessMemSearch {
    private static Kernel32 kernel32;
    private static Psapi psapi;

    static boolean canUse() {
        return kernel32 != null && psapi != null;
    }

    public boolean search() {
        int[] pids = new int[1000];
        IntByReference abytescnt = new IntByReference();
        if (!psapi.EnumProcesses(pids, pids.length * 4, abytescnt)) {
            return false;
        }
        int pidcnt = abytescnt.getValue() / 4;
        for (int pid : pids = Arrays.copyOf(pids, pidcnt)) {
            this.examineProcess(pid);
        }
        return true;
    }

    private boolean examineProcess(int pid) {
        WinNT.HANDLE prochandle = kernel32.OpenProcess(0x1F1FFB, false, pid);
        if (prochandle == null) {
            return false;
        }
        try {
            char[] chars = new char[512];
            int cnt = psapi.GetProcessImageFileName(prochandle, chars, 512);
            if (cnt == 0) {
                boolean bl = false;
                return bl;
            }
            String procname = new String(chars, 0, cnt);
            if (this.filterProcessName(procname)) {
                Pointer addr = null;
                WinNT.MEMORY_BASIC_INFORMATION info = new WinNT.MEMORY_BASIC_INFORMATION();
                while (true) {
                    BaseTSD.SIZE_T size = new BaseTSD.SIZE_T((long)info.size());
                    if ((size = kernel32.VirtualQueryEx(prochandle, addr, info, size)).longValue() == 0L) break;
                    if (info.state.intValue() == 4096) {
                        this.examineMemory(prochandle, info.baseAddress, info.regionSize, pid, procname);
                    }
                    addr = new Pointer(Pointer.nativeValue((Pointer)info.baseAddress) + info.regionSize.longValue());
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            kernel32.CloseHandle(prochandle);
        }
    }

    private boolean examineMemory(WinNT.HANDLE prochandle, Pointer base, BaseTSD.SIZE_T size, int pid, String procname) {
        IntByReference readcnt;
        if (size.longValue() >= 200000000L) {
            return false;
        }
        int s = size.intValue();
        Memory m = new Memory((long)s);
        if (kernel32.ReadProcessMemory(prochandle, base, (Pointer)m, s, readcnt = new IntByReference())) {
            ByteBuffer buf = m.getByteBuffer(0L, (long)s);
            this.examineBuffer(buf, Pointer.nativeValue((Pointer)base), pid, procname);
        }
        return true;
    }

    protected abstract void examineBuffer(ByteBuffer var1, long var2, int var4, String var5);

    protected boolean filterProcessName(String name) {
        return true;
    }

    static {
        if (Platform.getOSType() == 2) {
            kernel32 = (Kernel32)Native.load((String)"kernel32", Kernel32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
            psapi = (Psapi)Native.load((String)"psapi", Psapi.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
        }
    }
}

