/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util;

import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.format.IAsciiable;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.HashMap;
import java.util.Map;

public class TextHistoryCollection
implements IAsciiable {
    Map<String, TextHistory> map = new HashMap<String, TextHistory>();

    public boolean add(String name, TextHistory history) {
        if (this.map.containsKey(name)) {
            return false;
        }
        this.map.put(name, history);
        return true;
    }

    public TextHistory get(String name) {
        TextHistory r = this.map.get(name);
        if (r == null) {
            r = new TextHistory();
            this.map.put(name, r);
        }
        return r;
    }

    public boolean remove(String name) {
        return this.map.remove(name) != null;
    }

    @Override
    public String encode() {
        StringBuilder sb = new StringBuilder();
        sb.append("map=");
        for (String name : this.map.keySet()) {
            TextHistory history = this.map.get(name);
            if (history == null) continue;
            sb.append(Strings.urlencodeUTF8(name) + ":" + Strings.urlencodeUTF8(history.encode()) + ",");
        }
        return sb.toString();
    }

    public static TextHistoryCollection decode(String s) {
        try {
            String[] couples;
            TextHistoryCollection r = new TextHistoryCollection();
            String map = Strings.parseUrlParameter(s, "map");
            for (String couple : couples = map.split(",")) {
                String[] name_data = couple.split(":");
                String name = Strings.urldecodeUTF8(name_data[0]);
                String data = Strings.urldecodeUTF8(name_data[1]);
                r.map.put(name, TextHistory.decode(data));
            }
            return r;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

