/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.IAsciiable;
import com.pnfsoftware.jeb.util.format.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TextHistory
implements IAsciiable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int defaultMaxEntries = 100;
    private int maxcnt;
    private ArrayList<String> history;
    private int ptr;
    private boolean allowDuplicates;

    public TextHistory() {
        this(100, null);
    }

    public TextHistory(int maxcnt) {
        this(maxcnt, null);
    }

    public TextHistory(List<String> history) {
        this(history.size(), history);
    }

    public TextHistory(int maxcnt, List<String> init) {
        if (maxcnt <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxcnt = maxcnt;
        this.history = new ArrayList(maxcnt);
        this.ptr = 0;
        if (init == null) {
            return;
        }
        if (init.size() > maxcnt) {
            for (int i = init.size() - maxcnt; i < init.size(); ++i) {
                this.history.add(init.get(i));
            }
        } else {
            this.history = new ArrayList<String>(init);
        }
        this.ptr = this.history.size() % maxcnt;
    }

    public void clear() {
        this.history.clear();
        this.ptr = 0;
    }

    public int getMaxCount() {
        return this.maxcnt;
    }

    public boolean getAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean enabled) {
        this.allowDuplicates = enabled;
    }

    public int size() {
        return this.history.size();
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public boolean isFull() {
        int cursize = this.history.size();
        if (cursize == this.maxcnt) {
            Assert.a(this.ptr < cursize);
            return true;
        }
        Assert.a(cursize < this.maxcnt && this.ptr == cursize);
        return false;
    }

    public boolean record(String text) {
        int index;
        if (text == null) {
            return false;
        }
        if (!this.allowDuplicates && (index = this.history.indexOf(text)) >= 0) {
            int nextIndex = this.increment(index);
            while (nextIndex != this.ptr) {
                this.history.set(index, this.history.get(nextIndex));
                index = nextIndex;
                nextIndex = this.increment(index);
            }
            this.history.set(index, text);
            return true;
        }
        if (this.isFull()) {
            this.history.set(this.ptr, text);
        } else {
            this.history.add(text);
        }
        this.ptr = this.increment(this.ptr);
        return true;
    }

    public boolean remove(String value) {
        int index = this.history.indexOf(value);
        if (index < 0) {
            return false;
        }
        if (!this.isFull()) {
            this.history.remove(index);
            --this.ptr;
        } else {
            this.history.remove(index);
            if (index < this.ptr) {
                --this.ptr;
            }
            while (this.ptr != 0) {
                String s = this.history.remove(0);
                this.history.add(s);
                --this.ptr;
            }
            this.ptr = this.maxcnt - 1;
        }
        return true;
    }

    private int increment(int index) {
        return (index + 1) % this.maxcnt;
    }

    private int decrement(int index) {
        return (index - 1 + this.maxcnt) % this.maxcnt;
    }

    public List<String> getAll() {
        int i;
        if (this.history.size() < this.maxcnt) {
            return new ArrayList<String>(this.history);
        }
        if (this.history.size() != this.maxcnt) {
            throw new RuntimeException();
        }
        ArrayList<String> r = new ArrayList<String>();
        for (i = this.ptr; i < this.maxcnt; ++i) {
            r.add(this.history.get(i));
        }
        for (i = 0; i < this.ptr; ++i) {
            r.add(this.history.get(i));
        }
        return r;
    }

    public String getLast() {
        if (this.history.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.history.get(this.decrement(this.ptr));
    }

    public List<String> getLast(int cnt) {
        if (this.history.size() < cnt) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ArrayList<String> r = new ArrayList<String>();
        int i = this.decrement(this.ptr);
        while (cnt > 0) {
            r.add(0, this.history.get(i));
            i = this.decrement(i);
            --cnt;
        }
        return r;
    }

    @Override
    public String encode() {
        StringBuilder sb = new StringBuilder();
        Strings.ff(sb, "maxcount=%d", this.maxcnt);
        sb.append("&strings=");
        sb.append(Strings.encodeArray(this.getAll().toArray()));
        return sb.toString();
    }

    public static TextHistory decode(String s) {
        try {
            String[] parts = Strings.parseUrlParameters(s, "maxcount", "strings");
            int maxcount = Integer.parseInt(parts[0]);
            String[] array = Strings.decodeArray(parts[1]);
            return new TextHistory(maxcount, Arrays.asList(array));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

