/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util;

import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.ITypedValue;
import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValueNumber;
import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValuePrimitive;
import com.pnfsoftware.jeb.core.units.code.debug.impl.DebuggerUtil;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueArray;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueDouble;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueFloat;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueObject;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueRaw;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueString;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class DbgTypedValueUtil {
    public static String formatAddress(long address, IDebuggerUnit unit) {
        if (unit.getTargetInformation().getProcessorType().is64Bit()) {
            return Strings.f("%08X'%08X", (int)(address >> 32), (int)address);
        }
        return Strings.f("%08X", (int)address);
    }

    public static long bytesToAddress(byte[] data, IDebuggerUnit unit) {
        ByteOrder targetByteOrder = unit.getTargetInformation().getEndianness().toByteOrder();
        ByteBuffer b = ByteBuffer.wrap(data).order(targetByteOrder);
        if (unit.getTargetInformation().getProcessorType().is64Bit()) {
            if (data.length >= 8) {
                return b.getLong();
            }
        } else if (data.length >= 4) {
            return b.getInt();
        }
        return 0L;
    }

    public static String formatValue(ITypedValue value, int index, IDebuggerUnit unit) {
        block22: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block21: {
                                    if (!(value instanceof ValueDouble) && !(value instanceof ValueFloat)) break block21;
                                    if (index == 0) {
                                        Number v = ((AbstractValueNumber)value).getValue();
                                        return Strings.f("%f", v.doubleValue());
                                    }
                                    break block22;
                                }
                                if (!(value instanceof AbstractValueNumber)) break block23;
                                Number v = ((AbstractValueNumber)value).getValue();
                                if (index == 0) {
                                    return Long.toString(v.longValue());
                                }
                                if (index == 1) {
                                    return Strings.f("%Xh", v.longValue());
                                }
                                break block22;
                            }
                            if (!(value instanceof ValueString)) break block24;
                            if (index == 0) {
                                String v = ((ValueString)value).getValue();
                                return v;
                            }
                            break block22;
                        }
                        if (!(value instanceof ValueObject)) break block25;
                        if (index == 0) {
                            long objectId = ((ValueObject)value).getObjectId();
                            if (objectId == 0L) {
                                return "null";
                            }
                            return "id=" + objectId;
                        }
                        break block22;
                    }
                    if (!(value instanceof ValueArray)) break block26;
                    if (index == 0) {
                        long objectId = ((ValueArray)value).getObjectId();
                        if (objectId == 0L) {
                            return "null";
                        }
                        return "id=" + objectId;
                    }
                    break block22;
                }
                if (!(value instanceof ValueRaw)) break block27;
                byte[] v = ((ValueRaw)value).getValue();
                ByteOrder targetByteOrder = unit.getTargetInformation().getEndianness().toByteOrder();
                ByteBuffer b = ByteBuffer.wrap(v).order(targetByteOrder);
                switch (v.length) {
                    case 1: {
                        if (index == 0) {
                            return Strings.f("%02Xh", b.get());
                        }
                        break block22;
                    }
                    case 2: {
                        if (index == 0) {
                            return Strings.f("%04Xh", b.getShort());
                        }
                        break block22;
                    }
                    case 4: {
                        if (index == 0) {
                            return Strings.f("%08Xh", b.getInt());
                        }
                        if (index == 1) {
                            return DbgTypedValueUtil.getMemory(unit, (long)b.getInt() & 0xFFFFFFFFL, 4);
                        }
                        break block22;
                    }
                    case 8: {
                        if (index == 0) {
                            return Strings.f("%016Xh", b.getLong());
                        }
                        if (index == 1) {
                            return DbgTypedValueUtil.getMemory(unit, b.getLong(), 8);
                        }
                        break block22;
                    }
                    default: {
                        if (index == 0) {
                            return Strings.f("b'%s", Formatter.byteArrayToHexString(v));
                        }
                        break block22;
                    }
                }
            }
            return value.toString();
        }
        return null;
    }

    private static String getMemory(IDebuggerUnit unit, long address, int size) {
        byte[] mem = DebuggerUtil.readMemoryStringSafe(unit, address, size);
        if (mem == null) {
            return null;
        }
        int asciiLength = Strings.getAsciiLength(mem);
        if (asciiLength < size) {
            if (mem.length >= size) {
                return Formatter.byteArrayToHexString(mem, 0, size) + "h";
            }
            return "b'" + Formatter.byteArrayToHexString(mem);
        }
        return new String(mem, 0, asciiLength, Charset.defaultCharset());
    }

    public static ITypedValue buildValue(ITypedValue value, String newValue, IDebuggerUnit unit) {
        if (newValue == null) {
            return null;
        }
        String type = value.getTypeName();
        if (type == null) {
            return null;
        }
        if ((newValue = newValue.trim()).isEmpty()) {
            if (type.equals("string") || type.equals("char")) {
                return AbstractValuePrimitive.parseValue(type, newValue);
            }
            return null;
        }
        try {
            if (value instanceof ValueRaw) {
                byte[] newValueAsBytes;
                byte[] v = ((ValueRaw)value).getValue();
                if (newValue.startsWith("b'")) {
                    newValue = newValue.substring(2);
                }
                if ((newValueAsBytes = Formatter.hexStringToByteArray(newValue)) == null || newValueAsBytes.length > v.length) {
                    return null;
                }
                if (newValueAsBytes.length < v.length) {
                    byte[] newValuePad = new byte[v.length];
                    for (int i = 0; i < v.length - newValueAsBytes.length; ++i) {
                        newValuePad[i] = 0;
                    }
                    System.arraycopy(newValueAsBytes, 0, newValuePad, v.length - newValueAsBytes.length, newValueAsBytes.length);
                    newValueAsBytes = newValuePad;
                }
                switch (v.length) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 8: {
                        ByteOrder targetByteOrder = unit.getTargetInformation().getEndianness().toByteOrder();
                        if (targetByteOrder != ByteOrder.LITTLE_ENDIAN) break;
                        EndianUtil.swap(newValueAsBytes);
                    }
                }
                return new ValueRaw(newValueAsBytes);
            }
            return AbstractValuePrimitive.parseValue(type, newValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean equals(ITypedValue value, String newValue, IDebuggerUnit unit) {
        for (int i = 0; i < 2; ++i) {
            String formatted = DbgTypedValueUtil.formatValue(value, i, unit);
            if (formatted == null || !formatted.equals(newValue)) continue;
            return true;
        }
        return false;
    }
}

