/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.util;

import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class DataFrame {
    private List<String> labels;
    private List<Row> rows;
    private int numbersRenderingBase;

    public DataFrame(List<String> labels) {
        this.labels = labels;
        this.rows = new ArrayList<Row>();
    }

    public DataFrame(String ... labels) {
        this(Arrays.asList(labels));
    }

    public void setRenderedBaseForNumberObjects(int base) {
        this.numbersRenderingBase = base;
    }

    public int getRenderedBaseForNumberObjects() {
        return this.numbersRenderingBase;
    }

    public int size() {
        return this.rows.size();
    }

    public void clear() {
        this.rows.clear();
    }

    public void addRow(Row row) {
        row.index = this.rows.size();
        this.rows.add(row);
    }

    public void addRow(List<Object> elements) {
        this.rows.add(new Row(this.rows.size(), elements, null, null));
    }

    public void addRow(Object ... elements) {
        this.addRow(Arrays.asList(elements));
    }

    public List<String> getColumnLabels() {
        return this.labels;
    }

    public Row getRow(int index) {
        return this.rows.get(index);
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public String getLabelFor(Row row, int index) {
        Object o = row.get(index);
        if (o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte) {
            long v = 0L;
            if (o instanceof Long) {
                v = (Long)o;
            } else if (o instanceof Integer) {
                v = ((Integer)o).longValue() & 0xFFFFFFFFL;
            } else if (o instanceof Short) {
                v = ((Short)o).longValue() & 0xFFFFL;
            } else if (o instanceof Byte) {
                v = ((Byte)o).longValue() & 0xFFL;
            }
            switch (this.numbersRenderingBase) {
                case 16: {
                    return Strings.ff("%X", v);
                }
                case 8: {
                    return Strings.ff("%o", v);
                }
            }
            return Strings.ff("%d", v);
        }
        return null;
    }

    public static final class Row {
        public int index = -1;
        public List<Object> elements;
        public Image img;
        public Object data;

        private Row() {
            this.elements = new ArrayList<Object>();
        }

        Row(int index, List<Object> elements, Image img, Object data) {
            this.index = index;
            this.elements = elements;
            this.img = img;
            this.data = data;
        }

        public Row(List<Object> elements) {
            this(-1, elements, null, null);
        }

        public Row(List<Object> elements, Image img, Object data) {
            this(-1, elements, img, data);
        }

        public Object get(int index) {
            if (index < 0 || index >= this.elements.size()) {
                return null;
            }
            return this.elements.get(index);
        }

        public Image getImage() {
            return this.img;
        }

        public Object getData() {
            return this.data;
        }

        public String toString() {
            return Strings.join(",", this.elements);
        }

        public int size() {
            return this.elements.size();
        }
    }

    public static final class RowBuilder {
        Row row = new Row();

        private RowBuilder() {
        }

        public static RowBuilder create() {
            return new RowBuilder();
        }

        public RowBuilder setData(Object data) {
            this.row.data = data;
            return this;
        }

        public RowBuilder setImage(Image img) {
            this.row.img = img;
            return this;
        }

        public RowBuilder addElement(Object elt) {
            this.row.elements.add(elt);
            return this;
        }

        public Row build() {
            return this.row;
        }
    }
}

