/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.L;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.P;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.ForceDirectedLayout;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.graph.Digraph;
import com.pnfsoftware.jeb.util.graph.IAddressableDigraphBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class CallgraphPreparer
implements Runnable {
    private IAddressableDigraphBuilder callgraphBuilder;
    Digraph model;
    List<P> points;
    List<L> lines;

    CallgraphPreparer(IAddressableDigraphBuilder callgraphBuilder) {
        this.callgraphBuilder = callgraphBuilder;
    }

    @Override
    public void run() {
        this.model = this.callgraphBuilder.buildModel();
        this.determineVerticesWeights(this.model);
        P[] initial_vertex_points = this.layoutVerticesBasedOnCentrality(this.model, 1.0, 1.0);
        ForceDirectedLayout l = new ForceDirectedLayout(this.model, 100, 1.0, 1.0, initial_vertex_points);
        l.layout();
        this.points = Arrays.asList(l.getPoints());
        this.lines = this.generateLinesForEdges(this.model);
    }

    private List<L> generateLinesForEdges(Digraph g) {
        ArrayList<L> lines = new ArrayList<L>();
        for (Digraph.E e : g.getEdges()) {
            lines.add(new L(e.getSrc().getId(), e.getDst().getId()));
        }
        return lines;
    }

    private void determineVerticesWeights(Digraph g) {
        double minweight = Double.MAX_VALUE;
        double maxweight = -1.7976931348623157E308;
        for (Digraph.V v : g.getVertices()) {
            if (v.getWeight() == null) continue;
            if (v.getWeight() < minweight) {
                minweight = v.getWeight();
            }
            if (!(v.getWeight() > maxweight)) continue;
            maxweight = v.getWeight();
        }
        for (Digraph.V v : g.getVertices()) {
            if (v.getWeight() != null) {
                v.setWeight((v.getWeight() - minweight) / (maxweight - minweight));
                continue;
            }
            v.setWeight(0.0);
        }
        if (g.getEdgeCount() <= 5000) {
            this.model.computeEdgeBetweenness();
            double max_vcscore = -1.7976931348623157E308;
            for (Digraph.V v : g.getVertices()) {
                if (!(v.getVertexCentralityScore() > max_vcscore)) continue;
                max_vcscore = v.getVertexCentralityScore();
            }
            for (Digraph.V v : g.getVertices()) {
                v.normalizeVertexCentralityScore(max_vcscore);
            }
            for (Digraph.V v : g.getVertices()) {
                v.setWeight(0.3 * v.getWeight() + 0.7 * v.getVertexCentralityScore());
            }
        } else {
            this.model.resetEdgeBetweennessScores();
        }
    }

    private P[] layoutVerticesBasedOnCentrality(Digraph g, double w, double h) {
        int cnt = g.getVertexCount();
        P[] initial_points = new P[cnt];
        List<Integer> indices = g.getVertexIndexesByDescendingCentrality();
        Assert.a(indices.size() == cnt);
        double d = Math.sqrt(w * h / (double)cnt);
        double x0 = w / 2.0;
        double y0 = h / 2.0;
        int dir = 0;
        int dir_change_count = 0;
        int requested_inline = 1;
        int inline = 0;
        for (int i = 0; i < cnt; ++i) {
            int vertex_index = indices.get(i);
            initial_points[vertex_index] = new P(g.getVertexByIndex(vertex_index).getId(), x0, y0);
            switch (dir) {
                case 0: {
                    x0 += d;
                    break;
                }
                case 1: {
                    y0 += d;
                    break;
                }
                case 2: {
                    x0 -= d;
                    break;
                }
                default: {
                    y0 -= d;
                }
            }
            if (++inline != requested_inline) continue;
            dir = (dir + 1) % 4;
            if (++dir_change_count % 2 == 0) {
                ++requested_inline;
            }
            inline = 0;
        }
        return initial_points;
    }
}

