/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphMode;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphPlaceholder;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.GraphVertexAdapter;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.L;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.P;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.R;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.XYGraph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.ILabelProvider;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.AddressNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.ILocationListener;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.CallgraphPreparer;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.graph.Digraph;
import com.pnfsoftware.jeb.util.graph.IAddressableDigraphBuilder;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolTip;

public abstract class AbstractGlobalGraphFragment<T extends IUnit>
extends AbstractUnitFragment<T> {
    private static final ILogger logger = GlobalLog.getLogger(AbstractGlobalGraphFragment.class);
    protected GraphPlaceholder<CallgraphComposite> gp;
    private boolean propShowTooltips;
    private boolean propLockView;
    private Thread threadAutoLocate;
    private TextFragment textView;
    private ILocationListener textLocationListener;
    private GraphVertexAdapter graphListener;
    protected IAddressableDigraphBuilder callgraphBuilder;
    private Digraph model;
    private List<P> points;
    private List<L> lines;
    private volatile String disasAddress;
    private volatile long disasAddressUpdateTs;

    public AbstractGlobalGraphFragment(Composite parent, int style, T unit, IRcpUnitView unitView, IRcpClientContext context) {
        super(parent, style, unit, unitView, context);
        this.setLayout((Layout)new FillLayout());
        this.setBackground(UIAssetManager.getInstance().getColor(0xFFFFFF));
        this.newGraphWithControls();
    }

    public void dispose() {
        if (this.textLocationListener != null) {
            this.textView.removeLocationListener(this.textLocationListener);
            this.textLocationListener = null;
        }
        if (this.threadAutoLocate != null) {
            this.threadAutoLocate.interrupt();
            this.threadAutoLocate = null;
        }
        super.dispose();
    }

    protected final void newGraphWithControls() {
        this.gp = new GraphPlaceholder<CallgraphComposite>((Composite)this, 0, true, true){

            @Override
            protected CallgraphComposite createGraph(GraphPlaceholder<CallgraphComposite> gp, CallgraphComposite previousGraph) {
                return new CallgraphComposite(gp);
            }
        };
        String helpmsg = "Callgraph view.\n\nThis view displays invocation relationships between routines of the code unit.\n\nStandard graph keyboard shortcuts can be used to zoom in/out/reset/center the graph.\nAt a given zoom level, relevant nodes, based on their weights, will be displayed.\nDouble-click a node to navigate to the corresponding routine in the matching disassembly view.\nIn a code view, use the " + UI.MOD1 + "+G shortcut to sync up the graph to your current location.\n";
        this.gp.addHelpButtonToToolbar(helpmsg);
        this.gp.addModesBoxToToolbar();
        this.propLockView = this.context.getPropertyManager().getBoolean(".ui.graphs.LockView", false);
        Button btnLockView = this.gp.addCheckbox("Lock", this.propLockView);
        btnLockView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractGlobalGraphFragment.this.propLockView = ((Button)e.widget).getSelection();
                AbstractGlobalGraphFragment.this.context.getPropertyManager().setBoolean(".ui.graphs.LockView", AbstractGlobalGraphFragment.this.propLockView);
            }
        });
        btnLockView.setToolTipText("Lock the graph view, that is, do not attempt to sync the graph with the current position in the disassembly listing. Synchronization can be done manually using the " + UI.MOD1 + "+G keyboard shortcut.");
        boolean propKeepDocked = this.context.getPropertyManager().getBoolean(".ui.graphs.KeepInMainDock", false);
        Button btnKeepDocked = this.gp.addCheckbox("Keep Docked", propKeepDocked);
        btnKeepDocked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractGlobalGraphFragment.this.context.getPropertyManager().setBoolean(".ui.graphs.KeepInMainDock", ((Button)e.widget).getSelection());
            }
        });
        btnKeepDocked.setToolTipText("Keep the global graphs in the main dock instead of a separate window. Will take effect when processing the next file.");
        new ContextMenu((Control)this.gp.getGraph()).addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                if (AbstractGlobalGraphFragment.this.getContext() == null) {
                    return;
                }
                AllHandlers.getInstance().fillManager(menuMgr, 8);
            }
        });
    }

    public GraphPlaceholder<CallgraphComposite> getGraphWithControls() {
        return this.gp;
    }

    public CallgraphComposite getGraph() {
        return this.gp.getGraph();
    }

    @Override
    public boolean setFocus() {
        return this.gp.setFocus();
    }

    protected abstract boolean preFirstBuild();

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        P sel = this.gp.getGraph().getSelectedPoint();
        if (sel == null) {
            return null;
        }
        return this.callgraphBuilder.getAddressForVertexId(sel.getId());
    }

    @Override
    public boolean isValidActiveAddress(String address, Object object) {
        if (!this.isPrepared()) {
            return false;
        }
        return this.callgraphBuilder.getVertexIdForAddress(address) != null;
    }

    @Override
    public boolean setActiveAddress(String address, Object extraAddressDetails, boolean recordPosition, boolean allowComplexNavigation) {
        if (!this.isPrepared()) {
            return false;
        }
        try {
            this.disasAddress = null;
            Integer vertexId = this.callgraphBuilder.getVertexIdForAddress(address);
            if (vertexId == null) {
                return false;
            }
            CallgraphComposite g = this.getGraph();
            if (!g.centerGraph(vertexId, 0, true)) {
                logger.catchingSilent(new RuntimeException("Can not set address " + address + " (" + extraAddressDetails + ") in graph"));
                return false;
            }
            if (!g.isVertexVisible(vertexId)) {
                for (int i = 0; i < 20; ++i) {
                    g.zoomGraph(1);
                    if (g.isVertexVisible(vertexId)) break;
                }
            }
            g.setSelection(vertexId);
            g.refreshGraph();
            return true;
        }
        catch (Exception e) {
            logger.error("Cannot set active address in callgraph: %s", address);
            this.context.getErrorHandler().processThrowable(e, false, false, false, "Requested address: " + address, null, this.unit);
            return false;
        }
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        if (!this.isPrepared()) {
            return false;
        }
        switch (req.getOperation()) {
            case REFRESH: {
                return true;
            }
            case CENTER: {
                return false;
            }
            case ZOOM_IN: 
            case ZOOM_OUT: 
            case ZOOM_RESET: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        if (!this.isPrepared()) {
            return false;
        }
        switch (req.getOperation()) {
            case REFRESH: {
                this.gp.getGraph().reset();
                this.resetModel();
                this.prepare();
                return true;
            }
            case CENTER: {
                return false;
            }
            case ZOOM_IN: {
                this.getGraph().zoomGraph(1);
                return true;
            }
            case ZOOM_OUT: {
                this.getGraph().zoomGraph(-1);
                return true;
            }
            case ZOOM_RESET: {
                this.getGraph().fitGraph();
                return true;
            }
        }
        return false;
    }

    private void resetModel() {
        this.model = null;
        if (this.graphListener != null) {
            this.gp.getGraph().removeGraphVertexListener(this.graphListener);
        }
    }

    public boolean isPrepared() {
        return this.model != null;
    }

    public void prepare() {
        this.context.getTelemetry().record("actionCallgraphGeneration");
        if (!this.preFirstBuild()) {
            return;
        }
        CallgraphPreparer graphPreparer = new CallgraphPreparer(this.callgraphBuilder);
        this.context.executeTaskWithPopupDelay(2000, "Generating callgraph", false, graphPreparer);
        this.model = graphPreparer.model;
        this.points = graphPreparer.points;
        this.lines = graphPreparer.lines;
        if (this.model == null || this.points == null || this.lines == null) {
            return;
        }
        if (this.textLocationListener == null) {
            for (UnitPartManager pman : this.context.getPartManager().getPartManagersForUnit(this.unit)) {
                TextFragment view = pman.getFragmentByType(TextFragment.class);
                if (view == null) continue;
                this.textView = view;
                break;
            }
            if (this.textView != null) {
                this.textLocationListener = new ILocationListener(){

                    @Override
                    public void locationChanged(String address) {
                        if (!AbstractGlobalGraphFragment.this.propLockView && AbstractGlobalGraphFragment.this.isPrepared()) {
                            AbstractGlobalGraphFragment.this.disasAddress = address;
                            AbstractGlobalGraphFragment.this.disasAddressUpdateTs = System.currentTimeMillis();
                        }
                    }
                };
                this.textView.addLocationListener(this.textLocationListener);
                this.threadAutoLocate = ThreadUtil.start(new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                            if (AbstractGlobalGraphFragment.this.disasAddress == null || AbstractGlobalGraphFragment.this.disasAddressUpdateTs == 0L) continue;
                            (new Object[1])[0] = AbstractGlobalGraphFragment.this.disasAddress;
                            if (AbstractGlobalGraphFragment.this.disasAddress == null || System.currentTimeMillis() - AbstractGlobalGraphFragment.this.disasAddressUpdateTs <= 1000L) continue;
                            try {
                                AbstractGlobalGraphFragment.this.getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (AbstractGlobalGraphFragment.this.disasAddress != null) {
                                            AbstractGlobalGraphFragment.this.setActiveAddress(AbstractGlobalGraphFragment.this.disasAddress);
                                            AbstractGlobalGraphFragment.this.disasAddress = null;
                                        }
                                    }
                                });
                                continue;
                            }
                            catch (SWTException sWTException) {}
                            break;
                        }
                    }
                });
            }
        }
        CallgraphComposite gg = this.gp.getGraph();
        this.graphListener = new GraphVertexAdapter(){

            @Override
            public void onVertexClicked(XYGraph gg, P p) {
                logger.info("Node: %s", AbstractGlobalGraphFragment.this.model.getVertex(p.getId()).getLabel());
            }

            @Override
            public void onVertexDoubleClicked(XYGraph graph, P p) {
                String address = AbstractGlobalGraphFragment.this.getActiveAddress();
                if (address != null) {
                    new AddressNavigator(AbstractGlobalGraphFragment.this.context, AbstractGlobalGraphFragment.this.unit, AbstractGlobalGraphFragment.this).navigate(address);
                }
            }

            @Override
            public void onVertexHoverIn(XYGraph graph, P p) {
                if (!AbstractGlobalGraphFragment.this.propShowTooltips) {
                    return;
                }
                String s = graph.generateLabelForVertex(p);
                if (Strings.isBlank(s)) {
                    return;
                }
                ToolTip tip = new ToolTip(graph.getShell(), 0);
                Point pt = AbstractGlobalGraphFragment.this.getDisplay().map((Control)graph, null, graph.convertCoord(p));
                tip.setLocation(pt.x + 20, pt.y + 20);
                tip.setMessage(s);
                tip.setAutoHide(true);
                tip.setVisible(true);
            }
        };
        gg.addGraphVertexListener(this.graphListener);
        gg.setLabelProvider(new ILabelProvider(){

            @Override
            public String getLabel(int vertexId) {
                return AbstractGlobalGraphFragment.this.model.getVertex(vertexId).getLabel();
            }
        });
        gg.setParameters(this.points, this.lines, true);
        gg.refreshGraph();
    }

    private List<P> selectPointsInBounds(Collection<P> points, R bounds) {
        ArrayList<P> r = new ArrayList<P>();
        for (P p : points) {
            if (!bounds.contains(p)) continue;
            r.add(p);
        }
        return r;
    }

    private class CallgraphComposite
    extends XYGraph {
        final int MODE_DEFAUT = 0;
        final int MODE_ALL = 1;
        final int MAX_NODE_DENSITY = 30000;

        CallgraphComposite(Composite parent) {
            super(parent);
            this.MODE_DEFAUT = 0;
            this.MODE_ALL = 1;
            this.MAX_NODE_DENSITY = 30000;
            this.addSupportedMode(new GraphMode(0, "Display relevant nodes", null));
            this.addSupportedMode(new GraphMode(1, "Display all nodes", null));
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (CallgraphComposite.this.getVertexCount() == 0) {
                        AbstractGlobalGraphFragment.this.prepare();
                    }
                }
            });
        }

        @Override
        protected void preDrawing(GC gc) {
            if (this.getVertexCount() == 0) {
                Rectangle r = this.getClientArea();
                String text = "Click here to generate the callgraph";
                Point s = gc.stringExtent(text);
                gc.drawText(text, (r.width - s.x) / 2, r.height / 2);
            }
        }

        @Override
        protected void postDrawing(GC gc) {
            if (this.isDragging()) {
                return;
            }
            P p = this.getHoveredPoint();
            if (p != null) {
                String text = this.generateLabelForVertex(p);
                Point dim = gc.stringExtent(text);
                gc.setForeground(this.getDisplay().getSystemColor(2));
                gc.drawString(text, 2, this.getClientArea().height - dim.y, true);
            }
        }

        @Override
        protected Collection<P> determineVisibleVertices(Collection<P> points) {
            this.setActiveNodeAnimationEnabled(true);
            if (this.getModeId() == 1) {
                return points;
            }
            int surface = this.getClientArea().width * this.getClientArea().height;
            int maxNodes = surface / 30000;
            List<P> r = AbstractGlobalGraphFragment.this.selectPointsInBounds(points, this.getGraphBounds());
            r.sort((a, b) -> -Double.compare(AbstractGlobalGraphFragment.this.model.getVertex(a.getId()).getWeight(), AbstractGlobalGraphFragment.this.model.getVertex(b.getId()).getWeight()));
            if (r.size() >= maxNodes) {
                r = r.subList(0, maxNodes);
            }
            return r;
        }

        @Override
        protected Collection<L> determineVisibleEdges(Collection<P> visiblePoints, Collection<L> edges) {
            if (this.getModeId() == 1) {
                return edges;
            }
            HashSet<Integer> visibleVertexIds = new HashSet<Integer>();
            for (P p : visiblePoints) {
                visibleVertexIds.add(p.getId());
            }
            ArrayList<L> r = new ArrayList<L>();
            for (L edge : edges) {
                int srcId = edge.getSrcId();
                int dstId = edge.getDstId();
                if (!visibleVertexIds.contains(srcId) && !visibleVertexIds.contains(dstId)) continue;
                r.add(edge);
            }
            return r;
        }

        @Override
        protected void drawVertex(GC gc, P p, Point pt) {
            double w = AbstractGlobalGraphFragment.this.model.getVertex(p.getId()).getWeight();
            int r = Math.min(192, (int)((1.0 - w) * 255.0));
            gc.setBackground(UIAssetManager.getInstance().getColor(255, r, r));
            int pr = (int)(28.0 * w) + 10;
            if (p == this.getHoveredPoint() || p == this.getSelectedPoint() || this.getActivePointsStatus() && this.isActivePoint(p)) {
                gc.setBackground(UIAssetManager.getInstance().getColor(0));
            }
            gc.fillOval(pt.x - pr / 2, pt.y - pr / 2, pr, pr);
        }

        @Override
        protected void drawVertexLabel(GC gc, P p, Point pt) {
            super.drawVertexLabel(gc, p, pt);
        }

        @Override
        protected void drawEdge(GC gc, L l, Point a, Point b) {
            int id;
            boolean highlight = false;
            P pt = this.getHoveredPoint();
            if (pt != null) {
                id = pt.getId();
                boolean bl = highlight = id == l.getSrcId() || id == l.getDstId();
            }
            if (!highlight && (pt = this.getSelectedPoint()) != null) {
                id = pt.getId();
                boolean bl = highlight = id == l.getSrcId() || id == l.getDstId();
            }
            if (highlight) {
                gc.setForeground(this.getDisplay().getSystemColor(2));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(15));
            }
            super.drawEdge(gc, l, a, b);
        }
    }
}

