/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.graphs;

import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.IBasicBlock;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.Graph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphEdgeSquare;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphEdgeSquareManager;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphNode;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphNodeListener;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphNodeListenerAdapter;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.IGraphNodeContents;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.CFGLayoutManager;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.Cell;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.ICFGLayout;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.Spreadsheet;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.AbstractLocalGraphFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.NodeContentsTextFragment;
import com.pnfsoftware.jeb.rcpclient.util.ColorsGradient;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractControlFlowGraphFragment<T extends IUnit>
extends AbstractLocalGraphFragment<T> {
    private static final ILogger logger = GlobalLog.getLogger(AbstractControlFlowGraphFragment.class);
    protected static Color cGreen = UIAssetManager.getInstance().getColor(ColorsGradient.get("green"));
    protected static Color cRed = UIAssetManager.getInstance().getColor(ColorsGradient.get("red 3"));
    protected static Color cOrange = UIAssetManager.getInstance().getColor(ColorsGradient.get("darkorange"));
    private Map<BasicBlock<IInstruction>, GraphNode> blockToNodes;
    private GraphNodeListener graphNodeListener;
    private GraphNode nodeFocusGained;
    private GraphNode nodeFocusLost;

    public AbstractControlFlowGraphFragment(Composite parent, int style, T unit, IRcpUnitView unitView, IRcpClientContext context) {
        super(parent, style, unit, unitView, context);
    }

    protected GraphNode findNodeByInstructionAddress(long address) {
        for (GraphNode node : this.getGraph().getNodes()) {
            BasicBlock b = (BasicBlock)node.getData("bb");
            if (address < b.getFirstAddress() || address >= b.getEndAddress()) continue;
            return node;
        }
        return null;
    }

    protected abstract ITextDocument getTextForBlock(BasicBlock<IInstruction> var1);

    protected final void generateGraphForCFG(CFG<IInstruction> cfg) {
        this.newContentsFactory();
        ICFGLayout<IInstruction> layout = CFGLayoutManager.createDefault();
        Spreadsheet<BasicBlock<IInstruction>> grid0 = layout.build(cfg);
        final Graph g = this.getGraph();
        Spreadsheet<GraphNode> grid1 = new Spreadsheet<GraphNode>();
        this.blockToNodes = new IdentityHashMap<BasicBlock<IInstruction>, GraphNode>();
        for (Cell<BasicBlock<IInstruction>> cell : grid0.getRealCells()) {
            BasicBlock<IInstruction> basicBlock = cell.getObject();
            GraphNode node = new GraphNode(this.getGraph(), 17);
            node.setNodeName(Strings.ff("BB@0x%X", basicBlock.getBase()));
            node.setData("bb", basicBlock);
            this.blockToNodes.put(basicBlock, node);
            ITextDocument fragment = this.getTextForBlock(basicBlock);
            this.contentsFactory.create(node, fragment);
            node.acknowledgeContents(false);
            grid1.writeCell(cell.getRow(), cell.getColumn(), cell.getHorizontalSpan(), cell.getVerticalSpan(), node);
        }
        g.registerNodesGrid(grid1);
        ThemeManager.getInstance().processControlForcibly((Widget)this.getGraph());
        GraphEdgeSquareManager edgeman = new GraphEdgeSquareManager(g);
        g.setEdgeManager(edgeman);
        for (BasicBlock<IInstruction> basicBlock : cfg) {
            GraphEdgeSquare edge;
            GraphNode n2;
            GraphNode n1 = this.blockToNodes.get(basicBlock);
            List<BasicBlock<IInstruction>> dstlist = basicBlock.getOutputBlocks();
            int iedge = 0;
            for (BasicBlock<IInstruction> dst : dstlist) {
                n2 = this.blockToNodes.get(dst);
                edge = edgeman.create(n1, n2);
                if (dstlist.size() >= 2) {
                    edge.setColor(0, iedge == 0 ? cRed : cGreen);
                }
                ++iedge;
            }
            for (BasicBlock<IInstruction> dst : basicBlock.getIrregularOutputBlocks()) {
                n2 = this.blockToNodes.get(dst);
                edge = edgeman.create(n1, n2);
                edge.setColor(0, cOrange);
                edge.setStyle(2);
            }
        }
        this.graphNodeListener = new GraphNodeListenerAdapter(){

            @Override
            public void onNodeFocusGained(GraphNode node) {
                if (g.isDisposed()) {
                    return;
                }
                AbstractControlFlowGraphFragment.this.nodeFocusGained = node;
                if (AbstractControlFlowGraphFragment.this.nodeFocusLost != null && AbstractControlFlowGraphFragment.this.nodeFocusGained != AbstractControlFlowGraphFragment.this.nodeFocusLost) {
                    NodeContentsTextFragment contents = (NodeContentsTextFragment)AbstractControlFlowGraphFragment.this.nodeFocusLost.getContents();
                    contents.getViewer().resetSelection();
                    AbstractControlFlowGraphFragment.this.nodeFocusLost = null;
                }
            }

            @Override
            public void onNodeFocusLost(GraphNode node) {
                AbstractControlFlowGraphFragment.this.nodeFocusLost = node;
            }
        };
        g.addGraphNodeListener(this.graphNodeListener);
        g.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                g.removeGraphNodeListener(AbstractControlFlowGraphFragment.this.graphNodeListener);
                AbstractControlFlowGraphFragment.this.nodeFocusGained = null;
                AbstractControlFlowGraphFragment.this.nodeFocusLost = null;
            }
        });
        this.gp.layout();
        g.centerGraph(0);
    }

    @Override
    public void onNodeBreakoutAttempt(IGraphNodeContents nodeContents, int direction) {
        String address1;
        IBasicBlock b1;
        GraphNode node = this.contentsFactory.getNodeForContents((NodeContentsTextFragment)nodeContents);
        BasicBlock b = (BasicBlock)node.getData("bb");
        if (direction == 1 && b.outsize() >= 1) {
            b1 = b.getOutputBlock(0);
            address1 = this.buildAddress(((BasicBlock)b1).getFirstAddress());
        } else if (direction == -1 && b.insize() >= 1) {
            b1 = b.getInputBlock(0);
            address1 = this.buildAddress(((BasicBlock)b1).getLastAddress());
        } else {
            return;
        }
        GraphNode node1 = this.blockToNodes.get(b1);
        this.contentsFactory.getContentsForNode(node1).setFocus();
        this.contentsFactory.getContentsForNode(node1).setActiveAddress(address1);
        this.getGraph().showNode(node1, true);
    }

    protected String buildAddress(long offset) {
        return Strings.ff("%Xh", offset);
    }
}

