/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.generic;

import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.SwitchableTextFragment;
import com.pnfsoftware.jeb.rcpclient.util.Extensions;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CsvFragment
extends AbstractFilteredTableFragment<IBinaryUnit, List<Object>> {
    private static final char DEFAULT_SEPARATOR_CSV = ',';
    private static final char DEFAULT_SEPARATOR_TSV = '\t';
    private static final char QUOTE = '\"';
    private final String text;
    private final Composite tableContainer;
    private String separator = "";
    private int maxColumns = 0;
    private FilteredTableViewer viewer;

    public CsvFragment(Composite parent, int style, IRcpClientContext context, IBinaryUnit unit) {
        super(parent, style, unit, null, context, new ContentProvider(), new LabelProvider());
        this.setLayout((Layout)new GridLayout(1, false));
        this.text = this.readFile();
        this.separator = "" + ("tsv".equals(Extensions.getExtension(unit.getName())) ? (char)'\t' : ',');
        this.parseCsv();
        ToolBar iconContainer = UIUtil.createHorizontalSwtToolBar(0, this);
        iconContainer.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        RowLayout layout = UIUtil.createRowLayout(false, true);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        iconContainer.setLayout((Layout)layout);
        this.tableContainer = new Composite((Composite)this, 0);
        this.tableContainer.setLayoutData((Object)UIUtil.createGridDataFill(true, true));
        this.tableContainer.setLayout((Layout)new FillLayout());
        ToolItem sep = UIUtil.addToolItemPush(iconContainer, "eclipse/cu_obj.gif", e -> {
            String newSeparator = UI.ask(this.getShell(), "Change Separator", "Use this separator:", this.separator);
            if (newSeparator == null) {
                return;
            }
            this.separator = newSeparator;
            this.parseCsv();
            this.fullRebuildTable();
        });
        sep.setToolTipText("Change Separator");
        UIUtil.createSeparator(this, true);
        ToolItem head = UIUtil.addToolItemCheck(iconContainer, "eclipse/datasheet.gif", e -> {
            this.getProvider().displayHeader = !this.getProvider().displayHeader;
            this.fullRebuildTable();
        });
        head.setToolTipText("First line as header");
        this.fullBuildTable();
    }

    private void fullRebuildTable() {
        this.viewer.getControl().dispose();
        this.fullBuildTable();
        this.tableContainer.layout();
    }

    private void fullBuildTable() {
        String[] columns = new String[this.maxColumns];
        Arrays.setAll(columns, i -> {
            if (!this.getProvider().displayHeader || this.getProvider().rows.isEmpty()) {
                return "";
            }
            List<Object> firstLine = this.getProvider().rows.get(0);
            if (i < firstLine.size()) {
                return firstLine.get(i);
            }
            return "";
        });
        this.viewer = this.buildFilteredViewer(this.tableContainer, columns, 0, false);
        ((Table)this.viewer.getControl().getMainElement()).setHeaderVisible(this.getProvider().displayHeader);
    }

    private void parseCsv() {
        if (this.text == null) {
            return;
        }
        List<List<Object>> rows = this.getProvider().rows;
        rows.clear();
        this.maxColumns = 1;
        boolean openQuote = false;
        int startIndex = 0;
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < this.text.length(); ++i) {
            if (!openQuote) {
                boolean crlf;
                if (this.separator.length() == 1 && this.text.charAt(i) == this.separator.charAt(0) || this.separator.length() != 1 && this.text.startsWith(this.separator, i)) {
                    row.add(this.format(this.text.substring(startIndex, i)));
                    startIndex = i + 1;
                    continue;
                }
                boolean bl = crlf = this.text.charAt(i) == '\r' && i + 1 < this.text.length() && this.text.charAt(i + 1) == '\n';
                if (crlf || this.text.charAt(i) == '\n' || i == this.text.length() - 1) {
                    row.add(this.format(this.text.substring(startIndex, i)));
                    startIndex = i + (crlf ? 2 : 1);
                    this.maxColumns = Math.max(this.maxColumns, row.size());
                    rows.add(row);
                    row = new ArrayList();
                    if (!crlf) continue;
                    ++i;
                    continue;
                }
            }
            if (i == startIndex && this.text.charAt(i) == '\"') {
                openQuote = true;
                continue;
            }
            if (!openQuote || this.text.charAt(i) != '\"') continue;
            if (i + 1 == this.text.length()) {
                row.add(this.format(this.text.substring(startIndex, i + 1)));
                this.maxColumns = Math.max(this.maxColumns, row.size());
                rows.add(row);
                break;
            }
            if (this.text.charAt(i + 1) != '\"') {
                openQuote = false;
                continue;
            }
            ++i;
        }
    }

    private String format(String str) {
        if (((String)str).length() > 1 && ((String)str).charAt(0) == '\"' && ((String)str).charAt(((String)str).length() - 1) == '\"') {
            str = ((String)str).substring(1, ((String)str).length() - 1);
            for (int i = 0; i < ((String)str).length(); ++i) {
                if (((String)str).charAt(i) != '\"') continue;
                str = ((String)str).substring(0, i) + ((String)str).substring(i + 1, ((String)str).length());
            }
        }
        return str;
    }

    private String readFile() {
        String string;
        block9: {
            String encoding = SwitchableTextFragment.determineInitialEncoding(((IBinaryUnit)this.unit).getInput());
            InputStream is = ((IBinaryUnit)this.unit).getInput().getStream();
            try {
                byte[] b = IO.readInputStream(is);
                string = new String(b, 0, b.length, encoding);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    @Override
    public ContentProvider getProvider() {
        return (ContentProvider)super.getProvider();
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return true;
    }

    @Override
    public List<Object> getSelectedRow() {
        Object row = this.getSelectedRawRow();
        return (List)row;
    }

    private static class ContentProvider
    implements IFilteredTableContentProvider {
        private List<List<Object>> rows = new ArrayList<List<Object>>();
        private boolean displayHeader = false;

        private ContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (!this.displayHeader) {
                return this.rows.toArray();
            }
            Object[] withoutFirst = new Object[this.rows.size() - 1];
            System.arraycopy(this.rows.toArray(), 1, withoutFirst, 0, withoutFirst.length);
            return withoutFirst;
        }
    }

    private static class LabelProvider
    extends DefaultCellLabelProvider {
        private LabelProvider() {
        }

        @Override
        public String getStringAt(Object element, int key) {
            List elt = (List)element;
            return key < elt.size() ? elt.get(key).toString() : "";
        }
    }
}

