/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.decompilers;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.code.android.DexDecompilerEvent;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.OperationCopy;
import com.pnfsoftware.jeb.rcpclient.parts.AddressNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.ILazyView;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DexDecompilerEventsFragment
extends AbstractFilteredTableFragment<IDexDecompilerUnit, DexDecompilerEvent<?>>
implements ILazyView {
    private static final ILogger logger = GlobalLog.getLogger(DexDecompilerEventsFragment.class);

    public DexDecompilerEventsFragment(Composite parent, int flags, IRcpClientContext context, IDexDecompilerUnit unit, IRcpUnitView unitView) {
        super(parent, flags, unit, unitView, context, new ContentProvider(unit), null);
        this.setLabelProvider(new LabelProvider());
        this.setLayout((Layout)new FillLayout());
    }

    @Override
    public void lazyInitialization() {
        Composite container = new Composite((Composite)this, 0);
        container.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{S.s(52), S.s(779), S.s(815)};
        FilteredTableViewer viewer = this.buildFilteredViewer(container, columnNames, 0, true);
        this.setRefreshListener(viewer, e -> {
            (new Object[1])[0] = e;
            return this.unit != null && e.getSource() == this.unit;
        });
        this.addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                menuMgr.add(new Separator());
                menuMgr.add(new OperationCopy(DexDecompilerEventsFragment.this));
                menuMgr.add(new Action("Jump to"){

                    @Override
                    public void run() {
                        String address = DexDecompilerEventsFragment.this.getActiveAddress();
                        if (address != null) {
                            DexDecompilerEventsFragment.this.navigateTo(address, ((IDexDecompilerUnit)DexDecompilerEventsFragment.this.unit).getCodeUnit());
                        }
                    }
                });
                menuMgr.add(new Separator());
                menuMgr.add(new Action("Reset all global events"){

                    @Override
                    public void run() {
                        ((IDexDecompilerUnit)DexDecompilerEventsFragment.this.unit).resetGlobalDecompilationEvents();
                        DexDecompilerEventsFragment.this.refresh();
                    }
                });
                menuMgr.add(new Action("Toggle show/hide duplicates"){

                    @Override
                    public void run() {
                        ContentProvider prv = (ContentProvider)DexDecompilerEventsFragment.this.getProvider();
                        prv.showDups = !prv.showDups;
                        DexDecompilerEventsFragment.this.refresh();
                    }
                });
                menuMgr.add(new Separator());
                menuMgr.add(new Action(S.s(33)){

                    @Override
                    public void run() {
                        DexDecompilerEventsFragment.this.refresh();
                    }
                });
            }
        });
        new AddressNavigator(this.context, this.unit, this).addDefaultListeners(this.getViewer());
        this.layout();
    }

    @Override
    public IItem getActiveItem() {
        return null;
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof DexDecompilerEvent;
    }

    @Override
    public DexDecompilerEvent<?> getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof DexDecompilerEvent)) {
            return null;
        }
        return (DexDecompilerEvent)row;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        Object e = this.getSelectedRow();
        if (e == null) {
            return null;
        }
        return ((DexDecompilerEvent)e).getAddress();
    }

    static class ContentProvider
    implements IFilteredTableContentProvider {
        private IDexDecompilerUnit unit;
        boolean showDups;

        public ContentProvider(IDexDecompilerUnit unit) {
            this.unit = unit;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            return this.unit.getGlobalDecompilationEvents(this.showDups).toArray();
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }
    }

    static class LabelProvider
    extends DefaultCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 3;
        }

        @Override
        public String getStringAt(Object element, int key) {
            DexDecompilerEvent e = (DexDecompilerEvent)element;
            switch (key) {
                case 0: {
                    return e.getAddress();
                }
                case 1: {
                    return e.getType().toString();
                }
                case 2: {
                    return e.format(false, false);
                }
            }
            return null;
        }
    }
}

