/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.exceptions.JebException;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.code.android.IDalvikDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerEventType;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerException;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerThreadStatus;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerEventData;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThreadStackFrame;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerVariable;
import com.pnfsoftware.jeb.core.units.code.debug.ITypedValue;
import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValueComposite;
import com.pnfsoftware.jeb.core.units.code.debug.impl.AbstractValueNumber;
import com.pnfsoftware.jeb.core.units.code.debug.impl.DebuggerUtil;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueDouble;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueFloat;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueObject;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueRaw;
import com.pnfsoftware.jeb.core.units.code.debug.impl.ValueString;
import com.pnfsoftware.jeb.rcpclient.AssetManagerOverlay;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.filter.AbstractFilteredFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractArrayGroupFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultStyledCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeViewerExtension;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.PatternTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.TreeStateMaintainer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.ArrayGroupProperties;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractNotAddressableUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.util.DbgTypedValueUtil;
import com.pnfsoftware.jeb.util.base.JavaUtil;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class DbgVariablesFragment
extends AbstractNotAddressableUnitFragment<IDebuggerUnit>
implements IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(DbgVariablesFragment.class);
    private FilteredTreeViewer viewer;
    private TreeStateMaintainer<Object> stateMaintainer;
    private IDebuggerThreadStackFrame targetFrame;
    private DbgVarLabelProvider labelProvider;
    private ToolItem wFreezeRefresh;
    private ToolItem wDebugVarsOnly;

    public DbgVariablesFragment(Composite parent, int flags, IRcpClientContext context, IDebuggerUnit unit) {
        super(parent, flags, unit, null, context);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        ToolBar toolBar = new ToolBar((Composite)this, 320);
        toolBar.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.wFreezeRefresh = new ToolItem(toolBar, 32);
        this.wFreezeRefresh.setText("Freeze Refresh");
        this.wFreezeRefresh.setSelection(false);
        Object info = "If checked, the list of variables is no longer provided.";
        this.wFreezeRefresh.setToolTipText((String)info);
        this.wFreezeRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DbgVariablesFragment.this.viewer.refresh();
            }
        });
        this.wDebugVarsOnly = new ToolItem(toolBar, 32);
        this.wDebugVarsOnly.setText("Debug Variables Only");
        this.wDebugVarsOnly.setSelection(true);
        info = "If checked, only variables with debug information are queried.";
        if (unit instanceof IDalvikDebuggerUnit) {
            info = (String)info + "\n(This option is recommended for faster refresh and stepping on recent Android systems, since variables without local debug information are not provided by a JDWP debugger anyway.)";
        }
        this.wDebugVarsOnly.setToolTipText((String)info);
        this.wDebugVarsOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DbgVariablesFragment.this.viewer.refresh();
            }
        });
        String[] titleColumns = new String[]{S.s(591), S.s(779), S.s(815), "Extra"};
        this.labelProvider = new DbgVarLabelProvider();
        boolean expandAfterFilter = context.getPropertyManager().getBoolean(".ui.ExpandTreeNodesOnFiltering");
        this.viewer = new PatternTreeViewer(this, 65536, titleColumns, null, expandAfterFilter);
        this.viewer.getFilteredTreeWidget().setLayoutData(UIUtil.createGridDataFill(true, true));
        this.viewer.getFilteredTreeWidget().setFilterVisibility(false, false);
        this.viewer.displayTreeAsTable();
        TreeColumn[] cols = this.viewer.getFilteredTreeWidget().getTree().getColumns();
        TreeViewerColumn tcv1 = new TreeViewerColumn(this.viewer.getViewer(), cols[1]);
        tcv1.setEditingSupport(new ValueEditingSupport(this.viewer.getViewer(), 2));
        TreeViewerColumn tcv2 = new TreeViewerColumn(this.viewer.getViewer(), cols[2]);
        tcv2.setEditingSupport(new ValueEditingSupport(this.viewer.getViewer(), 0));
        TreeViewerColumn tcv3 = new TreeViewerColumn(this.viewer.getViewer(), cols[3]);
        tcv3.setEditingSupport(new ValueEditingSupport(this.viewer.getViewer(), 1));
        this.viewer.setContentProvider(new DbgVarContentProvider());
        this.viewer.setLabelProvider(this.labelProvider);
        this.viewer.setCircularProtection(true);
        this.viewer.setMaxDepth(5);
        this.viewer.setExtension(new DbgVarTreeViewerExtension());
        this.stateMaintainer = new DbgVarTreeStateMaintainer(this.viewer.getViewer());
        this.viewer.setTreeStateMaintainer(new DbgVarTreeStateMaintainer(this.viewer.getViewer()));
        this.viewer.setInput(unit);
        this.viewer.expandToLevel(2);
        this.packColumns(true);
        this.viewer.addContextMenu(null, null, null, this);
    }

    public void packColumns(boolean force) {
        TreeColumn[] cols;
        for (TreeColumn col : cols = this.viewer.getFilteredTreeWidget().getTree().getColumns()) {
            if (!force && col.getWidth() != 0) continue;
            col.pack();
        }
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        Object elt = this.getSelectedNode();
        if (elt instanceof IDebuggerVariable) {
            final IDebuggerVariable v = (IDebuggerVariable)elt;
            menuMgr.add(new Action("View string representation"){

                @Override
                public void run() {
                    if (v.getTypedValue() instanceof ValueObject) {
                        try {
                            IDebuggerThread t = ((IDebuggerUnit)DbgVariablesFragment.this.getUnit()).getDefaultThread();
                            if (t != null) {
                                long threadId = t.getId();
                                ITypedValue result = ((ValueObject)v.getTypedValue()).invoke("toString", threadId, null);
                                if (result != null) {
                                    logger.info(result.toString(), new Object[0]);
                                }
                            } else {
                                logger.error("Can not call toString: no default thread", new Object[0]);
                            }
                        }
                        catch (JebException e) {
                            logger.catching(e);
                        }
                    }
                }

                @Override
                public boolean isEnabled() {
                    return v.getTypedValue() instanceof ValueObject && ((ValueObject)v.getTypedValue()).getObjectId() != 0L;
                }
            });
        }
        this.addOperationsToContextMenu(menuMgr);
    }

    public void setTargetFrame(IDebuggerThreadStackFrame frame) {
        this.targetFrame = frame;
        this.viewer.refresh(true);
    }

    public IDebuggerThreadStackFrame getTargetFrame() {
        List<? extends IDebuggerThreadStackFrame> frames;
        if (this.targetFrame != null) {
            return this.targetFrame;
        }
        IDebuggerThread t = ((IDebuggerUnit)this.getUnit()).getDefaultThread();
        if (t != null && t.getStatus() == DebuggerThreadStatus.PAUSED && (frames = t.getFrames()) != null && !frames.isEmpty()) {
            return frames.get(0);
        }
        return null;
    }

    private Object getSelectedNode() {
        ITreeSelection treesel = (ITreeSelection)this.viewer.getSelection();
        if (treesel.isEmpty()) {
            return null;
        }
        return treesel.getFirstElement();
    }

    private boolean copyValueToClipboard(ITypedValue value) {
        String s = this.formatValue(value);
        if (s != null) {
            UIUtil.copyTextToClipboard(s);
            return true;
        }
        return false;
    }

    private String formatValue(ITypedValue value) {
        String s = value instanceof AbstractValueComposite ? ((AbstractValueComposite)value).format() : value.toString();
        return s;
    }

    private String formatCell(ITypedValue value, int index) {
        if (index == 0 || index == 1) {
            return DbgTypedValueUtil.formatValue(value, index, (IDebuggerUnit)this.unit);
        }
        return "";
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        return null;
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case COPY: {
                return this.getSelectedNode() != null;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case COPY: {
                Object elt = this.getSelectedNode();
                if (elt instanceof IDebuggerVariable) {
                    return this.copyValueToClipboard(((IDebuggerVariable)elt).getTypedValue());
                }
                if (elt instanceof ITypedValue) {
                    return this.copyValueToClipboard((ITypedValue)elt);
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.viewer.exportToString());
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TREE;
    }

    class DbgVarLabelProvider
    extends DefaultStyledCellLabelProvider {
        DbgVarLabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 4;
        }

        @Override
        public void update(ViewerCell cell) {
            Object elt = cell.getElement();
            int index = cell.getColumnIndex();
            cell.setText(Strings.safe(this.getStringAt(elt, index)));
            if (index == 0) {
                int flags;
                Image img = null;
                if (elt instanceof IDebuggerVariable && (flags = ((IDebuggerVariable)elt).getFlags()) != 0) {
                    String visibilityFlag = (flags & 1) != 0 ? "eclipse/field_public_obj.png" : ((flags & 4) != 0 ? "eclipse/field_protected_obj.png" : ((flags & 2) != 0 ? "eclipse/field_private_obj.png" : "eclipse/field_default_obj.png"));
                    AssetManagerOverlay overlay = null;
                    if ((flags & 8) != 0) {
                        if (overlay == null) {
                            overlay = new AssetManagerOverlay();
                        }
                        overlay.addLayer("eclipse/static_co.png", new Point(0, 0));
                    }
                    if ((flags & 0x10) != 0) {
                        if (overlay == null) {
                            overlay = new AssetManagerOverlay();
                        }
                        overlay.addLayer("eclipse/final_co.png", new Point(9, 0));
                    }
                    img = UIAssetManager.getInstance().getImage(visibilityFlag, overlay);
                }
                if (img != null) {
                    cell.setImage(img);
                }
            } else if (index == 2 && elt instanceof IDebuggerVariable && ((IDebuggerVariable)elt).getTypedValue() instanceof ValueRaw) {
                cell.setFont(DbgVariablesFragment.this.context.getFontManager().getCodeFont());
            }
            super.update(cell);
        }

        @Override
        public String getStringAt(Object element, int index) {
            Object v;
            if (element instanceof IDebuggerVariable) {
                v = (IDebuggerVariable)element;
                if (index == 0) {
                    Object name = v.getName();
                    if (v.getAlternateName() != null) {
                        name = (String)name + " (" + v.getAlternateName() + ")";
                    }
                    return name;
                }
                if (index == 1) {
                    return v.getTypedValue().getTypeName();
                }
                if (index >= 2 && index < 5) {
                    return DbgVariablesFragment.this.formatCell(v.getTypedValue(), index - 2);
                }
            }
            if (element instanceof ITypedValue) {
                v = (ITypedValue)element;
                if (index == 0) {
                    return "";
                }
                if (index == 1) {
                    return v.getTypeName();
                }
                if (index >= 2 && index < 5) {
                    return DbgVariablesFragment.this.formatCell((ITypedValue)v, index - 2);
                }
            }
            return AbstractArrayGroupFilteredTreeContentProvider.getStringAt(this, element, index);
        }
    }

    class ValueEditingSupport
    extends EditingSupport {
        private static final int COLUMN_VALUE = 0;
        private static final int COLUMN_EXTRA = 1;
        private static final int COLUMN_TYPE = 2;
        ColumnViewer columnVviewer;
        TextCellEditor editor;
        int index;

        public ValueEditingSupport(ColumnViewer viewer, int index) {
            super(viewer);
            this.columnVviewer = viewer;
            Composite parent = (Composite)viewer.getControl();
            this.editor = new TextCellEditor(parent);
            this.index = index;
        }

        @Override
        protected CellEditor getCellEditor(Object element) {
            if (!(element instanceof IDebuggerVariable)) {
                return null;
            }
            return this.editor;
        }

        @Override
        protected boolean canEdit(Object element) {
            if (!(element instanceof IDebuggerVariable)) {
                return false;
            }
            IDebuggerVariable v = (IDebuggerVariable)element;
            ITypedValue t = v.getTypedValue();
            if (this.index == 0) {
                return v.canEditValue();
            }
            if (this.index == 1) {
                if (t instanceof AbstractValueNumber) {
                    return v.canEditValue() && !(t instanceof ValueFloat) && !(t instanceof ValueDouble);
                }
            } else if (this.index == 2) {
                return v.canEditType();
            }
            return false;
        }

        @Override
        protected Object getValue(Object element) {
            IDebuggerVariable v = (IDebuggerVariable)element;
            return DbgVariablesFragment.this.formatCell(v.getTypedValue(), this.index);
        }

        @Override
        protected void setValue(Object element, Object value) {
            IDebuggerVariable v = (IDebuggerVariable)element;
            if (this.index == 0 || this.index == 1) {
                boolean success;
                IDebuggerThreadStackFrame frame;
                ITypedValue newValue = this.buildValue(v.getTypedValue(), (String)value);
                if (newValue != null && (frame = DbgVariablesFragment.this.getTargetFrame()) != null && (success = v.setTypedValue(newValue))) {
                    this.columnVviewer.refresh();
                }
            } else if (this.index == 2) {
                String visuType = (String)value;
                (new Object[1])[0] = visuType;
                if (!Strings.isBlank(visuType) && v.setTypeHint(visuType)) {
                    this.columnVviewer.refresh();
                }
            }
        }

        public ITypedValue buildValue(ITypedValue value, String newValue) {
            if (newValue == null) {
                return null;
            }
            if (DbgTypedValueUtil.equals(value, newValue, (IDebuggerUnit)DbgVariablesFragment.this.unit)) {
                return null;
            }
            ITypedValue typedValue = DbgTypedValueUtil.buildValue(value, newValue, (IDebuggerUnit)DbgVariablesFragment.this.unit);
            if (typedValue != null && Objects.equals(typedValue.getValue(), value.getValue())) {
                return null;
            }
            if (typedValue == null) {
                (new Object[1])[0] = newValue;
            }
            return typedValue;
        }
    }

    public class DbgVarContentProvider
    extends AbstractArrayGroupFilteredTreeContentProvider {
        IDebuggerUnit dbg;
        IEventListener listener;

        public DbgVarContentProvider() {
            super(new ArrayGroupProperties(255, 100), 100);
        }

        @Override
        public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && this.listener != null) {
                ((IDebuggerUnit)oldInput).removeListener(this.listener);
                this.listener = null;
            }
            this.dbg = (IDebuggerUnit)newInput;
            if (this.dbg == null) {
                return;
            }
            this.listener = new IEventListener(){

                @Override
                public void onEvent(final IEvent e) {
                    (new Object[1])[0] = e;
                    if (DbgVarContentProvider.this.dbg != null && e.getSource() == DbgVarContentProvider.this.dbg) {
                        UIExecutor.async((Widget)viewer.getControl(), new UIRunnable(){

                            @Override
                            public void runi() {
                                if (DbgVarContentProvider.this.dbg != null && !viewer.getControl().isDisposed()) {
                                    if (e.getType() == J.DbgPause || e.getType() == J.DbgThreadDefault || e.getType() == J.DbgThreadSuspended && DbgVarContentProvider.this.isDefaultThreadEvent(e) || e.getType() == J.DbgTargetEvent && ((IDebuggerEventData)e.getData()).getType() == DebuggerEventType.BREAKPOINT) {
                                        DbgVariablesFragment.this.viewer.refresh(true);
                                        DbgVariablesFragment.this.packColumns(false);
                                    } else if (DbgVariablesFragment.this.stateMaintainer != null) {
                                        TreeStateMaintainer.State<Object> state = DbgVariablesFragment.this.stateMaintainer.saveState();
                                        viewer.refresh();
                                        DbgVariablesFragment.this.packColumns(false);
                                        DbgVariablesFragment.this.stateMaintainer.restoreState(state);
                                    }
                                }
                            }
                        });
                    }
                }
            };
            this.dbg.addListener(this.listener);
        }

        private boolean isDefaultThreadEvent(IEvent e) {
            IDebuggerThreadStackFrame frame = DbgVariablesFragment.this.getTargetFrame();
            return frame != null && frame.getId() != ((Long)e.getData()).longValue();
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (DbgVariablesFragment.this.wFreezeRefresh.getSelection()) {
                return ArrayUtil.NO_OBJECT;
            }
            try {
                boolean debugVarsOnly;
                List<? extends IDebuggerVariable> variables;
                IDebuggerThreadStackFrame frame;
                if (((IDebuggerUnit)DbgVariablesFragment.this.unit).isAttached() && (frame = DbgVariablesFragment.this.getTargetFrame()) != null && (variables = frame.getVariables(debugVarsOnly = DbgVariablesFragment.this.wDebugVarsOnly.getSelection())) != null) {
                    return variables.toArray();
                }
            }
            catch (DebuggerException e) {
                logger.catching(e);
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public Object getParent(Object element) {
            return null;
        }

        @Override
        public boolean hasChildren2(Object element) {
            ITypedValue val = this.getTypedValue(element);
            if (val instanceof AbstractValueComposite) {
                return ((AbstractValueComposite)val).hasChildren();
            }
            return false;
        }

        @Override
        protected String getLabel(Object rx) {
            return null;
        }

        @Override
        public List<?> getChildren2(Object parentElement) {
            ITypedValue val = this.getTypedValue(parentElement);
            if (val instanceof AbstractValueComposite) {
                return ((AbstractValueComposite)val).getValue();
            }
            return null;
        }

        @Override
        public void sort(Object[] elements) {
            DbgVariablesFragment.this.viewer.getComparator().sort(DbgVariablesFragment.this.viewer.getViewer(), elements);
        }

        private ITypedValue getTypedValue(Object parentElement) {
            if (parentElement instanceof IDebuggerVariable) {
                return ((IDebuggerVariable)parentElement).getTypedValue();
            }
            if (parentElement instanceof ITypedValue) {
                return (ITypedValue)parentElement;
            }
            return null;
        }
    }

    static class DbgVarTreeViewerExtension
    implements IFilteredTreeViewerExtension {
        DbgVarTreeViewerExtension() {
        }

        @Override
        public boolean shouldIgnore(List<Object> parents, Object element) {
            return element instanceof IDebuggerVariable && "shadow$_klass_".equals(((IDebuggerVariable)element).getName());
        }

        @Override
        public Boolean isElementMatch(List<Object> parents, Object element, AbstractFilteredFilter filter) {
            return null;
        }

        @Override
        public Boolean shouldExpand(Object root) {
            if (this.shouldIgnore(null, root)) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public Object getKey(Object element) {
            ITypedValue type;
            if (element instanceof IDebuggerVariable && (type = ((IDebuggerVariable)element).getTypedValue()) != null && type.getTypeName() != null) {
                switch (type.getTypeName()) {
                    case "boolean": 
                    case "byte": 
                    case "char": 
                    case "double": 
                    case "float": 
                    case "int": 
                    case "long": 
                    case "short": {
                        Object value = type.getValue();
                        return type + ":" + ((IDebuggerVariable)element).getName() + "=" + (value == null ? "" : value);
                    }
                    case "string": {
                        if (type instanceof ValueString) {
                            ValueString val = (ValueString)type;
                            return "string:" + ((IDebuggerVariable)element).getName() + "=" + val.getObjectId();
                        }
                        Object value = type.getValue();
                        return type + ":" + ((IDebuggerVariable)element).getName() + "=" + (value == null ? "" : value);
                    }
                    case "raw": {
                        return null;
                    }
                }
                if (type instanceof AbstractValueComposite) {
                    AbstractValueComposite val = (AbstractValueComposite)type;
                    return val.getRefTypeId() + ":" + ((IDebuggerVariable)element).getName() + "=" + val.getObjectId();
                }
            }
            return null;
        }

        @Override
        public boolean equals(Object a, Object b) {
            if (a == b || a.equals(b)) {
                return true;
            }
            if (a instanceof IDebuggerVariable && b instanceof IDebuggerVariable) {
                return DebuggerUtil.valueEquals((IDebuggerVariable)a, (IDebuggerVariable)b);
            }
            return false;
        }

        @Override
        public boolean canBeCircular(Object element) {
            if (!(element instanceof IDebuggerVariable)) {
                return true;
            }
            ITypedValue type = ((IDebuggerVariable)element).getTypedValue();
            if (type != null && type.getTypeName() != null) {
                switch (type.getTypeName()) {
                    case "boolean": 
                    case "byte": 
                    case "char": 
                    case "double": 
                    case "float": 
                    case "int": 
                    case "long": 
                    case "short": 
                    case "string": {
                        return false;
                    }
                }
                if (type.getTypeName().startsWith("[")) {
                    String typeName = type.getTypeName();
                    for (int i = 0; i < typeName.length() - 1; ++i) {
                        if (typeName.charAt(i) == '[') continue;
                        return true;
                    }
                    String primitive = JavaUtil.letterToPrimitive(typeName.substring(typeName.length() - 1));
                    if (primitive != null) {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public void onPatternChanged() {
        }
    }

    static class DbgVarTreeStateMaintainer
    extends TreeStateMaintainer<Object> {
        public DbgVarTreeStateMaintainer(TreeViewer viewer) {
            super(viewer);
        }

        @Override
        public boolean likeEquals(Object currentObject, Object previousObject) {
            if (currentObject instanceof IDebuggerVariable && previousObject instanceof IDebuggerVariable) {
                return Strings.equals(((IDebuggerVariable)currentObject).getName(), ((IDebuggerVariable)previousObject).getName());
            }
            return false;
        }
    }
}

