/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerException;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerThreadStatus;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThreadStackFrame;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultStyledCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.PatternTreeViewer;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractNotAddressableUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class DbgThreadsFragment
extends AbstractNotAddressableUnitFragment<IDebuggerUnit>
implements IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(DbgThreadsFragment.class);
    private FilteredTreeViewer viewer;
    private Object lastSelectedNode;
    private String lastAddress;
    private ToolItem wFreezeRefresh;

    public DbgThreadsFragment(Composite parent, int flags, IRcpClientContext context, IDebuggerUnit unit) {
        super(parent, flags, unit, null, context);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        ToolBar toolBar = new ToolBar((Composite)this, 320);
        toolBar.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.wFreezeRefresh = new ToolItem(toolBar, 32);
        this.wFreezeRefresh.setText("Freeze Refresh");
        this.wFreezeRefresh.setSelection(false);
        String info = "If checked, the list of threads is no longer provided.";
        this.wFreezeRefresh.setToolTipText(info);
        this.wFreezeRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DbgThreadsFragment.this.viewer.refresh();
            }
        });
        LabelProvider labelProvider = new LabelProvider();
        boolean expandAfterFilter = context.getPropertyManager().getBoolean(".ui.ExpandTreeNodesOnFiltering");
        String[] titleColumns = new String[]{"Thread ID", "State", "Name"};
        this.viewer = new PatternTreeViewer(this, 65536, titleColumns, null, expandAfterFilter);
        this.viewer.getFilteredTreeWidget().setLayoutData(UIUtil.createGridDataFill(true, true));
        this.viewer.displayTreeAsTable();
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                DbgThreadsFragment.this.handleDoubleClick();
            }
        });
        this.viewer.setContentProvider(new TreeContentProvider());
        this.viewer.setLabelProvider(labelProvider);
        this.viewer.setInput(unit);
        this.packColumns(true);
        this.viewer.addContextMenu(null, null, null, this);
    }

    public void packColumns(boolean force) {
        TreeColumn[] cols;
        for (TreeColumn col : cols = this.viewer.getFilteredTreeWidget().getTree().getColumns()) {
            if (!force && col.getWidth() != 0) continue;
            col.pack();
        }
    }

    public Entry getSelectedNode() {
        ITreeSelection treesel = (ITreeSelection)this.viewer.getSelection();
        if (treesel.isEmpty()) {
            return null;
        }
        Object elt = treesel.getFirstElement();
        if (!(elt instanceof Entry)) {
            return null;
        }
        return (Entry)elt;
    }

    private void handleDoubleClick() {
        Entry e = this.getSelectedNode();
        if (e != null && e.isThread()) {
            IDebuggerThread t = (IDebuggerThread)e.o;
            IDebuggerThread currentThread = ((IDebuggerUnit)this.getUnit()).getDefaultThread();
            if (currentThread == null || currentThread.getId() != t.getId()) {
                ((IDebuggerUnit)this.getUnit()).setDefaultThread(t.getId());
            }
        }
    }

    public FilteredTreeViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        Entry e = this.getSelectedNode();
        if (e != null && e.isThread()) {
            final IDebuggerThread t = (IDebuggerThread)e.o;
            menuMgr.add(new Action("Set as default thread"){

                @Override
                public void run() {
                    ((IDebuggerUnit)DbgThreadsFragment.this.getUnit()).setDefaultThread(t.getId());
                }

                @Override
                public boolean isEnabled() {
                    return ((IDebuggerUnit)DbgThreadsFragment.this.getUnit()).getDefaultThread() != t;
                }
            });
            menuMgr.add(new Action("Resume"){

                @Override
                public void run() {
                    t.resume();
                }

                @Override
                public boolean isEnabled() {
                    return t.getStatus() == DebuggerThreadStatus.PAUSED;
                }
            });
            menuMgr.add(new Action("Suspend"){

                @Override
                public void run() {
                    t.suspend();
                }

                @Override
                public boolean isEnabled() {
                    return t.getStatus() != DebuggerThreadStatus.PAUSED;
                }
            });
        }
        this.addOperationsToContextMenu(menuMgr);
    }

    @Override
    public boolean verifyOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case FIND: {
                return true;
            }
            case COPY: {
                return this.getSelectedNode() != null;
            }
        }
        return false;
    }

    @Override
    public boolean doOperation(OperationRequest req) {
        switch (req.getOperation()) {
            case FIND: {
                this.viewer.getFilteredTreeWidget().setFilterVisibility(true, true);
                return true;
            }
            case COPY: {
                return this.copyObjectToClipboard(this.getSelectedNode());
            }
        }
        return false;
    }

    private boolean copyObjectToClipboard(Object obj) {
        String s;
        if (obj != null && (s = obj.toString()) != null) {
            UIUtil.copyTextToClipboard(s);
            return true;
        }
        return false;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        Entry e = this.getSelectedNode();
        if (this.lastSelectedNode == e && this.lastAddress != null) {
            return this.lastAddress;
        }
        String address = null;
        if (e != null) {
            try {
                if (e.isThread()) {
                    address = ((IDebuggerThread)e.o).getLocation();
                } else if (e.isFrame()) {
                    address = ((IDebuggerThreadStackFrame)e.o).getAddress();
                }
            }
            catch (Exception exception) {}
        }
        this.lastSelectedNode = e;
        this.lastAddress = address;
        return address;
    }

    @Override
    public Object getExtraAddressDetails(String address) {
        if (address == null) {
            return this.getSelectedNode();
        }
        return null;
    }

    @Override
    public byte[] export() {
        return Strings.encodeUTF8(this.viewer.exportToString());
    }

    @Override
    public AbstractUnitFragment.FragmentType getFragmentType() {
        return AbstractUnitFragment.FragmentType.TREE;
    }

    class LabelProvider
    extends DefaultStyledCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 3;
        }

        @Override
        public void update(ViewerCell cell) {
            Entry e = (Entry)cell.getElement();
            if (e != null && e.isThread()) {
                Color col = null;
                try {
                    if (((IDebuggerUnit)DbgThreadsFragment.this.getUnit()).getDefaultThread() != null && ((IDebuggerUnit)DbgThreadsFragment.this.getUnit()).getDefaultThread().getId() == e.id) {
                        col = UIAssetManager.getInstance().getDisplay().getSystemColor(3);
                    }
                }
                catch (Exception exception) {}
                cell.setForeground(col);
            }
            super.update(cell);
        }

        @Override
        public String getStringAt(Object element, int key) {
            Entry e = (Entry)element;
            if (e != null) {
                if (key == 0) {
                    return Long.toString(e.id);
                }
                if (key == 1) {
                    return e.state;
                }
                if (key == 2) {
                    return e.name;
                }
            }
            return null;
        }
    }

    public class TreeContentProvider
    implements IFilteredTreeContentProvider {
        IDebuggerUnit dbg;
        IEventListener listener;

        @Override
        public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && this.listener != null) {
                ((IDebuggerUnit)oldInput).removeListener(this.listener);
                this.listener = null;
            }
            this.dbg = (IDebuggerUnit)newInput;
            if (this.dbg == null) {
                return;
            }
            this.listener = new IEventListener(){

                @Override
                public void onEvent(IEvent e) {
                    (new Object[1])[0] = e;
                    if (TreeContentProvider.this.dbg != null && e.getSource() == TreeContentProvider.this.dbg) {
                        UIExecutor.async((Widget)viewer.getControl(), new UIRunnable(){

                            @Override
                            public void runi() {
                                if (TreeContentProvider.this.dbg != null && !viewer.getControl().isDisposed()) {
                                    Object[] cfr_ignored_0 = new Object[0];
                                    viewer.refresh();
                                    DbgThreadsFragment.this.packColumns(false);
                                }
                            }
                        });
                    }
                }
            };
            this.dbg.addListener(this.listener);
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (DbgThreadsFragment.this.wFreezeRefresh.getSelection()) {
                return ArrayUtil.NO_OBJECT;
            }
            IDebuggerUnit dbg = (IDebuggerUnit)inputElement;
            try {
                List<? extends IDebuggerThread> threads;
                if (dbg.isAttached() && (threads = dbg.getThreads()) != null) {
                    Object[] entries = new Entry[threads.size()];
                    int i = 0;
                    for (IDebuggerThread iDebuggerThread : threads) {
                        entries[i] = Entry.fromThread(iDebuggerThread);
                        ++i;
                    }
                    return entries;
                }
            }
            catch (DebuggerException e) {
                logger.catching(e);
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public Object getParent(Object element) {
            return null;
        }

        @Override
        public boolean hasChildren(Object element) {
            if (element instanceof Entry && ((Entry)element).isThread()) {
                IDebuggerThread t = (IDebuggerThread)((Entry)element).o;
                return t.getStatus() == DebuggerThreadStatus.PAUSED;
            }
            return false;
        }

        @Override
        public Object[] getChildren(Object element) {
            IDebuggerThread t = (IDebuggerThread)((Entry)element).o;
            if (t.getStatus() == DebuggerThreadStatus.PAUSED) {
                try {
                    List<? extends IDebuggerThreadStackFrame> frames = t.getFrames();
                    if (frames != null) {
                        Object[] entries = new Entry[frames.size()];
                        int i = 0;
                        for (IDebuggerThreadStackFrame iDebuggerThreadStackFrame : frames) {
                            entries[i] = Entry.fromStackframe(iDebuggerThreadStackFrame);
                            ++i;
                        }
                        return entries;
                    }
                }
                catch (DebuggerException debuggerException) {}
            }
            return ArrayUtil.NO_OBJECT;
        }
    }

    static class Entry {
        Object o;
        long id;
        String state;
        String name;

        Entry() {
        }

        static Entry fromThread(IDebuggerThread t) {
            Entry e = new Entry();
            e.o = t;
            e.id = t.getId();
            e.state = t.getStatus().toString();
            e.name = t.getName();
            return e;
        }

        static Entry fromStackframe(IDebuggerThreadStackFrame f) {
            Entry e = new Entry();
            e.o = f;
            e.id = f.getId();
            e.state = "";
            e.name = f.getAddress();
            return e;
        }

        boolean isThread() {
            return this.o instanceof IDebuggerThread;
        }

        boolean isFrame() {
            return this.o instanceof IDebuggerThreadStackFrame;
        }
    }
}

