/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.DebuggerListener;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractStaticTextFragment;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DbgLogFragment
extends AbstractStaticTextFragment<IUnit> {
    public DbgLogFragment(Composite parent, int flags, IRcpClientContext context, final IDebuggerUnit unit) {
        super(parent, flags, context, unit);
        this.setLayout((Layout)new FillLayout());
        DebuggerListener listener = DebuggerListener.listenTo(unit, context);
        unit.getParent().addListener(new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (e.getData() == unit && e.getType() == J.UnitDestroyed) {
                    DebuggerListener.stopListening(unit);
                    e.getSource().removeListener(this);
                }
            }
        });
        Document doc = listener.getLog();
        final TextViewer viewer = this.buildSimple(this, 768);
        viewer.setDocument(doc);
        StyledText ctl = viewer.getTextWidget();
        ctl.setBackground(UIAssetManager.getInstance().getColor(0xF0F0F0));
        ctl.setFont(context.getFontManager().getCodeFont());
        viewer.addTextListener(new ITextListener(){

            @Override
            public void textChanged(TextEvent event) {
                viewer.setTopIndex(viewer.getTextWidget().getLineCount());
            }
        });
        new ContextMenu((Control)viewer.getTextWidget()).addContextMenu(menuMgr -> this.addOperationsToContextMenu(menuMgr));
    }
}

