/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.IAnchor;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.AbstractTextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.Anchor;
import com.pnfsoftware.jeb.core.output.text.impl.Line;
import com.pnfsoftware.jeb.core.output.text.impl.TextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.impl.TextItem;
import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IProcessor;
import com.pnfsoftware.jeb.core.units.code.asm.processor.IRegisterData;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerThreadStatus;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerThread;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerVirtualMemory;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.primitives.Booleans;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class DbgCodeDocument
extends AbstractTextDocument {
    private static final ILogger logger = GlobalLog.getLogger(DbgCodeDocument.class);
    private static final int maxBytesPerLine = 16;
    private IDebuggerUnit unit;
    private TreeMap<Long, IInstruction> insns = new TreeMap();
    private TreeMap<Long, Boolean> pcInsns = new TreeMap();
    private TreeSet<Long> unreachableAddresses = new TreeSet();
    private Chunk chunk = new Chunk();
    private ViewType viewType = ViewType.CODE;

    public DbgCodeDocument(IDebuggerUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Can not build a DbgCodeDocument with a null unit");
        }
        this.unit = unit;
    }

    public void removeInsn(long anchorId) {
        this.insns.remove(anchorId);
    }

    public boolean hasInsnAt(long anchorId) {
        return this.insns.containsKey(anchorId);
    }

    public Long getNextInsnAddress(long anchorId) {
        return this.insns.higherKey(anchorId);
    }

    public long getInsnAddressAt(long anchorId, int columnOffset) {
        int offset;
        int addressPrefixLength = this.formatAddress(anchorId).length();
        if (columnOffset < addressPrefixLength) {
            return anchorId;
        }
        long maxOffset = anchorId % 16L;
        maxOffset = maxOffset == 0L ? 16L : maxOffset;
        Long nextAddress = this.getNextInsnAddress(anchorId);
        if (nextAddress != null) {
            maxOffset = Math.min(nextAddress - anchorId, maxOffset);
        }
        if ((long)(offset = (columnOffset - addressPrefixLength) / 3) < maxOffset) {
            return anchorId + (long)offset;
        }
        return anchorId;
    }

    public IInstruction getInsnAt(long address) {
        return this.insns.get(address);
    }

    public boolean forceInsnAt(long address) {
        return this.forceInsnAt(address, 0);
    }

    /*
     * Loose catch block
     */
    public boolean forceInsnAt(long address, int procMode) {
        boolean created;
        block12: {
            IProcessor<? extends IInstruction> proc = this.unit.getProcessor();
            int mode = proc.getMode();
            if (procMode == 0) {
                proc.setMode(proc.getDefaultMode());
            } else {
                proc.setMode(procMode);
            }
            int alignment = proc.getInstructionAlignment();
            address = address / (long)alignment * (long)alignment;
            created = this.updateInstructions(proc, this.chunk.toRelative(address), this.chunk.read, false);
            try {
                proc.setMode(mode);
            }
            catch (ProcessorException processorException) {
                logger.error("Inner error: Mode %d can not be restored", mode);
            }
            break block12;
            catch (ProcessorException processorException) {
                boolean bl;
                try {
                    logger.warning("Can not set mode %d to processor %s", procMode, this.unit.getTargetInformation().getProcessorType());
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        proc.setMode(mode);
                    }
                    catch (ProcessorException processorException2) {
                        logger.error("Inner error: Mode %d can not be restored", mode);
                    }
                    throw throwable;
                }
                try {
                    proc.setMode(mode);
                }
                catch (ProcessorException processorException3) {
                    logger.error("Inner error: Mode %d can not be restored", mode);
                }
                return bl;
            }
        }
        return created;
    }

    @Override
    public long getAnchorCount() {
        IDebuggerTargetInformation targetInfo = this.unit.getTargetInformation();
        if (targetInfo == null || targetInfo.getProcessorType() == null || targetInfo.getProcessorType().is64Bit()) {
            return Long.MAX_VALUE;
        }
        return 0xFFFFFFFFL;
    }

    private boolean addInstruction(long address, IInstruction insn, boolean usePC) {
        SortedMap<Long, IInstruction> collisions = this.insns.subMap(address, address + (long)insn.getSize());
        Long previousInsnAddress = this.insns.floorKey(address - 1L);
        if (previousInsnAddress != null && previousInsnAddress + (long)this.insns.get(previousInsnAddress).getSize() > address) {
            collisions = this.insns.subMap(previousInsnAddress, address + (long)insn.getSize());
        }
        if (collisions.isEmpty()) {
            this.insns.put(address, insn);
            if (usePC) {
                this.pcInsns.put(address, usePC);
            }
            return true;
        }
        if (usePC) {
            ArrayList<Long> toRemove = new ArrayList<Long>();
            for (Map.Entry<Long, IInstruction> insnEntry : collisions.entrySet()) {
                if (Booleans.toBoolean(this.pcInsns.get(insnEntry.getKey()))) {
                    toRemove.clear();
                    break;
                }
                toRemove.add(insnEntry.getKey());
            }
            if (!toRemove.isEmpty()) {
                for (Long removed : toRemove) {
                    this.insns.remove(removed);
                    this.pcInsns.remove(removed);
                }
                this.insns.put(address, insn);
                this.pcInsns.put(address, usePC);
                return true;
            }
        }
        return false;
    }

    private boolean updateInstructions(IProcessor<? extends IInstruction> proc, int from, int size, boolean usePC) {
        if (size <= 0) {
            return false;
        }
        SortedMap<Long, IInstruction> subInsns = this.insns.subMap(this.chunk.toAbsolute(0), this.chunk.toAbsolute(size));
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (Map.Entry<Long, IInstruction> insnEntry : subInsns.entrySet()) {
            int relativeAddress = this.chunk.toRelative(insnEntry.getKey());
            if (!this.memoryChanged(insnEntry.getValue().getCode(), relativeAddress)) continue;
            toRemove.add(insnEntry.getKey());
        }
        for (Long removed : toRemove) {
            this.insns.remove(removed);
            this.pcInsns.remove(removed);
        }
        SortedSet<Long> subAdresses = this.unreachableAddresses.subSet(this.chunk.toAbsolute(from), this.chunk.toAbsolute(size));
        TreeSet<Long> subAddressesCopy = new TreeSet<Long>(subAdresses);
        for (Long addr : subAddressesCopy) {
            this.processBlock(proc, this.chunk.toRelative(addr), size, usePC);
        }
        subAdresses.clear();
        return this.processBlock(proc, from, size, usePC);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processBlock(IProcessor<? extends IInstruction> proc, int from, int size, boolean usePC) {
        int currentAddress;
        boolean created = false;
        try {
            IInstruction insn;
            for (currentAddress = from; currentAddress < size; currentAddress += insn.getSize()) {
                long absoluteAddress = this.chunk.toAbsolute(currentAddress);
                insn = this.insns.get(absoluteAddress);
                if (insn != null) {
                    if (!usePC || Booleans.toBoolean(this.pcInsns.get(absoluteAddress))) return created;
                    this.pcInsns.put(absoluteAddress, usePC);
                } else {
                    insn = proc.parseAt(this.chunk.data, currentAddress, size);
                    boolean newcreated = this.addInstruction(absoluteAddress, insn, usePC);
                    created |= newcreated;
                }
                IFlowInformation flow = insn.getBreakingFlow(absoluteAddress);
                if (flow.isBroken()) {
                    boolean shouldContinue = false;
                    for (ICodePointer desc : flow.getTargets()) {
                        if (desc.getAddress() == absoluteAddress + (long)insn.getSize()) {
                            shouldContinue = true;
                            continue;
                        }
                        if (this.chunk.isReachable(desc.getAddress())) {
                            this.processBlock(proc, this.chunk.toRelative(desc.getAddress()), size, usePC);
                            continue;
                        }
                        if (!usePC) continue;
                        this.processUnreachableAddress(desc.getAddress());
                    }
                    if (!shouldContinue) {
                        return created;
                    }
                }
                if (!(flow = insn.getRoutineCall(absoluteAddress)).isBroken()) continue;
                for (ICodePointer desc : flow.getTargets()) {
                    if (this.chunk.isReachable(desc.getAddress())) {
                        this.processBlock(proc, this.chunk.toRelative(desc.getAddress()), size, usePC);
                        continue;
                    }
                    if (!usePC) continue;
                    this.processUnreachableAddress(desc.getAddress());
                }
            }
            return created;
        }
        catch (ProcessorException | RuntimeException e) {
            logger.error("Unable to process instruction at %Xh: %s", this.chunk.toAbsolute(currentAddress), e.getMessage());
        }
        return created;
    }

    private boolean memoryChanged(byte[] code, int relativeAddress) {
        for (int i = 0; i < code.length && relativeAddress + i < this.chunk.read; ++i) {
            if (code[i] == this.chunk.data[relativeAddress + i]) continue;
            return true;
        }
        return false;
    }

    private void processUnreachableAddress(long address) {
        IInstruction insn = this.insns.get(address);
        if (insn == null) {
            this.unreachableAddresses.add(address);
        } else if (!Booleans.toBoolean(this.pcInsns.get(address))) {
            this.pcInsns.put(address, Boolean.TRUE);
        }
    }

    @Override
    public ITextDocumentPart getDocumentPart(long anchorId, int linesAfter, int linesBefore) {
        IDebuggerVirtualMemory vm;
        if (this.unit.isAttached() && this.unit.getDefaultThread() != null && this.unit.getDefaultThread().getStatus() == DebuggerThreadStatus.PAUSED && (vm = this.unit.getMemory()) != null) {
            this.chunk.update(anchorId, linesAfter, linesBefore);
            if (this.chunk.read == -1) {
                return TextDocumentPart.EMPTY;
            }
            ArrayList<ILine> lines = new ArrayList<ILine>();
            ArrayList<IAnchor> anchors = new ArrayList<IAnchor>();
            if (this.viewType == ViewType.CODE) {
                this.populateChunkInstructions(anchorId);
                SortedMap<Long, IInstruction> subInsns = this.insns.subMap(this.chunk.firstAddress, this.chunk.toAbsolute(this.chunk.data.length));
                long notProcessedAddress = this.chunk.firstAddress;
                for (Map.Entry<Long, IInstruction> insn : subInsns.entrySet()) {
                    if (notProcessedAddress != insn.getKey()) {
                        this.formatMemory(lines, anchors, this.chunk.toRelative(notProcessedAddress), this.chunk.toRelative(insn.getKey()));
                        lines.add(ILine.EMPTY_LINE);
                    }
                    lines.add(this.formatInsn(insn.getValue(), insn.getKey()));
                    anchors.add(new Anchor(insn.getKey(), lines.size() - 1));
                    if (insn.getValue().getBreakingFlow(insn.getKey()).isBroken() || insn.getValue().getRoutineCall(insn.getKey()).isBroken()) {
                        lines.add(ILine.EMPTY_LINE);
                    }
                    notProcessedAddress = insn.getKey() + (long)insn.getValue().getSize();
                }
                if (!lines.isEmpty() && ((ILine)lines.get(lines.size() - 1)).getText().length() != 0) {
                    lines.add(ILine.EMPTY_LINE);
                }
                this.formatMemory(lines, anchors, this.chunk.toRelative(notProcessedAddress), this.chunk.data.length);
                return new TextDocumentPart(lines, anchors);
            }
            this.formatMemory(lines, anchors, 0, this.chunk.data.length);
            return new TextDocumentPart(lines, anchors);
        }
        return TextDocumentPart.EMPTY;
    }

    private void populateChunkInstructions(long anchorId) {
        int mode;
        IProcessor<? extends IInstruction> proc;
        block24: {
            proc = this.unit.getProcessor();
            List<? extends IDebuggerThread> rawThreads = this.unit.getThreads();
            ArrayList<IDebuggerThread> threads = rawThreads == null ? new ArrayList<IDebuggerThread>() : new ArrayList<IDebuggerThread>(rawThreads);
            IDebuggerThread thread = this.unit.getDefaultThread();
            ProcessorType processorType = this.unit.getTargetInformation().getProcessorType();
            mode = proc.getMode();
            HashMap<Long, Integer> pcs = new HashMap<Long, Integer>();
            try {
                boolean foundAnchorId = false;
                if (thread != null) {
                    threads.remove(thread);
                    threads.add(0, thread);
                }
                for (IDebuggerThread iDebuggerThread : threads) {
                    IRegisterData registers = iDebuggerThread.getRegisters();
                    if (registers == null || !this.chunk.isReachable(registers.getProgramCounter())) continue;
                    foundAnchorId = true;
                    if (processorType == ProcessorType.ARM) {
                        int procMode = (registers.getFlags() & 0x20L) != 0L ? 16 : 32;
                        try {
                            proc.setMode(procMode);
                        }
                        catch (ProcessorException processorException) {
                            logger.warning("Can not set mode %d to processor ARM", procMode);
                        }
                        pcs.put(registers.getProgramCounter(), procMode);
                    } else {
                        pcs.put(registers.getProgramCounter(), null);
                    }
                    this.updateInstructions(proc, this.chunk.toRelative(registers.getProgramCounter()), this.chunk.read, true);
                }
                if (foundAnchorId) {
                    block17: for (Map.Entry entry : pcs.entrySet()) {
                        IInstruction insn;
                        try {
                            proc.setMode(entry.getValue() != null ? (Integer)entry.getValue() : mode);
                        }
                        catch (ProcessorException processorException) {
                            logger.warning("Can not set mode %d to processor ARM", entry.getValue() != null ? (Integer)entry.getValue() : mode);
                        }
                        int alignment = proc.getInstructionAlignment();
                        int relativeAddress = this.chunk.toRelative((Long)entry.getKey());
                        relativeAddress -= alignment;
                        while (relativeAddress >= 0 && (insn = this.insns.get(this.chunk.toAbsolute(relativeAddress))) == null) {
                            block23: {
                                try {
                                    insn = proc.parseAt(this.chunk.data, relativeAddress, this.chunk.read);
                                    this.addInstruction(this.chunk.toAbsolute(relativeAddress), insn, false);
                                }
                                catch (Exception exception) {
                                    if (processorType != ProcessorType.ARM) continue block17;
                                    try {
                                        if ((relativeAddress -= alignment) < 0) break block23;
                                        insn = proc.parseAt(this.chunk.data, relativeAddress, this.chunk.read);
                                        this.addInstruction(this.chunk.toAbsolute(relativeAddress), insn, false);
                                    }
                                    catch (ProcessorException processorException) {
                                        continue block17;
                                    }
                                }
                            }
                            relativeAddress -= alignment;
                        }
                    }
                    break block24;
                }
                try {
                    this.updateInstructions(proc, this.chunk.toRelative(anchorId), this.chunk.read, false);
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                try {
                    proc.setMode(mode);
                }
                catch (ProcessorException processorException) {
                    logger.error("Inner error: Mode %d can not be restored", mode);
                }
                throw throwable;
            }
        }
        try {
            proc.setMode(mode);
        }
        catch (ProcessorException processorException) {
            logger.error("Inner error: Mode %d can not be restored", mode);
        }
    }

    private void formatMemory(List<ILine> lines, List<IAnchor> anchors, int from, int to) {
        int i = from;
        while (i < to) {
            long absoluteAddress = this.chunk.toAbsolute(i);
            StringBuilder stb = new StringBuilder();
            String addressStr = this.formatAddress(absoluteAddress);
            stb.append(addressStr);
            if ((i & 0xF) != 0) {
                bytesToDisplay = Math.min(16 - (i & 0xF), to - i);
                this.appendLine(stb, i, bytesToDisplay);
                i += bytesToDisplay;
            } else {
                bytesToDisplay = Math.min(16, Math.min(this.chunk.read - i, to - i));
                this.appendLine(stb, i, bytesToDisplay);
                i += 16;
            }
            lines.add(new Line(stb, Arrays.asList(new TextItem(0, addressStr.length() - 2, ItemClassIdentifiers.ADDRESS))));
            anchors.add(new Anchor(absoluteAddress, lines.size() - 1));
        }
    }

    private StringBuilder formatReadableMemory(int from, int bytesToDisplay) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < bytesToDisplay; ++j) {
            byte b = this.chunk.data[from + j];
            if (b >= 32 && b < 127) {
                Strings.ff(sb, "%c", b);
                continue;
            }
            sb.append('.');
        }
        return sb;
    }

    private void appendLine(StringBuilder stb, int from, int bytesToDisplay) {
        if (this.chunk.isReachableRel(from) && this.chunk.isReachableRel(from + bytesToDisplay - 1)) {
            stb.append(Formatter.formatBinaryLineTruncate(this.chunk.data, from, bytesToDisplay, 16)).append(' ');
            stb.append((CharSequence)this.formatReadableMemory(from, bytesToDisplay));
        } else {
            stb.append(Formatter.formatBinaryLineTruncate(this.chunk.data, from, 0, 16)).append(' ');
        }
    }

    private Line formatInsn(IInstruction insn, long address) {
        StringBuilder stb = new StringBuilder();
        String addressStr = this.formatAddress(address);
        stb.append(addressStr);
        CharSequence bytecode = Formatter.formatBinaryLineTruncate(insn.getCode(), 0, insn.getSize(), 8);
        stb.append(bytecode).append(' ');
        stb.append(insn.format(address));
        return new Line(stb.toString(), Arrays.asList(new TextItem(0, addressStr.length() - 2, ItemClassIdentifiers.ADDRESS), new TextItem(addressStr.length(), bytecode.length(), ItemClassIdentifiers.BYTECODE)));
    }

    private String formatAddress(long address) {
        int memspace = this.unit.getMemory().getSpaceBits();
        String s = memspace <= 32 ? Strings.ff("%08X  ", address) : (memspace <= 64 ? Strings.ff("%08X'%08X  ", (int)(address >> 32), (int)address) : Strings.ff("%16X  ", address));
        return s;
    }

    public void switchViewType() {
        switch (this.viewType) {
            case CODE: {
                this.viewType = ViewType.MEMORY;
                break;
            }
            case MEMORY: {
                this.viewType = ViewType.CODE;
                break;
            }
            default: {
                this.viewType = ViewType.MEMORY;
            }
        }
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    private class Chunk {
        private byte[] data;
        private int minRead = 0;
        private int read;
        long firstAddress;

        private Chunk() {
        }

        void update(long anchorId, int linesAfter, int linesBefore) {
            int memspace = DbgCodeDocument.this.unit.getMemory().getSpaceBits();
            this.firstAddress = anchorId - (long)(linesBefore * 16) & 0xFFFFFFFFFFFFFFF0L;
            if (this.firstAddress < 0L) {
                this.firstAddress = 0L;
            }
            long longSize = ((long)linesBefore + (long)linesAfter + 1L) * 16L;
            int size = (int)Math.min(longSize, 0x100000L);
            if (memspace <= 32) {
                if (this.firstAddress + (long)size > 0xFFFFFFFFL) {
                    size = this.firstAddress > 0xFFFFFFFFL ? 0 : (int)(0x100000000L - this.firstAddress);
                }
            } else if (memspace <= 64 && this.firstAddress + (long)size > Long.MAX_VALUE) {
                size = this.firstAddress > Long.MAX_VALUE ? 0 : (int)(Long.MIN_VALUE - this.firstAddress);
            }
            this.data = new byte[size];
            this.minRead = 0;
            this.read = DbgCodeDocument.this.unit.readMemory(this.firstAddress, size, this.data, 0);
            if (this.read == -1) {
                this.minRead = this.toRelative(anchorId & 0xFFFFFFFFFFFFFFF0L);
                if (size - this.minRead > 0) {
                    this.read = DbgCodeDocument.this.unit.readMemory(this.firstAddress + (long)this.minRead, size - this.minRead, this.data, 0);
                    if (this.read == -1) {
                        this.minRead = 0;
                    }
                    this.read += this.minRead;
                } else {
                    this.minRead = 0;
                }
            }
        }

        boolean isReachable(long address) {
            return address >= this.firstAddress + (long)this.minRead && address < this.firstAddress + (long)this.read;
        }

        boolean isReachableRel(int address) {
            return this.isReachable(this.firstAddress + (long)address);
        }

        int toRelative(long address) {
            return (int)(address - this.firstAddress);
        }

        long toAbsolute(int address) {
            return (long)address + this.firstAddress;
        }
    }

    static enum ViewType {
        MEMORY,
        CODE;

    }
}

