/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.debuggers;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ITableEventListener;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractFilteredTableFragment;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DbgBreakpointsFragment
extends AbstractFilteredTableFragment<IDebuggerUnit, IDebuggerBreakpoint>
implements IContextMenu {
    private static final ILogger logger = GlobalLog.getLogger(DbgBreakpointsFragment.class);

    public DbgBreakpointsFragment(Composite parent, int style, IRcpClientContext context, IDebuggerUnit unit) {
        super(parent, style, unit, null, context, new BreakpointProvider(), new LabelProvider());
        this.setLayout((Layout)new FillLayout());
        if (unit == null) {
            throw new RuntimeException();
        }
        FilteredTableViewer viewer = this.buildSimple(this, 36, new String[]{S.s(52), S.s(351)});
        this.setRefreshListener(viewer, e -> e.getSource() == unit);
        viewer.setCheckStateProvider(new ICheckStateProvider(){

            @Override
            public boolean isGrayed(Object element) {
                return false;
            }

            @Override
            public boolean isChecked(Object element) {
                return DbgBreakpointsFragment.this.getProvider().isChecked(element);
            }
        });
        viewer.getControl().addTableKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                IDebuggerBreakpoint elt = DbgBreakpointsFragment.this.getSelectedRow();
                if (e.keyCode == 127 && elt != null && elt instanceof IDebuggerBreakpoint) {
                    ((IDebuggerUnit)DbgBreakpointsFragment.this.getUnit()).clearBreakpoint(elt);
                    e.doit = false;
                }
                super.keyReleased(e);
            }
        });
    }

    @Override
    protected void initFilteredView(FilteredTableView view) {
        view.setFilterVisibility(false, false);
        view.addTableEventListener(new ITableEventListener(){

            @Override
            public void onTableEvent(Object row, boolean isSelected, boolean isChecked) {
                Object[] objectArray = new Object[]{row, isSelected, isChecked};
                IDebuggerUnit dbg = (IDebuggerUnit)DbgBreakpointsFragment.this.getUnit();
                IDebuggerBreakpoint bp = (IDebuggerBreakpoint)row;
                if (dbg.isAttached()) {
                    bp.setEnabled(isChecked);
                }
            }
        });
        new ContextMenu((Control)view.getMainElement()).addContextMenu(this);
        if (view.getShadowElement() != null) {
            new ContextMenu((Control)view.getShadowElement()).addContextMenu(this);
        }
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        IDebuggerBreakpoint elt = this.getSelectedRow();
        if (elt instanceof IDebuggerBreakpoint) {
            final IDebuggerBreakpoint bp = elt;
            menuMgr.add(new Action("Remove"){

                @Override
                public void run() {
                    ((IDebuggerUnit)DbgBreakpointsFragment.this.getUnit()).clearBreakpoint(bp);
                }
            });
        }
        this.addOperationsToContextMenu(menuMgr);
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        IDebuggerBreakpoint o = this.getSelectedRow();
        if (!(o instanceof IDebuggerBreakpoint)) {
            return null;
        }
        String address = o.getAddress();
        return address;
    }

    @Override
    protected boolean isCorrectRow(Object obj) {
        return obj instanceof IDebuggerBreakpoint;
    }

    @Override
    public IDebuggerBreakpoint getSelectedRow() {
        Object row = this.getSelectedRawRow();
        if (!(row instanceof IDebuggerBreakpoint)) {
            return null;
        }
        return (IDebuggerBreakpoint)row;
    }

    static class BreakpointProvider
    implements IFilteredTableContentProvider {
        BreakpointProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            List<? extends IDebuggerBreakpoint> breakpoints;
            IDebuggerUnit unit = (IDebuggerUnit)inputElement;
            if (unit.isAttached() && unit.isAttached() && (breakpoints = unit.getBreakpoints()) != null) {
                return breakpoints.toArray();
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public boolean isChecked(Object row) {
            IDebuggerBreakpoint bp = (IDebuggerBreakpoint)row;
            return bp.isEnabled();
        }
    }

    static class LabelProvider
    extends DefaultCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public String getStringAt(Object element, int key) {
            int flags;
            IDebuggerBreakpoint bp = (IDebuggerBreakpoint)element;
            if (key == 0) {
                return bp.getAddress();
            }
            if (key == 1 && (flags = bp.getFlags()) != 0) {
                Object str = "";
                if ((flags & 1) != 0) {
                    str = (String)str + "ON_READ ";
                    flags &= 0xFFFFFFFE;
                }
                if ((flags & 2) != 0) {
                    str = (String)str + "ON_WRITE ";
                    flags &= 0xFFFFFFFD;
                }
                if (flags != 0) {
                    str = (String)str + Strings.ff("UNKNOWN_0x%X ", flags);
                }
                return str;
            }
            return null;
        }
    }
}

