/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.codeobject;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolType;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractDataFrameFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IRcpUnitView;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderCellItem;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class CodeLoaderSymbolsFragment
extends AbstractDataFrameFragment<ICodeObjectUnit> {
    private int symbolFlag;
    private DataFrameView dfv;

    public CodeLoaderSymbolsFragment(Composite parent, int style, IRcpClientContext context, IRcpUnitView unitView, ICodeObjectUnit co, int symbolFlag, INativeCodeUnit<?> pbcu) {
        super(parent, style, co, unitView, context);
        this.setLayout((Layout)new FillLayout());
        this.symbolFlag = symbolFlag;
        this.dfv = this.buildSimple(this, "Type", "Flags", "Name", "Identifier", "Symbol@", "Address", "Size");
    }

    @Override
    protected void initDataFrame(DataFrame df) {
        df.setRenderedBaseForNumberObjects(16);
        if ((this.symbolFlag & 2) != 0) {
            long a = ((ICodeObjectUnit)this.getUnit()).getLoaderInformation().getEntryPoint();
            SymbolInformation s = new SymbolInformation(SymbolType.PTRFUNCTION, 2, -1L, "start", 0L, a, 0L);
            this.addSymbolAsRow(df, s);
        }
        for (ISymbolInformation iSymbolInformation : ((ICodeObjectUnit)this.getUnit()).getSymbols()) {
            if ((iSymbolInformation.getFlags() & this.symbolFlag) != this.symbolFlag) continue;
            this.addSymbolAsRow(df, iSymbolInformation);
        }
    }

    private void addSymbolAsRow(DataFrame df, ISymbolInformation s) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(CodeLoaderSymbolsFragment.formatSymbolType(s.getType()));
        row.add(CodeLoaderSymbolsFragment.formatSymbolFlags(s.getFlags()));
        row.add(s.getName());
        row.add(s.getIdentifier());
        row.add(s.getRelativeAddress());
        row.add(s.getSymbolRelativeAddress());
        row.add(s.getSymbolSize());
        df.addRow(row);
    }

    private static String formatSymbolType(SymbolType type) {
        return type == null ? "" : type.toString();
    }

    private static String formatSymbolFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 2) != 0) {
            sb.append("EXPORT ");
            flags &= 0xFFFFFFFD;
        }
        if ((flags & 1) != 0) {
            sb.append("IMPORT ");
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 4) != 0) {
            sb.append("CONTI. ");
            flags &= 0xFFFFFFFB;
        }
        if ((flags & 8) != 0) {
            sb.append("ABS. ");
            flags &= 0xFFFFFFF7;
        }
        if ((flags & 0x10) != 0) {
            flags &= 0xFFFFFFEF;
        }
        if (flags != 0) {
            Strings.ff(sb, "(other:%Xh) ", flags);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public IItem getActiveItem() {
        TableItem sel = this.dfv.getActiveSelection();
        if (sel != null) {
            return new CodeLoaderCellItem((ICodeObjectUnit)this.unit, sel.getText(2), sel.getText(5));
        }
        return null;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        IItem item = this.getActiveItem();
        if (item instanceof CodeLoaderCellItem) {
            return ((CodeLoaderCellItem)item).getAddress();
        }
        return null;
    }
}

