/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.codeobject;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractDataFrameFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderCellItem;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class CodeLoaderSegmentsFragment
extends AbstractDataFrameFragment<ICodeObjectUnit> {
    private boolean segmentsOrNotSections;
    private DataFrameView dfv = null;

    public CodeLoaderSegmentsFragment(Composite parent, int style, IRcpClientContext context, ICodeObjectUnit unit, boolean segmentsOrNotSections) {
        super(parent, style, unit, null, context);
        this.setLayout((Layout)new FillLayout());
        this.segmentsOrNotSections = segmentsOrNotSections;
        this.dfv = this.buildSimple(this, "Name", "Flags", "Offset in File", "Size in File", "Offset in Memory", "Size in Memory");
    }

    @Override
    protected void initDataFrame(DataFrame df) {
        df.setRenderedBaseForNumberObjects(16);
        Collection<? extends ISegmentInformation> list = this.segmentsOrNotSections ? ((ICodeObjectUnit)this.unit).getSegments() : ((ICodeObjectUnit)this.unit).getSections();
        if (list == null) {
            list = new ArrayList<ISegmentInformation>();
        }
        for (ISegmentInformation iSegmentInformation : list) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(iSegmentInformation.getName());
            row.add(CodeLoaderSegmentsFragment.formatSegmentFlags(iSegmentInformation.getFlags()));
            row.add(iSegmentInformation.getOffsetInFile());
            row.add(iSegmentInformation.getSizeInFile());
            row.add(iSegmentInformation.getOffsetInMemory());
            row.add(iSegmentInformation.getSizeInMemory());
            df.addRow(row);
        }
    }

    private static String formatSegmentFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 2) != 0) {
            sb.append("READ ");
            flags &= 0xFFFFFFFD;
        }
        if ((flags & 1) != 0) {
            sb.append("WRTE ");
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 4) != 0) {
            sb.append("EXEC ");
            flags &= 0xFFFFFFFB;
        }
        if ((flags & Integer.MIN_VALUE) != 0) {
            sb.append("SYNT ");
            flags &= Integer.MAX_VALUE;
        }
        if ((flags & 0x40000000) != 0) {
            sb.append("ALCW ");
            flags &= 0xBFFFFFFF;
        }
        if ((flags & 0x20000000) != 0) {
            sb.append("INVD ");
            flags &= 0xDFFFFFFF;
        }
        if (flags != 0) {
            Strings.ff(sb, "(other:%X)", flags);
        }
        return sb.toString().trim();
    }

    @Override
    public IItem getActiveItem() {
        TableItem sel = this.dfv.getActiveSelection();
        if (sel != null) {
            return new CodeLoaderCellItem((ICodeObjectUnit)this.unit, sel.getText(0), sel.getText(4));
        }
        return null;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        IItem item = this.getActiveItem();
        if (item instanceof CodeLoaderCellItem) {
            return ((CodeLoaderCellItem)item).getAddress();
        }
        return null;
    }
}

