/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.codeobject;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.codeobject.CodeObjectUnitUtil;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ILoaderInformation;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractDataFrameFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderCellItem;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class CodeLoaderInfoFragment
extends AbstractDataFrameFragment<ICodeObjectUnit> {
    private DataFrameView dfv;

    public CodeLoaderInfoFragment(Composite parent, int style, IRcpClientContext context, ICodeObjectUnit unit) {
        super(parent, style, unit, null, context);
        this.setLayout((Layout)new FillLayout());
        ILoaderInformation info = ((ICodeObjectUnit)this.getUnit()).getLoaderInformation();
        if (info == null) {
            return;
        }
        this.dfv = this.buildSimple(this, "Field", "Value");
    }

    @Override
    protected void initDataFrame(DataFrame df) {
        df.setRenderedBaseForNumberObjects(16);
        ILoaderInformation info = ((ICodeObjectUnit)this.getUnit()).getLoaderInformation();
        df.addRow("Processor", Strings.safe(info.getTargetProcessor()));
        df.addRow(new Object[]{"Endianness", info.getEndianness()});
        df.addRow("Word Size", info.getWordSize() + " bits");
        df.addRow("Subsystem", Strings.safe(info.getTargetSubsystem()));
        df.addRow("Version", info.getVersion());
        df.addRow("Flags", CodeLoaderInfoFragment.formatObjectFlags(info.getFlags()));
        long ts = info.getCompilationTimestamp();
        df.addRow("Compilation Time", ts == 0L ? "" : TimeFormatter.formatTimestampLocal(ts));
        df.addRow("Image Base", info.getImageBase());
        INativeCodeUnit<?> childCodeUnit = CodeObjectUnitUtil.getUniqueNativeCodeUnitChild((ICodeObjectUnit)this.getUnit());
        if (childCodeUnit != null) {
            df.addRow("Image Base (Real)", childCodeUnit.getVirtualImageBase());
        }
        df.addRow("Image Size", info.getImageSize());
        df.addRow("Entry-Point", info.getEntryPoint());
        df.addRow("Overlay Offset", info.getOverlayOffset());
        df.addRow("Notes", info.getNotes());
    }

    private static String formatObjectFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) != 0) {
            sb.append("HAS_SYMBOLS ");
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 2) != 0) {
            sb.append("HAS_RELOCATION ");
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 4) != 0) {
            sb.append("LIBRARY_FILE ");
            flags &= 0xFFFFFFFB;
        }
        if ((flags & 8) != 0) {
            sb.append("OBJECT_FILE ");
            flags &= 0xFFFFFFF7;
        }
        if ((flags & 0x10) != 0) {
            sb.append("PURE_CODE ");
            flags &= 0xFFFFFFEF;
        }
        if ((flags & 0x20) != 0) {
            sb.append("IS_RELOCATABLE ");
            flags &= 0xFFFFFFDF;
        }
        if (flags != 0) {
            Strings.ff(sb, "(other:%Xh)", flags);
        }
        return sb.toString();
    }

    @Override
    public IItem getActiveItem() {
        TableItem sel = this.dfv.getActiveSelection();
        if (sel != null) {
            List<Integer> rows = this.dfv.getSelectedRows();
            if (rows == null || rows.size() != 1) {
                return null;
            }
            int row = rows.get(0);
            if (row == 7 || row == 9) {
                return new CodeLoaderCellItem((ICodeObjectUnit)this.unit, sel.getText(0), sel.getText(1), row != 7);
            }
        }
        return null;
    }

    @Override
    public String getActiveAddress(AddressConversionPrecision precision) {
        IItem item = this.getActiveItem();
        if (item instanceof CodeLoaderCellItem) {
            return ((CodeLoaderCellItem)item).getAddress();
        }
        return null;
    }
}

