/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.codeobject;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.table.IVisualCell;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.codeobject.CodeObjectUnitUtil;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.util.format.Strings;

public class CodeLoaderCellItem
implements IVisualCell {
    private ICodeObjectUnit unit;
    private String name;
    private long offset;
    private boolean relative;

    public CodeLoaderCellItem(ICodeObjectUnit unit, String name, String offset) {
        this(unit, name, offset, true);
    }

    public CodeLoaderCellItem(ICodeObjectUnit unit, String name, String offset, boolean relative) {
        this.unit = unit;
        this.name = name;
        if (offset.endsWith("h")) {
            offset = offset.substring(0, offset.length() - 1);
        }
        try {
            this.offset = Long.parseLong(offset, 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.offset = -1L;
        }
        this.relative = relative;
    }

    @Override
    public String getLabel() {
        return this.name;
    }

    @Override
    public ItemClassIdentifiers getClassId() {
        return ItemClassIdentifiers.DEFAULT;
    }

    public String getAddress() {
        INativeCodeUnit<?> nativeCodeUnit;
        if (this.offset < 0L) {
            return null;
        }
        long address = this.offset;
        if (this.relative && this.unit != null && (nativeCodeUnit = CodeObjectUnitUtil.getUniqueNativeCodeUnitChild(this.unit)) != null) {
            address += nativeCodeUnit.getVirtualImageBase();
        }
        return Strings.ff("%Xh", address);
    }
}

