/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.NativeTypeDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.NativeTypeEditorView;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.StructEditorAction;
import com.pnfsoftware.jeb.util.format.Strings;

public class StructEditorActionSetType
extends StructEditorAction {
    public StructEditorActionSetType(NativeTypeEditorView v) {
        super("Set Type", v);
        this.keyCode = 121;
        this.setAccelerator(89);
    }

    @Override
    public boolean isEnabled() {
        return this.v.getSelectedEntry() != null;
    }

    @Override
    public void run() {
        if (!this.verifyType()) {
            return;
        }
        ItemEntry e = this.v.getSelectedEntry();
        if (e == null) {
            return;
        }
        String currentFieldSig = "";
        if (e.type != null) {
            currentFieldSig = e.type.getSignature(true);
        }
        NativeTypeDialog dlg = new NativeTypeDialog(this.v.getShell(), 0, null, null, this.v.getInputUnit());
        dlg.setInitialValue(currentFieldSig);
        String fieldSig = dlg.open();
        if (fieldSig == null) {
            return;
        }
        IStructureType structType = this.v.getSelectedStructure();
        ITypeManager typeman = structType.getTypeManager();
        INativeType fieldType = typeman.getType(fieldSig);
        if (fieldType == null) {
            UI.error(Strings.ff("The type \"%s\" was not found", fieldSig));
            return;
        }
        if (StructEditorActionSetType.setFieldType(this.v, e, structType, fieldType)) {
            this.v.refresh();
        }
    }

    static boolean setFieldType(NativeTypeEditorView v, ItemEntry e, IStructureType structType, INativeType newFieldType) {
        if (newFieldType == e.type) {
            return false;
        }
        if (structType.isCircular(newFieldType)) {
            UI.error("A cycle was detected: a structure cannot contain itself");
            return false;
        }
        if (!StructEditorActionSetType.offerClearFields(v, structType, e.offset, newFieldType.getSize())) {
            return false;
        }
        if (structType.getTypeManager().addStructureField(structType, e.name, newFieldType, e.offset, 0, 0, 0) == null) {
            UI.error(Strings.ff("A field of type \"%s\" could not be created at offset %Xh", newFieldType.getName(true), e.offset));
            return false;
        }
        return true;
    }
}

