/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.parts.units.code;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IStructureTypeField;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.AdaptivePopupDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.operations.JebAction;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.ItemEntry;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.NativeTypeEditorView;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;

public abstract class StructEditorAction
extends JebAction {
    protected NativeTypeEditorView v;

    public StructEditorAction(String name, NativeTypeEditorView v) {
        super(null, name);
        this.v = v;
        this.isContextual = true;
    }

    protected boolean verifyType() {
        IStructureType t = this.v.getSelectedStructure();
        ITypeManager typeman = this.v.getInputUnit().getTypeManager();
        if (typeman != t.getTypeManager()) {
            Integer r = this.v.assumedResponseForTypeImportPopup;
            if (r == null) {
                AdaptivePopupDialog dlg = AdaptivePopupDialog.question3(this.v.getShell(), "Confirm", "This type belongs to a type library. It is recommended to import this type instead of modifying it directly.\n\nClick Yes to import the type, or No to directly modify this type.");
                r = dlg.open();
                if (r == null) {
                    return false;
                }
                if (dlg.isDoNotShow()) {
                    this.v.assumedResponseForTypeImportPopup = r;
                }
            }
            if (r == 1) {
                IStructureType t1 = (IStructureType)typeman.getType(t.getSignature(true));
                if (t1 == null) {
                    UI.error("An error occurred when attempting to import this type.");
                } else {
                    UI.info("The type was imported and copied to the project, you may now edit it safely.");
                }
                this.v.setSelectedType(t1);
                return false;
            }
        }
        return true;
    }

    protected IStructureTypeField getSelectedField() {
        ItemEntry e = this.v.getSelectedEntry();
        if (e != null) {
            return this.v.getSelectedStructure().getFieldAt(e.offset);
        }
        return null;
    }

    protected List<IStructureTypeField> collectFieldsToBeUndefined(int startOffset, int wantedSize) {
        return StructEditorAction.collectFieldsToBeUndefined(this.v.getSelectedStructure(), startOffset, wantedSize);
    }

    static List<IStructureTypeField> collectFieldsToBeUndefined(IStructureType type, int startOffset, int wantedSize) {
        ArrayList<IStructureTypeField> r = new ArrayList<IStructureTypeField>();
        int offset = startOffset;
        IStructureTypeField f = type.getFieldOver(offset);
        if (f != null) {
            r.add(f);
        }
        while ((f = type.getFieldAfter(offset)) != null && f.getOffset() - startOffset < wantedSize) {
            offset = f.getOffset();
            r.add(f);
        }
        return r;
    }

    protected boolean undefineFields(List<IStructureTypeField> fields) {
        return StructEditorAction.undefineFields(this.v.getSelectedStructure(), fields);
    }

    static boolean undefineFields(IStructureType type, List<IStructureTypeField> fields) {
        ITypeManager typeman = type.getTypeManager();
        for (IStructureTypeField field : fields) {
            if (typeman.removeStructureField(type, field)) continue;
            return false;
        }
        return true;
    }

    protected boolean offerClearFields(int offset, int size) {
        return StructEditorAction.offerClearFields(this.v, this.v.getSelectedStructure(), offset, size);
    }

    static boolean offerClearFields(NativeTypeEditorView v, IStructureType type, int offset, int size) {
        List<IStructureTypeField> r = StructEditorAction.collectFieldsToBeUndefined(type, offset, size);
        if (r.size() > 1) {
            boolean allowUndefine;
            if (v != null && v.allowUndefine != null) {
                allowUndefine = v.allowUndefine;
            } else {
                String msg = Strings.ff("This action will undefine %d fields. Proceed?", r.size() - 1);
                AdaptivePopupDialog dlg2 = AdaptivePopupDialog.question(UI.getShellTracker().get(), S.s(207), msg);
                boolean bl = allowUndefine = dlg2.open() == 1;
                if (dlg2.isDoNotShow() && v != null) {
                    v.allowUndefine = allowUndefine;
                }
            }
            if (!allowUndefine) {
                return false;
            }
        }
        if (!StructEditorAction.undefineFields(type, r)) {
            UI.error("An error occurred while undefining fields.");
            return false;
        }
        return true;
    }
}

